/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.comet;

import com.aptana.ide.server.jetty.comet.ICometClient;
import dojox.cometd.Bayeux;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ClientLoader {
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String CLIENT_ELEMENT = "client";
    public static final String PORTLET_EXTENSION = "com.aptana.ide.server.jetty.cometClient";
    private List<ICometClient> clients = new ArrayList<ICometClient>();

    private ClientLoader(Bayeux bayeux) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PORTLET_EXTENSION);
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement element = iConfigurationElementArray[n];
            if (CLIENT_ELEMENT.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String className = element.getAttribute(CLASS_ATTRIBUTE);
                if (id != null && className != null) {
                    try {
                        Object client = element.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (client instanceof ICometClient && this.getClient(id) == null) {
                            ICometClient cometClient = (ICometClient)client;
                            cometClient.setID(id);
                            cometClient.init(bayeux);
                            this.clients.add(cometClient);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++n;
        }
    }

    public ICometClient getClient(String id) {
        if (id == null) {
            return null;
        }
        for (ICometClient c : this.clients) {
            if (!id.equals(c.getID())) continue;
            return c;
        }
        return null;
    }

    public ICometClient[] getClients() {
        return this.clients.toArray(new ICometClient[0]);
    }

    public static ClientLoader loadClients(Bayeux bayeux) {
        return new ClientLoader(bayeux);
    }

    public void destroy() {
        if (this.clients != null) {
            this.clients.clear();
        }
    }
}

