/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.comet;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.comet.ICometClient;
import com.aptana.ide.server.jetty.comet.ListenerAdapter;
import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.Message;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class CometClient
extends ListenerAdapter
implements ICometClient {
    protected Bayeux bayeux = null;
    protected String id = null;
    protected Client client = null;
    private List<Channel> channels = new ArrayList<Channel>();

    public void init(Bayeux bayeux) {
        this.bayeux = bayeux;
        this.client = this.bayeux.newClient(this.getID());
        this.client.addListener((EventListener)((Object)this));
        String[] stringArray = this.getSubscriptionIDs();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String channelId = stringArray[n];
            Channel cometChannel = this.bayeux.getChannel(channelId, true);
            cometChannel.subscribe(this.client);
            this.channels.add(cometChannel);
            ++n;
        }
    }

    public void destroy() {
        for (Channel channel : this.channels) {
            channel.unsubscribe(this.client);
        }
        if (this.client != null) {
            this.client.removeListener((EventListener)((Object)this));
        }
        this.bayeux = null;
        this.channels.clear();
        this.client = null;
    }

    public Channel[] getChannels() {
        return this.channels.toArray(new Channel[0]);
    }

    protected abstract String[] getSubscriptionIDs();

    public void deliver(final Client fromClient, Client toClient, final Message msg) {
        if (fromClient != this.client) {
            IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)("Received comet message on channel: " + msg.getChannel() + " with content: " + StringUtils.getPublishableMessage((Object)msg.getData())));
            Job job = new Job("Publishing comet message"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Object response = CometClient.this.getResponse(msg.getChannel(), msg.getData());
                        if (response != null) {
                            Channel channel;
                            Object channelObject;
                            String replyChannel = null;
                            if (msg.getData() instanceof Map && (channelObject = ((Map)msg.getData()).get("returnChannel")) != null) {
                                replyChannel = channelObject.toString();
                            }
                            if (replyChannel == null) {
                                replyChannel = CometClient.this.getReplyChannel(msg.getChannel(), fromClient.getId());
                            }
                            String rId = CometClient.this.getID(msg.getId());
                            Bayeux localBayeux = CometClient.this.bayeux;
                            if (localBayeux != null && (channel = localBayeux.getChannel(replyChannel, true)) != null) {
                                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)("Responding on comet channel: " + replyChannel + " with message: " + StringUtils.getPublishableMessage((Object)response) + " and message id:" + rId));
                                channel.publish(CometClient.this.client, response, rId);
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error generating/publishing comet response", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(40);
            job.schedule();
        }
    }

    protected abstract Object getResponse(String var1, Object var2);

    protected abstract String getID(String var1);

    protected String getReplyChannel(String toChannel, String publisherId) {
        return toChannel;
    }

    public void removed(String clientId, boolean timeout) {
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        if (id != null && this.id == null) {
            this.id = id;
        }
    }
}

