/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.comet;

import com.aptana.ide.core.online.IOnlineStateChangedListener;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.server.jetty.comet.CometClient;
import dojox.cometd.Channel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class OnlineDetectorClient
extends CometClient {
    private static final String NETWORK_ONLINE_CHANNEL = "/portal/network/online";
    public static final String CHECK_ONLINE_STATUS = "checkOnlineStatus";
    public static final String ONLINE_STATE_CHANGE = "onlineStateChange";
    public static final String ADD_URL = "addURL";
    public static final String STATUS = "status";
    public static final String OLD_STATUS = "old_status";
    public static final String URL_MONITOR = "url";
    private IOnlineStateChangedListener onlineStateChangeListener = new IOnlineStateChangedListener(){

        public void stateChanged(OnlineDetectionService.StatusMode oldState, OnlineDetectionService.StatusMode newState) {
            HashMap<String, String> responseData = new HashMap<String, String>();
            responseData.put("response", OnlineDetectorClient.ONLINE_STATE_CHANGE);
            responseData.put(OnlineDetectorClient.STATUS, newState.toString());
            responseData.put(OnlineDetectorClient.OLD_STATUS, oldState.toString());
            Channel channel = OnlineDetectorClient.this.bayeux.getChannel(OnlineDetectorClient.NETWORK_ONLINE_CHANNEL, true);
            if (channel != null) {
                channel.publish(OnlineDetectorClient.this.client, responseData, OnlineDetectorClient.this.getID(null));
            }
        }
    };

    public OnlineDetectorClient() {
        OnlineDetectionService.getInstance();
        OnlineDetectionService.addListener((IOnlineStateChangedListener)this.onlineStateChangeListener);
    }

    public void destroy() {
        OnlineDetectionService.getInstance();
        OnlineDetectionService.removeListener((IOnlineStateChangedListener)this.onlineStateChangeListener);
        super.destroy();
    }

    protected Object getResponse(String toChannel, Object request) {
        if (NETWORK_ONLINE_CHANNEL.equals(toChannel) && request instanceof Map) {
            Map requestData = (Map)request;
            if (CHECK_ONLINE_STATUS.equals(requestData.get("request"))) {
                HashMap<String, String> response = new HashMap<String, String>();
                response.put("response", CHECK_ONLINE_STATUS);
                response.put(STATUS, OnlineDetectionService.getInstance().getStatus().toString());
                return response;
            }
            if (ADD_URL.equals(requestData.get("request"))) {
                String url = (String)requestData.get(URL_MONITOR);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("response", ADD_URL);
                if (url != null) {
                    try {
                        OnlineDetectionService.getInstance().addDetectionURL(new URL(url));
                    }
                    catch (MalformedURLException e) {
                        response.put("errors", new String[]{e.getMessage()});
                    }
                    return response;
                }
                response.put("errors", new String[]{"'url' is null"});
            }
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{NETWORK_ONLINE_CHANNEL};
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }
}

