/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.browser.BaseBrowserAdapter;
import com.aptana.ide.core.ui.browser.BrowserRegistry;
import com.aptana.ide.core.ui.browser.IBrowser;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.portal.IPortalEditorClient;
import com.aptana.ide.server.jetty.portal.Messages;
import com.aptana.ide.server.jetty.portal.PortalEditorInput;
import com.aptana.ide.server.jetty.portal.PortalServer;
import com.eaio.uuid.MACAddress;
import dojox.cometd.Client;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.mortbay.cometd.ChannelImpl;

public class PortalEditor
extends EditorPart
implements LocationListener {
    public static final String ID = "com.aptana.ide.server.jetty.PortalEditor";
    public static final String ACTION_LOGIN = "login";
    public static final String ACTION_CHOOSEPROJECT = "chooseProject";
    public static final String ACTION_DEPLOY = "deploy";
    public static final IEditorInput INPUT = new PortalEditorInput();
    private static final String EXTENSION_NAME = "editorClient";
    private static final String EXTENSION_POINT = "com.aptana.ide.server.jetty.editorClient";
    private static final String EXTENSION_ATTRIBUTE = "client";
    private static final String CLASS_ATTRIBUTE = "class";
    private static String tab = null;
    private static IProject project = null;
    private static String product = null;
    private static boolean login = false;
    private static boolean chooseProject = false;
    private static boolean deploy = false;
    private static boolean shouldUpdate = false;
    private static String currentLocation = null;
    private static List<IPortalEditorClient> clients = new ArrayList<IPortalEditorClient>();
    private static boolean open;
    private Composite displayArea;
    private IBrowser browser;
    private Label initLabel;
    private IModelListener listener = new IModelListener(){

        public void modelChanged(IModifiableObject object) {
            User user;
            if (object instanceof User && !(user = (User)object).hasCredentials()) {
                PortalServer.getServer().restart();
                if (PortalEditor.isOpen()) {
                    PortalEditor.this.updateContent();
                }
            }
        }
    };
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (PortalEditor.ID.equals(part.getSite().getId())) {
                this.log("mc.closed");
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (PortalEditor.ID.equals(part.getSite().getId())) {
                this.log("mc.opened");
            }
        }

        private void log(String eventType) {
            EventLogger.getInstance().logEvent(eventType);
        }
    };

    private static void parseExtension() {
        IConfigurationElement[] elements;
        if (clients.size() > 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            String className;
            IConfigurationElement element = iConfigurationElementArray[n];
            if (element.getName().equals(EXTENSION_ATTRIBUTE) && (className = element.getAttribute(CLASS_ATTRIBUTE)) != null) {
                try {
                    Object client = element.createExecutableExtension(CLASS_ATTRIBUTE);
                    if (client instanceof IPortalEditorClient) {
                        clients.add((IPortalEditorClient)client);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n;
        }
    }

    public static void openPortalEditor(String initialTab) {
        shouldUpdate = initialTab != null && (tab == null || !initialTab.equals(tab));
        PortalEditor.openPortalEditor(initialTab, null, null, true);
    }

    public static void openPortalEditorToProduct(String initialProduct) {
        PortalEditor.openPortalEditor(null, initialProduct, null, true);
    }

    public static void openPortalEditor() {
        PortalEditor.openPortalEditor(true);
    }

    public static void reloadPortalEditor() {
        shouldUpdate = true;
        PortalServer.getServer().restart();
        PortalEditor.openPortalEditor(null, null, null, true);
    }

    public static void signIn() {
        if (PortalEditor.isOpen()) {
            String portalLocation = PortalEditor.getCurrentLocation();
            String jettyBaseURL = PortalServer.getServer().getBaseURL().toExternalForm();
            if (portalLocation != null && portalLocation.startsWith(jettyBaseURL)) {
                PortalEditor.ideOpenEditor(true);
                PortalEditor.sendLoginEvent();
            } else {
                PortalServer.getServer().restart();
                PortalEditor.openPortalEditor(ACTION_LOGIN);
            }
        } else {
            PortalEditor.openPortalEditor(ACTION_LOGIN);
        }
    }

    public static void openSampleDeployment() {
        if (PortalEditor.isOpen()) {
            PortalServer.getServer().restart();
        }
        PortalEditor.openPortalEditor(ACTION_CHOOSEPROJECT);
    }

    public static void openPortalEditor(boolean activate) {
        PortalEditor.openPortalEditor(null, null, null, activate);
    }

    public static void openPortalEditor(IProject deployProject) {
        PortalEditor.openPortalEditor(null, null, deployProject, true);
    }

    public static void openDeploymentWizard(IProject deployProject) {
        PortalEditor.openPortalEditor(ACTION_DEPLOY, null, deployProject, true);
    }

    private static void openPortalEditor(String initialTab, String initialProduct, IProject deployProject, boolean activate) {
        tab = initialTab;
        product = initialProduct;
        project = deployProject;
        if (ACTION_LOGIN.equals(tab)) {
            tab = null;
            login = true;
        } else if (ACTION_CHOOSEPROJECT.equals(tab)) {
            tab = null;
            chooseProject = true;
        } else if (ACTION_DEPLOY.equals(tab)) {
            tab = null;
            deploy = true;
        }
        PortalEditor.ideOpenEditor(activate);
    }

    public static void ideOpenEditor(boolean activate) {
        IWorkbenchWindow window = JettyPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            try {
                if (PortalEditor.isOpen()) {
                    IEditorPart part = page.findEditor(INPUT);
                    if (part != null && activate) {
                        page.activate((IWorkbenchPart)part);
                        if (part instanceof PortalEditor && shouldUpdate) {
                            ((PortalEditor)part).updateContent();
                        }
                    }
                } else {
                    IDE.openEditor((IWorkbenchPage)page, (IEditorInput)INPUT, (String)ID, (boolean)activate);
                }
                shouldUpdate = false;
            }
            catch (PartInitException partInitException) {}
        }
    }

    public static boolean isOpen() {
        return open;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        AptanaUser.getSignedInUser().removeListener(this.listener);
        super.dispose();
        open = false;
        tab = null;
        project = null;
        product = null;
        login = false;
        chooseProject = false;
        shouldUpdate = false;
        currentLocation = null;
        try {
            if (this.browser != null && !this.browser.getControl().isDisposed()) {
                this.browser.removeLocationListener((LocationListener)this);
                this.browser.dispose();
                this.browser = null;
            }
        }
        catch (Exception exception) {}
        Runnable runnable = new Runnable(){

            public void run() {
                PortalServer.getServer().restart();
            }
        };
        new Thread(runnable, "Restarting Jetty").start();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        site.getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        open = true;
        if (input != INPUT) {
            input = INPUT;
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(Messages.PortalEditor_Title);
        this.setTitleToolTip(Messages.PortalEditor_TitleTooltip);
        JettyPlugin.getDefault().getPreferenceStore().setValue("PortalEditorPreviouslyOpened", false);
        Job listenerJob = new Job("Adding listener for My Aptana"){

            protected IStatus run(IProgressMonitor monitor) {
                AptanaUser.getSignedInUser().addListener(PortalEditor.this.listener);
                return Status.OK_STATUS;
            }
        };
        listenerJob.setPriority(40);
        listenerJob.schedule();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout();
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initLabel = new Label(this.displayArea, 0);
        this.initLabel.setText(Messages.PortalEditor_Loading);
        this.initLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        if (JettyPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.server.jetty.preferences.USE_FIREFOX") && CoreUIUtils.onWindows) {
            this.browser = BrowserRegistry.getRegistry().getBrowser("com.aptana.ide.xul.firefox");
        }
        if (this.browser == null) {
            this.browser = new BaseBrowserAdapter();
        }
        this.browser.createControl(this.displayArea);
        this.browser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addLocationListener((LocationListener)this);
        this.updateContent();
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }

    public void changed(LocationEvent event) {
        currentLocation = event.location;
        PortalEditor.parseExtension();
        for (IPortalEditorClient client : clients) {
            client.locationChanged(this.browser, event);
        }
    }

    public void changing(LocationEvent event) {
        PortalEditor.parseExtension();
        for (IPortalEditorClient client : clients) {
            client.locationChanging(this.browser, event);
        }
    }

    public static String getCurrentLocation() {
        return currentLocation;
    }

    private static void sendLoginEvent() {
        ChannelImpl channel = PortalServer.getServer().getBayeux().getChannel("/portal/user");
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("response", "showLogin");
        Client client = PortalServer.getServer().getBayeux().newClient(PortalEditor.getID(null));
        channel.publish(client, responseData, PortalEditor.getID(null));
    }

    private static String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }

    private void setURL(final String url) {
        currentLocation = url;
        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PortalEditor.this.browser != null && !PortalEditor.this.browser.getControl().isDisposed()) {
                    PortalEditor.this.browser.setURL(url);
                    if (PortalEditor.this.initLabel != null && !PortalEditor.this.initLabel.isDisposed()) {
                        PortalEditor.this.initLabel.dispose();
                        PortalEditor.this.displayArea.layout();
                    }
                }
            }
        });
    }

    private void updateContent() {
        String url;
        String macAddress;
        String studioID;
        String commonParams = "";
        ApplicationPreferences instance = ApplicationPreferences.getInstance();
        if (instance != null && (studioID = instance.getString("ide-id")) != null) {
            commonParams = String.valueOf(commonParams) + "&studioid=" + studioID;
        }
        if ((macAddress = MACAddress.getMACAddress()) != null) {
            commonParams = String.valueOf(commonParams) + "&macaddress=" + macAddress;
        }
        if (deploy) {
            deploy = false;
            try {
                String params = "";
                String encoding = "UTF-8";
                if (project != null) {
                    params = "project_name=" + URLEncoder.encode(project.getName(), encoding);
                    StringBuilder type = new StringBuilder();
                    try {
                        String[] natureIds = project.getDescription().getNatureIds();
                        if (natureIds != null && natureIds.length > 0) {
                            String[] stringArray = natureIds;
                            int n = 0;
                            int n2 = stringArray.length;
                            while (n < n2) {
                                String nature = stringArray[n];
                                type.append(nature);
                                type.append(',');
                                ++n;
                            }
                            if (type.length() > 0) {
                                type.deleteCharAt(type.length() - 1);
                            }
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                        return;
                    }
                    params = String.valueOf(params) + "&project_type=";
                    params = type.length() == 0 ? String.valueOf(params) + URLEncoder.encode("unknown", encoding) : String.valueOf(params) + URLEncoder.encode(type.toString(), encoding);
                }
                params = String.valueOf(params) + commonParams;
                User signedInUser = AptanaUser.getSignedInUser();
                if (signedInUser != null && signedInUser.hasCredentials()) {
                    params = String.valueOf(params) + "&username=" + URLEncoder.encode(signedInUser.getUsername(), encoding);
                    params = String.valueOf(params) + "&password=" + URLEncoder.encode(signedInUser.getPassword(), encoding);
                }
                params = String.valueOf(params) + "&command_image_url=" + URLEncoder.encode(String.valueOf(PortalServer.getServer().getBaseURL().toExternalForm()) + "/command.gif", encoding);
                url = "https://acotak-staging.aptana.com/cloud".equals(System.getProperty("CLOUD_URL_OVERRIDE")) ? "https://staging-deploy.aptana.com/portal" : "https://deploy.aptana.com/portal";
                url = String.valueOf(url) + "?" + params;
            }
            catch (UnsupportedEncodingException e) {
                IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                return;
            }
        }
        url = PortalServer.getServer().getStartURL().toExternalForm();
        url = String.valueOf(url) + commonParams;
        if (tab != null) {
            url = String.valueOf(url) + "&tab=" + tab;
        } else if (project != null && project.exists() && project.isOpen()) {
            url = String.valueOf(url) + "&project=" + project.getName().replace(" ", "%20");
        } else if (product != null) {
            url = String.valueOf(url) + "&product=" + product;
        } else if (login) {
            url = String.valueOf(url) + "&login=true";
            login = false;
        } else if (chooseProject) {
            url = String.valueOf(url) + "&chooseProject=true";
            chooseProject = false;
        }
        if (!JettyPlugin.getDefault().getPreferenceStore().getBoolean("shownAlready")) {
            url = String.valueOf(url) + "&firstTime=true";
            JettyPlugin.getDefault().getPreferenceStore().setValue("shownAlready", true);
        }
        this.setURL(url);
    }
}

