/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.AptanaDB;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import com.aptana.ide.server.jetty.JettyPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Plugin;

public class PortalProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final int TIMEOUT = 30000;
    public static final String URL = "url";
    public static final String CLEAR_CACHE = "clearCache";
    private static final String NO_CACHE = "noCache";

    public PortalProxyServlet() {
        this.initCache();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String address = request.getParameter(URL);
        String clearCache = request.getParameter(CLEAR_CACHE);
        String noCache = request.getParameter(NO_CACHE);
        if (clearCache != null && clearCache.equals("true")) {
            this.clearCache();
        }
        if (address != null) {
            if (OnlineDetectionService.getInstance().getStatus() == OnlineDetectionService.StatusMode.OFFLINE) {
                this.serveFromCache(response, address);
                return;
            }
            RemoteContents remoteContents = null;
            try {
                long lastModifiedDate = -1L;
                remoteContents = this.getRemoteContents(lastModifiedDate, address);
            }
            catch (Exception e) {
                e.printStackTrace();
                remoteContents = null;
            }
            if (remoteContents == null) {
                this.serveFromCache(response, address);
                return;
            }
            response.setStatus(200);
            response.setContentLength(remoteContents.data.length);
            FileUtils.pipe((InputStream)new ByteArrayInputStream(remoteContents.data), (OutputStream)response.getOutputStream(), (boolean)true);
            if (!"true".equals(noCache)) {
                this.saveToCache(address, remoteContents);
            }
        }
    }

    /*
     * Loose catch block
     */
    private long getModifiedDateFromCache(String address) {
        block15: {
            Connection conn;
            block14: {
                block13: {
                    long lastModified;
                    AptanaDB db = AptanaDB.getInstance();
                    conn = db.getConnection();
                    String addr = URLEncoder.encode(address, "UTF-8");
                    Statement s = conn.createStatement();
                    ResultSet rs = s.executeQuery("SELECT lastmodified FROM PROXY_CACHE WHERE address='" + addr + "'");
                    boolean result = rs.next();
                    if (!result) break block13;
                    long l = lastModified = rs.getLong("lastmodified");
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    return l;
                    {
                        catch (SQLException e) {
                            e.printStackTrace();
                            break block14;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                        throw throwable;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                break block15;
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return -1L;
    }

    private RemoteContents getRemoteContents(long lastModifiedDate, String address) throws MalformedURLException, IOException, ProtocolException {
        URL url = new URL(address);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            connection.setReadTimeout(30000);
            connection.setDoInput(true);
            long remoteLastModified = 0L;
            ((HttpURLConnection)connection).setRequestMethod("GET");
            ((HttpURLConnection)connection).connect();
            ByteArrayOutputStream fileContents = new ByteArrayOutputStream();
            FileUtils.pipe((InputStream)connection.getInputStream(), (OutputStream)fileContents, (boolean)true);
            RemoteContents contents = new RemoteContents();
            contents.data = fileContents.toByteArray();
            contents.lastModifiedDate = remoteLastModified;
            return contents;
        }
        return null;
    }

    private void serveFromCache(HttpServletResponse response, String address) throws IOException {
        RemoteContents contents = this.getFromCache(address);
        if (contents != null && contents.data != null) {
            FileUtils.pipe((InputStream)new ByteArrayInputStream(contents.data), (OutputStream)response.getOutputStream(), (boolean)true);
            response.setStatus(200);
        } else {
            response.setStatus(503);
        }
    }

    /*
     * Loose catch block
     */
    private RemoteContents getFromCache(String address) {
        block15: {
            Connection conn;
            block14: {
                block13: {
                    AptanaDB db = AptanaDB.getInstance();
                    conn = db.getConnection();
                    String addr = URLEncoder.encode(address, "UTF-8");
                    Statement s = conn.createStatement();
                    ResultSet rs = s.executeQuery("SELECT * FROM PROXY_CACHE WHERE address='" + addr + "'");
                    boolean result = rs.next();
                    if (!result) break block13;
                    RemoteContents contents = new RemoteContents();
                    contents.data = rs.getBytes("data");
                    contents.lastModifiedDate = rs.getLong("lastmodified");
                    RemoteContents remoteContents = contents;
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    return remoteContents;
                    {
                        catch (SQLException e) {
                            e.printStackTrace();
                            break block14;
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                        throw throwable;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                break block15;
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    private void initCache() {
        block3: {
            try {
                if (!PortalProxyServlet.checkTable()) {
                    this.dropTable();
                    AptanaDB.getInstance().execute("CREATE TABLE PROXY_CACHE (lastmodified BIGINT, address varchar(1024) PRIMARY KEY, data BLOB(50000))");
                }
            }
            catch (SQLException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_ErrorInitializingDbConnection, (Throwable)e);
                if (e.getNextException() == null) break block3;
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_ErrorInitializingDbConnection, (Throwable)e.getNextException());
            }
        }
    }

    private static boolean checkTable() throws SQLException {
        boolean result;
        block11: {
            Connection conn = null;
            Statement s = null;
            result = true;
            try {
                try {
                    conn = AptanaDB.getInstance().getConnection();
                    if (conn == null) {
                        SQLException sqle = new SQLException("Connection to AptanaDB is null.");
                        IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)sqle.getMessage());
                        throw sqle;
                    }
                    s = conn.createStatement();
                    s.execute("select address FROM PROXY_CACHE where lastmodified = 0");
                }
                catch (SQLException sqle) {
                    String theError = sqle.getSQLState();
                    if (theError.equals("42X05")) {
                        result = false;
                        break block11;
                    }
                    if (theError.equals("42X04")) {
                        result = false;
                        break block11;
                    }
                    if (theError.equals("42X14") || theError.equals("42821")) {
                        IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)("IncorrectTableDefinition: " + sqle.getMessage()));
                        throw sqle;
                    }
                    IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)("SQLException: " + sqle.getMessage()));
                    throw sqle;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        return result;
    }

    private void clearCache() {
        AptanaDB.getInstance().execute("TRUNCATE PROXY_CACHE");
    }

    private void dropTable() {
        try {
            AptanaDB.getInstance().execute("DROP TABLE PROXY_CACHE");
        }
        catch (Exception exception) {}
    }

    private void saveToCache(String address, RemoteContents contents) {
        block20: {
            Statement prepStmt;
            Connection conn;
            block19: {
                conn = null;
                prepStmt = null;
                String sql = "insert into PROXY_CACHE (lastmodified, address, data) values (?,?,?)";
                try {
                    try {
                        conn = AptanaDB.getInstance().getConnection();
                        prepStmt = conn.prepareStatement(sql);
                        prepStmt.setLong(1, contents.lastModifiedDate);
                        prepStmt.setString(2, URLEncoder.encode(address, "UTF-8"));
                        prepStmt.setBytes(3, contents.data);
                        prepStmt.executeUpdate();
                    }
                    catch (Exception exception) {
                        try {
                            sql = "update PROXY_CACHE set lastmodified = ?, data = ? where address = ?";
                            conn = AptanaDB.getInstance().getConnection();
                            prepStmt = conn.prepareStatement(sql);
                            prepStmt.setLong(1, contents.lastModifiedDate);
                            prepStmt.setBytes(2, contents.data);
                            prepStmt.setString(3, URLEncoder.encode(address, "UTF-8"));
                            prepStmt.executeUpdate();
                        }
                        catch (Exception exception2) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (prepStmt != null) {
                            prepStmt.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (prepStmt != null) {
                        prepStmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    break block20;
                }
                catch (Exception exception) {}
                break block20;
            }
            try {
                if (prepStmt != null) {
                    prepStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    class RemoteContents {
        long lastModifiedDate = 0L;
        byte[] data = null;

        RemoteContents() {
        }
    }
}

