/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.portal.PortalService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalServiceLoader {
    public static final String ID_ATTRIBUTE = "id";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String PORTLET_ELEMENT = "service";
    public static final String PORTLET_EXTENSION = "com.aptana.ide.server.jetty.portalService";
    private static final String PORTAL_URL;
    private static final String PORTAL_XML = "portal.xml";
    private static final String PORTAL_SUFFIX = "portal.";
    private static final String LOCAL_INSTALL_JAR = "from local installation";
    private static PortalServiceLoader loader;
    private List<PortalService> portlets;
    private String portalJar = "from local installation";
    private String currentPortalVersion;
    private AtomicBoolean isDownloading = new AtomicBoolean();
    private List<IPortalListener> listeners;
    private DefaultHandler xmlHandler = new DefaultHandler(){
        private static final String PORTAL = "portal";
        private static final String VERSION = "studio-version";
        private static final String JAR = "jar";
        private static final String CHECKSUM = "checksum";

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            block24: {
                String versionStr;
                VersionRange versionRange;
                if (qName.equals(PORTAL) && (versionRange = new VersionRange(versionStr = attributes.getValue(VERSION))).isIncluded(new Version(PortalServiceLoader.getCoreVersion()))) {
                    ZipInputStream stream;
                    block23: {
                        String subdir;
                        String jar = attributes.getValue(JAR);
                        File configDir = CoreUIUtils.getConfigurationDirectory();
                        String oldJar = PortalServiceLoader.this.portalJar;
                        PortalServiceLoader.this.portalJar = String.valueOf(PORTAL_URL) + "/" + PortalServiceLoader.getUpdateType() + "/" + jar;
                        int index = jar.lastIndexOf(".");
                        String string = subdir = index < 0 ? jar : jar.substring(0, index);
                        if (new File(configDir, subdir).exists()) {
                            return;
                        }
                        File tempDir = new File(configDir, "portal-temp");
                        tempDir.mkdir();
                        stream = null;
                        CRC32 checksum = new CRC32();
                        URL url = null;
                        try {
                            try {
                                JarEntry entry;
                                url = new URL(PortalServiceLoader.this.portalJar);
                                URLConnection conn = url.openConnection();
                                conn.setUseCaches(false);
                                if (conn instanceof HttpURLConnection) {
                                    conn.addRequestProperty("Cache-Control", "no-cache");
                                }
                                conn.setConnectTimeout(10000);
                                CheckedInputStream checkedInput = new CheckedInputStream(conn.getInputStream(), checksum);
                                stream = new JarInputStream(checkedInput);
                                while ((entry = ((JarInputStream)stream).getNextJarEntry()) != null) {
                                    int nread;
                                    File contentFile = new File(tempDir, entry.toString());
                                    if (!contentFile.getParentFile().exists()) {
                                        contentFile.getParentFile().mkdirs();
                                    }
                                    if (entry.isDirectory()) {
                                        contentFile.mkdir();
                                        continue;
                                    }
                                    FileOutputStream out = new FileOutputStream(contentFile);
                                    byte[] b = new byte[10000];
                                    while ((nread = ((JarInputStream)stream).read(b, 0, b.length)) >= 0) {
                                        out.write(b, 0, nread);
                                    }
                                    out.close();
                                }
                                String expectedChecksum = attributes.getValue(CHECKSUM);
                                if (expectedChecksum == null || checksum.getValue() == Long.parseLong(expectedChecksum)) {
                                    FileUtils.copy((File)tempDir, (File)configDir);
                                    FileUtils.deleteDirectory((File)tempDir);
                                    String latestVersion = PortalServiceLoader.this.getLatestPortalVersion();
                                    if (latestVersion.length() > 0 && !latestVersion.equals(PortalServiceLoader.this.currentPortalVersion)) {
                                        PortalServiceLoader.this.currentPortalVersion = latestVersion;
                                        PortalServiceLoader.this.fireNewPortalDownloaded(PortalServiceLoader.this.currentPortalVersion);
                                        PortalServiceLoader.this.copyPortalContents();
                                    }
                                }
                            }
                            catch (Exception e) {
                                String message = url == null ? e.getMessage() : "Failed to parse " + url.toString();
                                IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)message, (Throwable)e);
                                PortalServiceLoader.this.portalJar = oldJar;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block24;
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    };

    static {
        String serverURL = System.getProperty("SERVER_URL");
        if (serverURL == null || serverURL.length() == 0) {
            serverURL = "http://ide.aptana.com";
        }
        PORTAL_URL = String.valueOf(serverURL) + "/portal";
    }

    private PortalServiceLoader() {
        this.portlets = PortalServiceLoader.getInstalledPortalServices();
        this.currentPortalVersion = PortalServiceLoader.getCoreVersion();
        this.listeners = new ArrayList<IPortalListener>();
        this.copyPortalContents();
        Job job = new Job("Downloading portal contents"){

            protected IStatus run(IProgressMonitor monitor) {
                PortalServiceLoader.this.downloadPortalContents();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public PortalService getPortlet(String id) {
        if (id == null) {
            return null;
        }
        for (PortalService p : this.portlets) {
            if (!id.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    public PortalService[] getPortlets() {
        return this.portlets.toArray(new PortalService[0]);
    }

    public static PortalServiceLoader getLoader() {
        if (loader == null) {
            loader = new PortalServiceLoader();
        }
        return loader;
    }

    public String getPortalJarLocation() {
        return this.portalJar;
    }

    public String getPortalFolderLocation() {
        for (PortalService service : this.portlets) {
            if (!service.getId().equals("")) continue;
            return service.getFolder();
        }
        return "";
    }

    public void addListener(IPortalListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IPortalListener listener) {
        this.listeners.remove(listener);
    }

    public void copyPortalContents() {
        File file;
        String id;
        File configDir = CoreUIUtils.getConfigurationDirectory();
        File portalDir = new File(configDir, PORTAL_SUFFIX + this.currentPortalVersion);
        List<PortalService> services = PortalServiceLoader.getInstalledPortalServices();
        for (PortalService service : services) {
            id = service.getId();
            if (!"".equals(id) || (file = new File(portalDir, id)).exists() && System.getProperty("OVERWRITE_PORTAL") == null) continue;
            file.mkdir();
            FileUtils.copy((File)new File(service.getFolder()), (File)file);
        }
        for (PortalService service : services) {
            id = service.getId();
            if ("".equals(id) || (file = new File(portalDir, service.getId())).exists() && System.getProperty("OVERWRITE_PORTAL") == null) continue;
            file.mkdir();
            FileUtils.copy((File)new File(service.getFolder()), (File)file);
        }
    }

    public void switchPortalLocations() {
        File configDir = CoreUIUtils.getConfigurationDirectory();
        String directory = this.getLatestPortalDirectory();
        if (directory.length() == 0) {
            return;
        }
        File portalDir = new File(configDir, directory);
        for (PortalService service : this.portlets) {
            File serviceDir = new File(portalDir, service.getId());
            service.setResource(new File(serviceDir, service.getResourceName()).getAbsolutePath());
        }
    }

    public void downloadPortalContents() {
        if (!this.isDownloading.compareAndSet(false, true)) {
            return;
        }
        URL url = null;
        try {
            try {
                url = new URL(String.valueOf(PORTAL_URL) + "/" + PortalServiceLoader.getUpdateType() + "/" + PORTAL_XML);
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                if (conn instanceof HttpURLConnection) {
                    conn.addRequestProperty("Cache-Control", "no-cache");
                }
                conn.setConnectTimeout(10000);
                InputStream stream = conn.getInputStream();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser saxParser = null;
                saxParser = factory.newSAXParser();
                saxParser.parse(stream, this.xmlHandler);
                stream.close();
            }
            catch (Exception exception) {}
        }
        finally {
            this.isDownloading.set(false);
        }
    }

    private void fireNewPortalDownloaded(String newVersion) {
        for (IPortalListener listener : this.listeners) {
            listener.newPortalDownloaded(newVersion);
        }
    }

    private String getLatestPortalDirectory() {
        String coreVersion;
        int index;
        String baseVersion;
        File configDir = CoreUIUtils.getConfigurationDirectory();
        String[] filenames = configDir.list(new FilenameFilter(baseVersion = PORTAL_SUFFIX + ((index = (coreVersion = this.currentPortalVersion).lastIndexOf(".")) < 0 ? coreVersion : coreVersion.substring(0, index))){
            private final /* synthetic */ String val$baseVersion;
            {
                this.val$baseVersion = string;
            }

            public boolean accept(File file, String filename) {
                return new File(file, filename).isDirectory() && filename.contains(this.val$baseVersion);
            }
        });
        if (filenames == null || filenames.length == 0) {
            return "";
        }
        TreeMap<Float, String> map = new TreeMap<Float, String>();
        String[] stringArray = filenames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            float buildNumber;
            String filename = stringArray[n];
            index = filename.lastIndexOf(baseVersion);
            try {
                buildNumber = Float.parseFloat(filename.substring(index + baseVersion.length()));
            }
            catch (NumberFormatException numberFormatException) {
                buildNumber = Float.MAX_VALUE;
            }
            map.put(new Float(buildNumber), filename);
            ++n;
        }
        return (String)map.get(map.lastKey());
    }

    public String getLatestPortalVersion() {
        String directory = this.getLatestPortalDirectory();
        return directory.length() == 0 ? directory : directory.substring(PORTAL_SUFFIX.length());
    }

    private static String getCoreVersion() {
        return PluginUtils.getPluginVersion((Plugin)CoreUIPlugin.getDefault());
    }

    private static List<PortalService> getInstalledPortalServices() {
        IConfigurationElement[] elements;
        ArrayList<PortalService> services = new ArrayList<PortalService>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PORTLET_EXTENSION);
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement element = iConfigurationElementArray[n];
            if (PORTLET_ELEMENT.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTRIBUTE);
                String resource = element.getAttribute(RESOURCE_ATTRIBUTE);
                if (id != null && resource != null) {
                    URL filePath;
                    String folder;
                    Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                    URL folderPath = bundle.getEntry(folder = resource.substring(0, resource.lastIndexOf("/")));
                    if (folderPath != null) {
                        try {
                            FileLocator.toFileURL((URL)folderPath);
                        }
                        catch (IOException iOException) {}
                    }
                    if ((filePath = bundle.getEntry(resource)) != null) {
                        try {
                            filePath = FileLocator.toFileURL((URL)filePath);
                            PortalService p = new PortalService(id, filePath.getPath());
                            services.add(p);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n;
        }
        return services;
    }

    private static String getUpdateType() {
        return JettyPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.server.jetty.preferences.PORTAL_UPDATE_TYPE");
    }

    public static interface IPortalListener {
        public void newPortalDownloaded(String var1);
    }
}

