/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.portal;

import com.aptana.ide.server.jetty.comet.CometClient;
import com.aptana.ide.server.jetty.portal.PortalEditor;
import com.aptana.ide.server.jetty.portal.PortalServiceLoader;
import dojox.cometd.Channel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class PortalUpdateCometClient
extends CometClient
implements PortalServiceLoader.IPortalListener {
    public static final String PORTAL_UPDATES_CHANNEL = "/portal/updates";
    public static final String EVENT_NEW_VERSION = "newVersion";
    public static final String VERSION = "version";
    public static final String REQUEST_RELOAD = "requestReload";
    public static final String REQUEST_CHECK_UPDATE = "requestCheckUpdate";

    public PortalUpdateCometClient() {
        PortalServiceLoader.getLoader().addListener(this);
    }

    public void destroy() {
        PortalServiceLoader.getLoader().removeListener(this);
        super.destroy();
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }

    protected Object getResponse(String toChannel, Object request) {
        if (PORTAL_UPDATES_CHANNEL.equals(toChannel)) {
            Map requestData = (Map)request;
            if (REQUEST_RELOAD.equals(requestData.get("request"))) {
                UIJob job = new UIJob("Reloading My Aptana page"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PortalEditor.reloadPortalEditor();
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.setSystem(true);
                job.schedule();
            } else if (REQUEST_CHECK_UPDATE.equals(requestData.get("request"))) {
                PortalServiceLoader.getLoader().downloadPortalContents();
            }
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{PORTAL_UPDATES_CHANNEL};
    }

    public void newPortalDownloaded(String version) {
        assert (version != null && version != "");
        this.publishVersion(version);
    }

    void publishVersion(String version) {
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("response", EVENT_NEW_VERSION);
        responseData.put(VERSION, version);
        Channel portalUpdatesChannel = this.bayeux.getChannel(PORTAL_UPDATES_CHANNEL, true);
        portalUpdatesChannel.publish(this.client, responseData, this.getID(null));
    }
}

