/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty.server;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.server.jetty.builder.JettyServerBuilder;
import com.aptana.ide.server.jetty.server.HTMLPreviewHandler;
import com.aptana.ide.server.jetty.server.ProjectDocumentResolver;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsHandler;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsProvider;
import java.net.URI;
import javax.servlet.Servlet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class PreviewServer
extends AbstractServer
implements IStatisticsProvider {
    private Server previewServer;
    private Context context;
    private int port;
    private String serverAddress;
    private String boundName;
    private HTMLPreviewHandler servlet;
    private IStatisticsHandler handler;
    public static final String SERVER_ID = "com.aptana.ide.editor.html.preview.server";
    public static final IPath LOG_PATH = new Path(FileUtils.systemTempDir).append("jetty_preview_server.log");
    public static final int ASSOCIATED_PORT_START = 5374;
    public static final int ASSOCIATE_PORT_END = 5383;

    public IStatus canDelete() {
        return new Status(4, "com.aptana.ide.server.jetty", 4, "Internal Servers can not be deleted", null);
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        this.port = configuration.getIntAttribute("port");
        this.boundName = configuration.getStringAttribute("association_id");
        super.installConfig(configuration);
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setIntAttribute("port", this.port);
        config.setStringAttribute("association_id", this.boundName);
        super.storeConfiguration(config);
    }

    public PreviewServer(IServerType type, IAbstractConfiguration configuration, int state) {
        super(type, configuration);
        this.setServerState(state);
    }

    private void createContext() {
        if (this.servlet == null) {
            this.servlet = new HTMLPreviewHandler();
        }
        this.servlet.setStatisticsHandler(this.handler);
        this.context = new Context((HandlerContainer)this.previewServer, "/", 1);
        this.context.addServlet(new ServletHolder((Servlet)this.servlet), "/");
        if (this.boundName.length() > 0) {
            IServer server = ServerManager.getInstance().findServer(this.boundName);
            if (server != null) {
                JettyServerBuilder.getInstance().buildServer(this.context, SERVER_ID, this.boundName, server.getHostname(), server.getPort(), new ProjectDocumentResolver());
            } else {
                JettyServerBuilder.getInstance().buildServer(this.context, SERVER_ID, this.boundName, this.getHostname(), this.getPort(), new ProjectDocumentResolver());
            }
        }
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", false);
        IStatus status = Status.OK_STATUS;
        if (this.context != null) {
            try {
                this.context.stop();
                this.setServerState(4);
                this.serverChanged();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error stopping preview server context", (Throwable)e);
            }
            this.context.destroy();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.createContext();
        try {
            this.context.start();
            this.setServerState(2);
            PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", true);
            this.serverChanged();
        }
        catch (Exception e) {
            if (this.previewServer != null) {
                try {
                    this.previewServer.stop();
                    this.setServerState(4);
                    this.serverChanged();
                }
                catch (Exception exception) {
                    IdeLog.logError((Plugin)JettyPlugin.getDefault(), (String)"Error stopping preview server", (Throwable)e);
                }
            }
            PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", false);
            status = new Status(4, "com.aptana.ide.server.jetty", 4, "Exception occurred restarting preview server", (Throwable)e);
        }
        return status;
    }

    public IStatus canModify() {
        return new Status(4, "com.aptana.ide.server.jetty", 4, "Internal HTML Preview server can not be modified", null);
    }

    private void launchServer() throws Exception {
        this.previewServer = new Server(this.port);
        RequestLogHandler logger = new RequestLogHandler();
        NCSARequestLog log = new NCSARequestLog(LOG_PATH.toFile().getAbsolutePath());
        log.setLogCookies(true);
        log.setLogLatency(true);
        log.setRetainDays(90);
        log.setAppend(true);
        log.setExtended(true);
        log.setLogTimeZone("GMT");
        logger.setRequestLog((RequestLog)log);
        this.previewServer.addHandler((Handler)logger);
        this.serverAddress = HttpServer.getServerAddress();
        this.previewServer.getConnectors()[0].setHost(this.serverAddress);
        this.createContext();
        this.previewServer.setStopAtShutdown(true);
        this.previewServer.start();
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        try {
            try {
                try {
                    if (this.previewServer != null) {
                        this.previewServer.destroy();
                    }
                    if (this.servlet != null) {
                        this.servlet.setStatisticsHandler(null);
                    }
                }
                catch (Exception e) {
                    IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)"Error destroying jetty server", (Throwable)e);
                }
                this.launchServer();
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)("Exception binding html preview server to port:" + this.port), (Throwable)e);
                try {
                    int[] portRange = HttpServer.getPortRange();
                    this.port = ServerManager.findFreePort((int)portRange[0], (int)portRange[1]);
                    this.launchServer();
                }
                catch (Exception e1) {
                    IdeLog.logInfo((Plugin)JettyPlugin.getDefault(), (String)("Exception binding on alternate port for html preview server to port:" + this.port), (Throwable)e1);
                    throw e1;
                }
            }
            this.setServerState(2);
            this.serverChanged();
            PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", true);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", false);
            return new Status(4, "com.aptana.ide.server.jetty", 4, "Exception occurred starting preview server", (Throwable)e);
        }
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        PreviewServer.getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.ENABLE_BUILTIN_PREVIEW", false);
        try {
            if (this.previewServer != null && this.previewServer.isRunning()) {
                this.previewServer.stop();
            }
            this.setServerState(4);
            this.serverChanged();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, "Exception occurred stopping preview server", (Throwable)e);
        }
    }

    public IStatus canHaveModule(IModule module) {
        return new Status(4, "com.aptana.ide.server.jetty", 4, "Preview server does not support modules", null);
    }

    public String getConfigurationDescription() {
        return "HTML Preview Server";
    }

    public ILog getLog() {
        return new ILog(){

            public boolean exists() {
                return LOG_PATH.toFile().exists();
            }

            public URI getURI() {
                return LOG_PATH.toFile().toURI();
            }
        };
    }

    public String getHost() {
        return StringUtils.format((String)"{0}:{1}", (Object[])new String[]{this.getHostname(), Integer.toString(this.getPort())});
    }

    public boolean isWebServer() {
        return true;
    }

    public String getHostname() {
        return this.serverAddress == null ? "127.0.0.1" : this.serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public IPath getDocumentRoot() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }

    public String fetchStatistics() {
        return null;
    }

    public IStatisticsHandler getStatisticsHandler() {
        return this.handler;
    }

    public void setStatisticsHandler(IStatisticsHandler handler) {
        this.handler = handler;
        if (this.servlet != null) {
            this.servlet.setStatisticsHandler(this.handler);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return JettyPlugin.getDefault().getPreferenceStore();
    }
}

