/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.pathtools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    static final String FOLDER_EXPLORE_COMMAND_KEY = "folderExploreCommand";
    static final String FILE_EXPLORE_COMMAND_KEY = "fileExploreCommand";
    static String defaultFolderExploreCommand = "";
    static String defaultFileExploreCommand = "";
    static final String SHELL_ON_FOLDER_COMMAND_KEY = "shellOnfolderCommand";
    static final String SHELL_ON_FILE_COMMAND_KEY = "shellOnFileCommand";
    static String defaultShellOnFolderCommand = "";
    static String defaultShellOnFileCommand = "";
    static String defaultFolderCommands = "";
    static String defaultFileCommands = "";
    public static final String PLUGIN_ID = "com.aptana.ide.pathtools";
    private static Activator plugin;
    static final String FILE_PATH = "{path}";
    static final String FILE_PARENT_PATH = "{parent-path}";
    static final String FILE_NAME = "{name}";
    static final String FILE_PARENT_NAME = "{parent-name}";
    static final String FILE_PATH_SLASHES = "{path-slashes}";
    static final String FILE_PARENT_PATH_SLASHES = "{parent-path-slashes}";
    static final String FILE_PATH_BACKSLASHES = "{path-backslashes}";
    static final String FILE_PARENT_PATH_BACKSLASHES = "{parent-path-backslashes}";
    static final String LAST_COPY_PATH_FORMAT = "lastCopyPathFormat";
    static final String defaultLLastCopyPathFormat = "{path}";

    static {
        if ("macosx".equals(Platform.getOS())) {
            defaultFolderExploreCommand = "/usr/bin/open -a /System/Library/CoreServices/Finder.app \"{path}\"";
            defaultFileExploreCommand = "/usr/bin/open -a /System/Library/CoreServices/Finder.app \"{parent-path}\"";
            defaultShellOnFolderCommand = "/usr/bin/open -a /Applications/Utilities/Terminal.app";
            defaultShellOnFileCommand = "/usr/bin/open -a /Applications/Utilities/Terminal.app";
        } else if ("win32".equals(Platform.getOS())) {
            defaultFolderExploreCommand = "cmd /C start explorer /select,/e, \"{path}\"";
            defaultFileExploreCommand = "cmd /C start explorer /select,/e, \"{path}\"";
            defaultShellOnFolderCommand = "cmd /K start cd /D \"{path}\"";
            defaultShellOnFileCommand = "cmd /K start cd /D \"{parent-path}\"";
        } else if ("linux".equals(Platform.getOS())) {
            if (new File("/usr/bin/nautilus").exists()) {
                defaultFolderExploreCommand = "/usr/bin/nautilus \"{path}\"";
                defaultFileExploreCommand = "/usr/bin/nautilus \"{parent-path}\"";
            } else if (new File("/usr/bin/konqueror").exists()) {
                defaultFolderExploreCommand = "/usr/bin/konqueror \"{path}\"";
                defaultFileExploreCommand = "/usr/bin/konqueror \"{parent-path}\"";
            }
            defaultShellOnFolderCommand = "gnome-terminal --working-directory=\"{path}\"";
            defaultShellOnFileCommand = "gnome-terminal --working-directory=\"{parent-path}\"";
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if ("macosx".equals(Platform.getOS())) {
            try {
                String cdterminalDotScpt;
                URL entry = context.getBundle().getEntry("/scripts/cdterminal.scpt");
                if (entry != null && (cdterminalDotScpt = FileLocator.toFileURL((URL)entry).getFile()) != null) {
                    defaultShellOnFolderCommand = "/usr/bin/osascript \"" + cdterminalDotScpt + "\" \"" + "{path}" + "\"";
                    defaultShellOnFileCommand = "/usr/bin/osascript \"" + cdterminalDotScpt + "\" \"" + FILE_PARENT_PATH + "\"";
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(FOLDER_EXPLORE_COMMAND_KEY, defaultFolderExploreCommand);
        store.setDefault(FILE_EXPLORE_COMMAND_KEY, defaultFileExploreCommand);
        store.setDefault(SHELL_ON_FOLDER_COMMAND_KEY, defaultShellOnFolderCommand);
        store.setDefault(SHELL_ON_FILE_COMMAND_KEY, defaultShellOnFileCommand);
        store.setDefault(LAST_COPY_PATH_FORMAT, "{path}");
        super.initializeDefaultPreferences(store);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

