/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.internal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.AbstractExternalServer;
import com.aptana.ide.server.internal.LaunchUtils;
import com.aptana.ide.server.internal.Messages;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;

public class ApacheServer
extends AbstractExternalServer {
    private String startApache;
    private String stopApache;
    private String restartApache;
    private String httpdConf;
    private String etcHosts;
    private String hostName;

    public void installConfig(IAbstractConfiguration configuration) {
        this.setEtcHosts(configuration.getStringAttribute("ETCHOSTS"));
        this.setHttpdConf(configuration.getStringAttribute("HTTPDCONF"));
        this.setRestartApache(configuration.getStringAttribute("restart"));
        this.setStartApache(configuration.getStringAttribute("start"));
        this.setStopApache(configuration.getStringAttribute("shutdown"));
        this.hostName = configuration.getStringAttribute("HOSTNAME");
        super.installConfig(configuration);
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        super.storeConfiguration(config);
        config.setStringAttribute("ETCHOSTS", this.getEtcHosts());
        config.setStringAttribute("HTTPDCONF", this.getHttpdConf());
        config.setStringAttribute("restart", this.getRestartApache());
        config.setStringAttribute("start", this.getStartApache());
        config.setStringAttribute("shutdown", this.getStopApache());
        config.setStringAttribute("HOSTNAME", this.hostName);
    }

    public ApacheServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
        if (this.startApache == null || this.startApache.length() == 0) {
            this.startApache = "-k start";
        }
        if (this.stopApache == null || this.stopApache.length() == 0) {
            this.stopApache = "-k stop";
        }
        if (this.restartApache == null || this.restartApache.length() == 0) {
            this.restartApache = "-k restart";
        }
    }

    public String getConfigurationDescription() {
        return String.valueOf(this.getPath()) + " " + this.getHttpdConf() + " " + this.getEtcHosts();
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        this.setServerState(4);
        this.serverChanged();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.setServerState(1);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.serverChanged();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        IStatus doLaunch = this.doLaunch(this.getRestartApache());
        if (doLaunch.isOK()) {
            this.setServerState(2);
            this.setMode("run");
        } else {
            this.setServerState(1);
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.serverChanged();
        return doLaunch;
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        String arg = this.getStartApache();
        IStatus doLaunch = this.doLaunch(arg);
        if (doLaunch.isOK()) {
            this.setServerState(2);
            this.setMode("run");
        }
        return doLaunch;
    }

    protected IPath getDefaultLogPath() {
        return new Path(String.valueOf(new File(this.getPath()).getParentFile().getParent()) + "/logs/error.log");
    }

    private IStatus doLaunch(String arg) {
        try {
            String[] split = arg.split(" ");
            ArrayList<String> bf = new ArrayList<String>();
            int a = 0;
            while (a < split.length) {
                String sm = split[a].trim();
                if (!"".equals(sm)) {
                    bf.add(sm);
                }
                ++a;
            }
            String[] args = new String[bf.size()];
            bf.toArray(args);
            IProcess exec = LaunchUtils.exec(this.getPath(), args, null);
            if (exec != null) {
                this.registerProcess(exec);
                return Status.OK_STATUS;
            }
            return new Status(4, "com.aptana.ide.server.ui", 4, StringUtils.format((String)"could not create process {0}", (String)this.getPath()), null);
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.ui", 4, e.getMessage(), (Throwable)e);
        }
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        IStatus doLaunch = this.doLaunch(this.getStopApache());
        if (doLaunch.isOK()) {
            this.setMode(null);
            this.setServerState(4);
        }
        return doLaunch;
    }

    public String getStartApache() {
        return this.startApache;
    }

    public void setStartApache(String startApache) {
        this.startApache = startApache;
    }

    public String getStopApache() {
        return this.stopApache;
    }

    public void setStopApache(String stopApache) {
        this.stopApache = stopApache;
    }

    public String getRestartApache() {
        return this.restartApache;
    }

    public void setRestartApache(String restartApache) {
        this.restartApache = restartApache;
    }

    public String getHttpdConf() {
        return this.httpdConf;
    }

    public void setHttpdConf(String httpdConf) {
        this.httpdConf = httpdConf;
    }

    public String getEtcHosts() {
        return this.etcHosts;
    }

    public void setEtcHosts(String etcHosts) {
        this.etcHosts = etcHosts;
    }

    public String getHost() {
        return this.hostName;
    }

    static String getApacheHost(Properties properties2, int port) {
        int indexOf;
        String host = properties2.getProperty("listen");
        if (port != 0) {
            host = Integer.toString(port);
        }
        if (host != null && (indexOf = host.indexOf(58)) == -1) {
            return StringUtils.format((String)"127.0.0.1:{0}", (String)host);
        }
        return host;
    }

    protected Properties loadProperties() {
        File apachePath = new File(this.getPath()).getParentFile().getParentFile();
        Properties readServerProperties = ApacheServer.readServerProperties(apachePath);
        return readServerProperties;
    }

    public static Properties readServerProperties(File apachePath) {
        Properties properties2 = new Properties();
        File configurationFolder = new File(apachePath, "conf");
        File configFile = new File(configurationFolder, "httpd.conf");
        try {
            String readLine;
            FileReader rrs = new FileReader(configFile);
            BufferedReader bs = new BufferedReader(rrs);
            while ((readLine = bs.readLine()) != null) {
                if ((readLine = readLine.trim()).startsWith("#")) continue;
                int a = 0;
                while (a < readLine.length()) {
                    char c = readLine.charAt(a);
                    if (Character.isWhitespace(c)) {
                        String key = readLine.substring(0, a).toLowerCase();
                        String value = readLine.substring(a).trim();
                        properties2.put(key, value);
                    }
                    ++a;
                }
            }
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Configuration file not found", (Throwable)e);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"IO Error while reading server properties", (Throwable)e);
        }
        return properties2;
    }

    public boolean isWebServer() {
        return true;
    }

    public String getHostname() {
        return this.hostName;
    }

    public IStatus canPause() {
        if (this.getServerState() != 2) {
            return new Status(4, "com.aptana.ide.server", 0, Messages.ApacheServer_ONLY_RUNNING_MAY_BE_PAUSED, null);
        }
        if (this.getServerState() == 5) {
            return new Status(4, "com.aptana.ide.server", 0, Messages.ApacheServer_ALREADY_PAUSED, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus canResume() {
        if (this.getServerState() != 5) {
            return new Status(4, "com.aptana.ide.server", 0, Messages.ApacheServer_ONLY_PAUSED_MAY_BE_RESUMED, null);
        }
        return Status.OK_STATUS;
    }

    public void pause(IOperationListener listener, IProgressMonitor monitor) {
        this.stop(true, monitor);
        this.setServerState(5);
        this.serverChanged();
    }

    public void resume(IOperationListener listener, IProgressMonitor monitor) {
        this.setServerState(4);
        this.start("run", monitor);
        this.serverChanged();
    }

    public int getPort() {
        return 0;
    }
}

