/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.internal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.impl.servers.AbstractExternalServer;
import com.aptana.ide.server.internal.LaunchUtils;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;

public class MySqlServer
extends AbstractExternalServer {
    private boolean running;
    private String launchArgs;
    private ILaunch launch;
    private ILaunchesListener launchesListener2 = new ILaunchesListener2(){

        public void launchesAdded(ILaunch[] launches) {
            int a = 0;
            while (a < launches.length) {
                if (launches[a] == MySqlServer.this.launch) {
                    MySqlServer.this.setServerState(2);
                    MySqlServer.this.setMode("run");
                    MySqlServer.this.serverChanged();
                }
                ++a;
            }
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesTerminated(ILaunch[] launches) {
            int a = 0;
            while (a < launches.length) {
                if (launches[a] == MySqlServer.this.launch) {
                    MySqlServer.this.running = false;
                    MySqlServer.this.launch = null;
                    MySqlServer.this.setMode(null);
                    MySqlServer.this.setServerState(4);
                    MySqlServer.this.serverChanged();
                }
                ++a;
            }
        }
    };

    public void installConfig(IAbstractConfiguration configuration) {
        this.setLaunchArgs(configuration.getStringAttribute("launchargs"));
        super.installConfig(configuration);
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setStringAttribute("launchargs", this.getLaunchArgs());
        super.storeConfiguration(config);
    }

    public MySqlServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
        if (this.launchArgs == null || this.launchArgs.length() == 0) {
            this.launchArgs = "--standalone";
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() throws CoreException {
        IProcess process = LaunchUtils.exec(this.getPath(), new String[]{this.getLaunchArgs()}, null);
        this.launch = process.getLaunch();
        this.registerProcess(process);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchesListener2);
        this.running = true;
    }

    public void stop() throws CoreException {
        this.running = false;
        if (this.launch != null) {
            this.launch.terminate();
        }
        this.launch = null;
    }

    public String getLaunchArgs() {
        return this.launchArgs;
    }

    public void setLaunchArgs(String args) {
        this.launchArgs = args;
    }

    public String getConfigurationDescription() {
        return String.valueOf(super.getPath()) + " " + this.launchArgs;
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        try {
            this.start();
            this.setServerState(2);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.ui", 4, e.getMessage(), (Throwable)e);
        }
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        try {
            this.stop();
            this.setServerState(4);
            this.serverChanged();
            this.setMode(null);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.ui", 4, e.getMessage(), (Throwable)e);
        }
    }

    public String getHost() {
        Properties properties2 = this.getProperties();
        return MySqlServer.getMySqlHost(properties2);
    }

    protected Properties loadProperties() {
        File path = new File(new File(this.getPath()).getParentFile(), "my.cnf");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Configuration file not found", (Throwable)e);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"IO Error while reading server properties", (Throwable)e);
        }
        return properties;
    }

    static String getMySqlHost(Properties properties2) {
        int indexOf;
        String host = properties2.getProperty("port");
        if (host != null && (indexOf = host.indexOf(58)) == -1) {
            return StringUtils.format((String)"127.0.0.1:{0}", (String)host);
        }
        return host;
    }

    public String getHostname() {
        return "127.0.0.1";
    }

    public int getPort() {
        return 0;
    }
}

