/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.internal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServerEnvironmentConfigurator;
import com.aptana.ide.server.core.IServerLauncher;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.ServerLaunchers;
import com.aptana.ide.server.core.ServerPathUtils;
import com.aptana.ide.server.core.impl.servers.AbstractExternalServer;
import com.aptana.ide.server.internal.ApacheServer;
import com.aptana.ide.server.internal.LaunchUtils;
import com.aptana.ide.server.ui.ServerLauncherConfigurationWizard;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class XAMPPServer
extends AbstractExternalServer {
    private boolean running;
    private String stopPath;

    protected IStatus start(String mode, IProgressMonitor monitor) {
        try {
            this.start();
            this.setServerState(2);
            this.setMode("run");
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.ui", 4, e.getMessage(), (Throwable)e);
        }
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        try {
            this.stop();
            this.setServerState(4);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "com.aptana.ide.server.ui", 4, e.getMessage(), (Throwable)e);
        }
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        this.setStopPath(configuration.getStringAttribute("stoppath"));
        super.installConfig(configuration);
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setStringAttribute("stoppath", this.getStopPath());
        super.storeConfiguration(config);
    }

    public XAMPPServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() throws CoreException {
        int index;
        String executable = this.getPath();
        String workingDirectory = null;
        if (executable != null && executable.length() > 0 && (index = executable.lastIndexOf(File.separatorChar)) > 0) {
            workingDirectory = executable.substring(0, index);
        }
        IProcess exec = null;
        List launchers = ServerLaunchers.getLaunchers((String)this.getServerType().getId());
        if (launchers != null && launchers.size() != 0) {
            IServerEnvironmentConfigurator configurator;
            IServerLauncher launcher = (IServerLauncher)launchers.get(0);
            if (!launcher.isConfigured() && (configurator = launcher.getConfigurator()).requiresAdditionalInformation()) {
                ArrayList<IServerLauncher> toConfigure = new ArrayList<IServerLauncher>();
                toConfigure.add(launcher);
                ServerLauncherConfigurationWizard wizard = new ServerLauncherConfigurationWizard(this.getName(), toConfigure);
                WizardRunable runnable = new WizardRunable((IWizard)wizard);
                Display.getDefault().syncExec((Runnable)runnable);
                int result = runnable.getReturnCode();
                if (result != 0) {
                    return;
                }
            }
            if ((exec = launcher.exec(executable, this.getPathParameters(), workingDirectory)) == null) {
                MessageDialog.openError(null, (String)"Error", (String)"Unable starting the server. See log for details.");
            }
        } else {
            exec = LaunchUtils.exec(executable, this.getPathParameters(), workingDirectory);
        }
        if (exec != null) {
            this.registerProcess(exec);
        }
        this.running = true;
    }

    public IPath getServerRoot() {
        String startPathString = this.getPath();
        if (startPathString == null) {
            return null;
        }
        Path startPath = new Path(startPathString);
        IPath executableDirectoryPath = startPath.removeLastSegments(1);
        String currentOS = System.getProperty("os.name").toLowerCase();
        IPath rootPath = null;
        rootPath = currentOS.startsWith("windows") ? executableDirectoryPath : (currentOS.startsWith("linux") ? executableDirectoryPath : (currentOS.startsWith("mac") ? executableDirectoryPath.removeLastSegments(1) : executableDirectoryPath));
        return rootPath;
    }

    public void stop() throws CoreException {
        int index;
        String executable = this.getStopPath();
        String workingDirectory = null;
        if (executable != null && executable.length() > 0 && (index = executable.lastIndexOf(File.separatorChar)) > 0) {
            workingDirectory = executable.substring(0, index);
        }
        IProcess exec = null;
        List launchers = ServerLaunchers.getLaunchers((String)this.getServerType().getId());
        if (launchers != null && launchers.size() != 0) {
            IServerEnvironmentConfigurator configurator;
            IServerLauncher launcher = (IServerLauncher)launchers.get(0);
            if (!launcher.isConfigured() && (configurator = launcher.getConfigurator()).requiresAdditionalInformation()) {
                ArrayList<IServerLauncher> toConfigure = new ArrayList<IServerLauncher>();
                toConfigure.add(launcher);
                ServerLauncherConfigurationWizard wizard = new ServerLauncherConfigurationWizard(this.getName(), toConfigure);
                WizardRunable runnable = new WizardRunable((IWizard)wizard);
                Display.getDefault().syncExec((Runnable)runnable);
                int result = runnable.getReturnCode();
                if (result != 0) {
                    return;
                }
            }
            if ((exec = launcher.exec(executable, this.getStopPathParameters(), workingDirectory)) == null) {
                MessageDialog.openError(null, (String)"Error", (String)"Unable stopping the server. See log for details.");
            }
        } else {
            exec = LaunchUtils.exec(executable, this.getStopPathParameters(), workingDirectory);
        }
        if (exec != null) {
            this.registerProcess(exec);
        }
        this.running = false;
    }

    public String getStopPath() {
        return ServerPathUtils.getFileNameByPathWithParameters((String)this.stopPath);
    }

    public String[] getStopPathParameters() {
        return ServerPathUtils.getParameters((String)this.stopPath);
    }

    public void setStopPath(String args) {
        this.stopPath = args;
    }

    public String getConfigurationDescription() {
        return String.valueOf(super.getPath()) + " " + this.stopPath;
    }

    public String getHost() {
        return ApacheServer.getApacheHost(this.getProperties(), 0);
    }

    protected Properties loadProperties() {
        Properties readServerProperties = XAMPPServer.readServerProperties(new File(this.getPath()).getParentFile());
        return readServerProperties;
    }

    public boolean isWebServer() {
        return true;
    }

    public String getHostname() {
        return "127.0.0.1";
    }

    public int getPort() {
        return 0;
    }

    public static Properties readServerProperties(File apacheStartPath) {
        Properties properties2 = new Properties();
        Path executablePath = new Path(apacheStartPath.getAbsolutePath());
        String currentOS = System.getProperty("os.name").toLowerCase();
        IPath confPath = null;
        if (currentOS.startsWith("windows")) {
            confPath = executablePath.append("/apache/conf/httpd.conf");
        } else if (currentOS.startsWith("linux")) {
            confPath = executablePath.append("/etc/httpd.conf");
        } else if (currentOS.startsWith("mac")) {
            confPath = executablePath.removeLastSegments(1).append("/etc/httpd.conf");
        } else {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)("Unknown OS: " + currentOS));
            return properties2;
        }
        File configFile = confPath.toFile();
        try {
            String readLine;
            FileReader rrs = new FileReader(configFile);
            BufferedReader bs = new BufferedReader(rrs);
            while ((readLine = bs.readLine()) != null) {
                if ((readLine = readLine.trim()).startsWith("#")) continue;
                int a = 0;
                while (a < readLine.length()) {
                    char c = readLine.charAt(a);
                    if (Character.isWhitespace(c)) {
                        String key = readLine.substring(0, a).toLowerCase();
                        String value = readLine.substring(a).trim();
                        properties2.put(key, value);
                    }
                    ++a;
                }
            }
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Configuration file not found", (Throwable)e);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"IO Error while reading server properties", (Throwable)e);
        }
        return properties2;
    }

    private static class WizardRunable
    implements Runnable {
        private IWizard wizard;
        private int returnCode;

        public WizardRunable(IWizard wizard) {
            this.wizard = wizard;
        }

        public void run() {
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), this.wizard);
            wizardDialog.create();
            this.returnCode = wizardDialog.open();
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

