/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.IServerEnvironmentConfigurator;
import com.aptana.ide.server.core.IServerLauncher;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLauncherConfigurationWizard
extends Wizard {
    private Map<IServerLauncher, WizardPage> launchers = new HashMap<IServerLauncher, WizardPage>();

    public ServerLauncherConfigurationWizard(String serverName, List<IServerLauncher> launchers) {
        this.addPage((IWizardPage)new WelcomePage(serverName));
        for (IServerLauncher launcher : launchers) {
            IServerEnvironmentConfigurator configurator;
            if (launcher.isConfigured() || (configurator = launcher.getConfigurator()) == null || !configurator.requiresAdditionalInformation()) continue;
            WizardPage page = (WizardPage)configurator.getAdapter(WizardPage.class);
            if (page == null) {
                IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Unable getting server configurator as WizardPage");
                continue;
            }
            this.launchers.put(launcher, page);
            this.addPage((IWizardPage)page);
        }
    }

    public boolean performFinish() {
        for (Map.Entry<IServerLauncher, WizardPage> entry : this.launchers.entrySet()) {
            IServerLauncher launcher = entry.getKey();
            WizardPage page = entry.getValue();
            launcher.getConfigurator().configure((Object)page);
        }
        return true;
    }

    private class WelcomePage
    extends WizardPage {
        private Composite main;

        protected WelcomePage(String servername) {
            super("Wellcome");
            this.setTitle("Configuration required");
        }

        public void createControl(Composite parent) {
            this.main = new Composite(parent, 0);
            this.main.setLayout((Layout)new GridLayout());
            Label label1 = new Label(this.main, 0);
            Label label2 = new Label(this.main, 0);
            label1.setLayoutData((Object)new GridData(4, 0, true, false));
            label2.setLayoutData((Object)new GridData(4, 0, true, false));
            String buttonName = null;
            buttonName = ServerLauncherConfigurationWizard.this.getPageCount() > 1 ? "Next" : "Finish";
            String message1 = "This server requires configuration for launching.";
            String message2 = "Press " + buttonName + " to configure server or " + "Cancel" + " to cancel configuration process.";
            label1.setText(message1);
            label2.setText(message2);
            this.setControl((Control)this.main);
        }

        public Control getControl() {
            return this.main;
        }
    }
}

