/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.HttpServerLaunchConfiguration;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.StartPage;
import com.aptana.ide.server.ui.actions.HttpServerLaunchConfigurationHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.OrganizeFavoritesAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.AbstractLaunchToolbarAction;
import org.eclipse.debug.ui.actions.LaunchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;

public class RunServerToolbarAction
extends AbstractLaunchToolbarAction {
    ILaunchConfigurationListener launchListener;
    String launchMode;

    public void init(IWorkbenchWindow window) {
        super.init(window);
        this.updateLaunchStartPage();
        this.launchListener = new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                RunServerToolbarAction.this.updateLaunchStartPage();
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.launchListener);
    }

    public RunServerToolbarAction() {
        super("com.aptana.ide.server.ui.launchGroup.runServer");
    }

    public void run(IAction action) {
        this.launchMode = action.getActionDefinitionId();
        ILaunchConfiguration configuration = this.getLastLaunch();
        if (configuration == null) {
            try {
                this.launchDefaultServer();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ServerUIPlugin.getDefault(), (String)"Failed to create default run configuration", (Throwable)e);
                super.run(action);
            }
        } else {
            super.run(action);
        }
    }

    protected String getMode() {
        if (this.launchMode == null) {
            this.launchMode = "run";
        }
        return this.launchMode;
    }

    private void launchDefaultServer() throws CoreException {
        ILaunchConfiguration defaultConfiguration = HttpServerLaunchConfigurationHelper.getDefaultHttpServerLaunchConfiguration();
        DebugUITools.launch((ILaunchConfiguration)defaultConfiguration, (String)this.getMode());
    }

    protected void fillMenu(Menu menu) {
        LaunchAction action;
        ILaunchConfiguration launch;
        ILaunchConfiguration[] historyList = LaunchConfigurationManager.filterConfigs((ILaunchConfiguration[])this.getLaunchHistory().getHistory());
        ILaunchConfiguration[] favoriteList = LaunchConfigurationManager.filterConfigs((ILaunchConfiguration[])this.getLaunchHistory().getFavorites());
        int accelerator = 1;
        int i = 0;
        while (i < favoriteList.length) {
            launch = favoriteList[i];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++i;
        }
        if (favoriteList.length > 0 && historyList.length > 0) {
            this.addSeparator(menu);
        }
        i = 0;
        while (i < historyList.length) {
            launch = historyList[i];
            action = new LaunchAction(launch, this.getMode());
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            ++i;
        }
        if (menu.getItemCount() > 0) {
            this.addSeparator(menu);
        }
        this.addToMenu(menu, (IAction)new OrganizeFavoritesAction(this.getLaunchGroupIdentifier()), -1);
        this.addToMenu(menu, this.getOpenDialogAction(), -1);
    }

    public void launchHistoryChanged() {
        super.launchHistoryChanged();
        this.updateLaunchStartPage();
    }

    private void updateLaunchStartPage() {
        ILaunchConfiguration currentLaunch = this.getLastLaunch();
        if (currentLaunch == null) {
            try {
                currentLaunch = HttpServerLaunchConfigurationHelper.getDefaultHttpServerLaunchConfiguration(false);
            }
            catch (CoreException coreException) {}
        }
        if (currentLaunch != null) {
            HttpServerLaunchConfiguration config = new HttpServerLaunchConfiguration(currentLaunch);
            if (config.getStartActionType() == 2) {
                String startPagePath = config.getStartPagePath();
                IResource startPage = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(startPagePath));
                StartPage.getInstance().setStartPageResource(startPage);
            } else {
                StartPage.getInstance().setStartPageResource(null);
            }
        } else {
            StartPage.getInstance().setStartPageResource(null);
        }
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.launchListener);
    }
}

