/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import com.aptana.ide.server.ui.views.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ServerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String SERVER_IS_RUNNING_NO_EDIT = Messages.GenericServersView_ServerReadOnlyDescription;

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            Image image = ServerImagesRegistry.getInstance().getImage(element);
            return PlatformUI.getWorkbench().getDecoratorManager().decorateImage(image, element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IServer server = (IServer)element;
        int serverState = server.getServerState();
        String description = server.getDescription();
        switch (columnIndex) {
            case 0: {
                String name = server.getName();
                IServer[] assoc = server.getAssociatedServers();
                if (assoc.length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    int i = 0;
                    while (i < assoc.length) {
                        IServer server2 = assoc[i];
                        names.add(server2.getName());
                        ++i;
                    }
                    String nameList = StringUtils.join((String)", ", (String[])names.toArray(new String[0]));
                    name = StringUtils.format((String)Messages.ServerLabelProvider_BOUND_TO, (Object[])new String[]{name, nameList});
                }
                return name;
            }
            case 1: {
                switch (serverState) {
                    case 2: {
                        return Messages.ServerLabelProvider_Running;
                    }
                    case 1: {
                        return Messages.ServerLabelProvider_Starting;
                    }
                    case 3: {
                        return Messages.ServerLabelProvider_Stopping;
                    }
                    case 4: {
                        return Messages.ServerLabelProvider_Stopped;
                    }
                    case 6: {
                        return Messages.ServerLabelProvider_NotApplicable;
                    }
                    case 5: {
                        return Messages.ServerLabelProvider_PAUSED;
                    }
                }
                return Messages.ServerLabelProvider_Unknown;
            }
            case 2: {
                if ((description == null || description.length() == 0) && server instanceof AbstractServer) {
                    AbstractServer as = (AbstractServer)server;
                    return as.getConfigurationDescription();
                }
                return description;
            }
            case 3: {
                return server.getServerType().getCategory();
            }
            case 4: {
                String host = server.getHost();
                if (host != null) {
                    int indexOf = host.indexOf(58);
                    if (indexOf != -1) {
                        return host.substring(0, indexOf);
                    }
                    return host;
                }
                return null;
            }
            case 5: {
                String hostp = server.getHost();
                if (server.getPort() > 0) {
                    return Integer.toString(server.getPort());
                }
                if (hostp != null) {
                    int indexOf = hostp.indexOf(58);
                    if (indexOf != -1) {
                        return hostp.substring(indexOf + 1);
                    }
                    return "";
                }
                return null;
            }
        }
        return null;
    }
}

