/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views;

import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.server.IServerListener;
import com.aptana.ide.server.IServerRunnable;
import com.aptana.ide.server.core.ServerManager;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

public class ServersView
extends ViewPart
implements IServerListener {
    private TableViewer serverTableViewer;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.serverTableViewer = this.createServerTable(parent);
    }

    private TableViewer createServerTable(Composite parent) {
        TableViewer view = new TableViewer(parent, 65540);
        Table serverTable = view.getTable();
        serverTable.setHeaderVisible(true);
        serverTable.setLinesVisible(true);
        serverTable.setLayoutData((Object)new GridData(1808));
        TableColumn imageCol = new TableColumn(serverTable, 16384);
        imageCol.setWidth(20);
        TableColumn nameCol = new TableColumn(serverTable, 16384);
        nameCol.setText(Messages.ServersView_NAME);
        nameCol.setWidth(100);
        TableColumn statusCol = new TableColumn(serverTable, 16384);
        statusCol.setText(Messages.ServersView_STATUS);
        statusCol.setWidth(125);
        ServerManager.getInstance().addServerListener((IServerListener)this);
        view.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        view.setContentProvider((IContentProvider)new ServerContentProvider());
        PreferenceUtils.registerBackgroundColorPreference((Control)view.getControl(), (String)"com.aptana.ide.core.ui.background.color.serversView");
        PreferenceUtils.registerForegroundColorPreference((Control)view.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.serversView");
        return view;
    }

    public ISelection getSelection() {
        return this.serverTableViewer.getSelection();
    }

    public void serverStarted(IServerRunnable server) {
        this.serverTableViewer.add((Object)server);
    }

    public void serverStopped(IServerRunnable server) {
        this.serverTableViewer.remove((Object)server);
    }

    public void serverChanged(IServerRunnable server) {
        this.serverTableViewer.update((Object)server, null);
    }

    public void setFocus() {
        this.serverTableViewer.getTable().setFocus();
    }

    class ServerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ServerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ServerUIPlugin.getImageDescriptor("icons/server.gif").createImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IServerRunnable server = (IServerRunnable)element;
            ILaunchConfiguration launchConfig = server.getLaunchConfiguration();
            switch (columnIndex) {
                case 1: {
                    return launchConfig.getName();
                }
                case 2: {
                    return Messages.ServersView_STATUS_STARTED;
                }
            }
            return "";
        }
    }

    class ServerContentProvider
    implements IStructuredContentProvider {
        ServerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ServerManager.getInstance().getRunningServers();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

