/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IPausableServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public final class SuspendServerAction
extends Action {
    private ISelectionProvider provider;
    private boolean isPaused;
    private IStatus lastStatus;

    public SuspendServerAction(ISelectionProvider provider) {
        this.provider = provider;
        provider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SuspendServerAction.this.selectionChanged(event);
            }
        });
        this.selectionChanged(new SelectionChangedEvent(provider, provider.getSelection()));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            boolean enabled2 = this.isEnabled();
            IServer server = (IServer)selection.getFirstElement();
            if (server instanceof IPausableServer) {
                if (server.getServerState() == 5) {
                    this.initResumeDescriptors(server, enabled2);
                } else {
                    this.initPauseDescriptors(server, enabled2);
                }
            } else {
                this.initPauseDescriptors(server, false);
            }
            this.setEnabled(enabled2);
        } else {
            this.initPauseDescriptors(null, false);
            this.setEnabled(false);
        }
    }

    private void initPauseDescriptors(IServer server, boolean enabled2) {
        String name;
        String string = name = server != null ? server.getName() : "";
        if (!enabled2) {
            if (this.lastStatus != null) {
                String message = this.lastStatus.getMessage();
                this.setToolTipText(message);
            } else {
                String format = StringUtils.format((String)Messages.SuspendServerAction_CAN_NOT_BE_PAUSED, (String)name);
                this.setToolTipText(format);
            }
        } else {
            String string2 = Messages.SuspendServerAction_PAUSE_SERVER;
            this.setToolTipText(string2);
        }
        if (!this.isPaused) {
            this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/elcl16/suspend_co.gif"));
            this.setDisabledImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/dlcl16/suspend_co.gif"));
            this.isPaused = true;
        }
    }

    public boolean isEnabled() {
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (!selection.isEmpty()) {
            IServer server = (IServer)selection.getFirstElement();
            this.lastStatus = null;
            if (server instanceof IPausableServer) {
                IPausableServer ps = (IPausableServer)server;
                if (ps.getServerState() == 5) {
                    IStatus canResume = ps.canResume();
                    return canResume.isOK();
                }
                IStatus canPause = ps.canPause();
                return canPause.isOK();
            }
            return false;
        }
        return false;
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
        if (!selection.isEmpty()) {
            IPausableServer server = (IPausableServer)selection.getFirstElement();
            try {
                if (server.getServerState() == 5) {
                    server.resume(null, null);
                } else {
                    server.pause(null, null);
                }
            }
            catch (Exception e) {
                IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)"exception while starting server", (Throwable)e);
            }
        }
    }

    private void initResumeDescriptors(IServer server, boolean enabled2) {
        String name;
        String string = name = server != null ? server.getName() : "";
        if (enabled2) {
            String format = StringUtils.format((String)Messages.ServersView_RESUME, (String)name);
            this.setText(format);
            this.setToolTipText(format);
        } else {
            String format = this.lastStatus != null ? this.lastStatus.getMessage() : StringUtils.format((String)Messages.SuspendServerAction_RESUME_TOOLTIP, (String)name);
            this.setToolTipText(format);
            this.setText(format);
        }
        if (this.isPaused) {
            this.setImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/elcl16/resume_co.gif"));
            this.setDisabledImageDescriptor(ServerUIPlugin.getImageDescriptor("/icons/server/dlcl16/resume_co.gif"));
            this.isPaused = false;
        }
    }
}

