/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css;

import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editors.unified.AbstractPairFinder;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;

public class CSSPairFinder
extends AbstractPairFinder {
    public PairMatch findPairMatch(int offset, IParseState parseState, Lexeme cursorLexeme, int loopCount) {
        LexemeList lexemeList = parseState.getLexemeList();
        PairMatch result = null;
        while (loopCount > 0 && cursorLexeme != null) {
            int index = lexemeList.getLexemeIndex(cursorLexeme);
            Lexeme matchingLexeme = null;
            switch (cursorLexeme.typeIndex) {
                case 31: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemeList, (int)index, (String)"text/css", (int)cursorLexeme.typeIndex, (int)32, (int)1);
                    break;
                }
                case 32: {
                    matchingLexeme = UnifiedEditor.findBalancingLexeme((LexemeList)lexemeList, (int)index, (String)"text/css", (int)cursorLexeme.typeIndex, (int)31, (int)-1);
                    break;
                }
                case 5: {
                    if (cursorLexeme.getCategoryIndex() == 0 || offset - 1 != cursorLexeme.getStartingOffset() && offset != cursorLexeme.getEndingOffset()) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = cursorLexeme.getEndingOffset() - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                }
            }
            if (index - 1 > 0 && lexemeList.get(index - 1).getToken().getLanguage().equals("text/html")) {
                result = this.findEndingQuote(index, parseState, cursorLexeme, lexemeList);
            }
            if (matchingLexeme != null) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = matchingLexeme.getStartingOffset();
                result.endEnd = matchingLexeme.getEndingOffset();
                loopCount = 0;
                continue;
            }
            if (--loopCount > 0 && offset > 0) {
                cursorLexeme = lexemeList.getLexemeFromOffset(offset - 1);
                continue;
            }
            loopCount = 0;
        }
        return result;
    }

    public Color getPairFinderColor() {
        return UnifiedColorManager.getInstance().getColor(PreferenceConverter.getColor((IPreferenceStore)CSSPlugin.getDefault().getPreferenceStore(), (String)"com.aptana.ide.editors.PAIR_MATCHING_COLOR"));
    }

    private String getDisplayPreference() {
        return CSSPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.SHOW_PAIR_MATCHES");
    }

    public boolean displayOnlyMatch() {
        return this.getDisplayPreference().equals("MATCHING");
    }

    public boolean doNotDisplay() {
        return this.getDisplayPreference().equals("NONE");
    }

    private PairMatch findEndingQuote(int index, IParseState parseState, Lexeme cursorLexeme, LexemeList lexemeList) {
        Lexeme endingLexeme = null;
        int i = index + 1;
        while (i < lexemeList.size()) {
            Lexeme currentLexeme = lexemeList.get(i);
            if (!currentLexeme.getToken().getLanguage().equals("text/css")) {
                if (!currentLexeme.getText().equals("\"")) break;
                endingLexeme = currentLexeme;
                break;
            }
            ++i;
        }
        if (endingLexeme == null) {
            return null;
        }
        PairMatch match = new PairMatch();
        match.beginStart = cursorLexeme.getStartingOffset();
        match.beginEnd = cursorLexeme.getEndingOffset();
        match.endStart = endingLexeme.getStartingOffset();
        match.endEnd = endingLexeme.getEndingOffset();
        return match;
    }
}

