/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.formatting;

import com.aptana.ide.editor.css.CSSPlugin;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class CSSCodeFormatterOptions {
    public static final int END_LINE = 0;
    public static final int NEXT_LINE = 1;
    public static final int NEXT_LINE_SHIFTED = 2;
    public int formatterBracePositionForBlock;
    public String formatterTabChar;
    public int tabSize;
    public boolean doFormatting = true;

    public CSSCodeFormatterOptions() {
        this.initFromPreferences();
    }

    private void initFromPreferences() {
        IPreferenceStore preferenceStore = CSSPlugin.getDefault().getPreferenceStore();
        this.formatterTabChar = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        this.tabSize = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        this.formatterBracePositionForBlock = this.parseOption(preferenceStore, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
        String string = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
        if (string.length() > 0) {
            this.doFormatting = false;
        }
    }

    public final int parseOption(IPreferenceStore store, String id) {
        String string = store.getString(id);
        return this.parseOption(string);
    }

    private int parseOption(String string) {
        if (string == null) {
            return 2;
        }
        if (string.equals("end_of_line")) {
            return 0;
        }
        if (string.equals("next_line")) {
            return 1;
        }
        return 2;
    }

    public final int parseOption(Map store, String id) {
        return this.parseOption((String)store.get(id));
    }

    public final int parseOption(IEclipsePreferences store, String id) {
        return this.parseOption(store.get(id, null));
    }

    public CSSCodeFormatterOptions(Map map, IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.ide.editor.css");
            String string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", null);
            if (string == null) {
                this.initFromPreferences();
                return;
            }
            this.formatterTabChar = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", "");
            this.tabSize = Integer.parseInt(string);
            this.formatterBracePositionForBlock = this.parseOption(preferences, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
            string = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant", "");
            if (string.length() > 0) {
                this.doFormatting = false;
            }
        } else if (map == null) {
            this.initFromPreferences();
        } else {
            Object object10;
            this.formatterTabChar = (String)map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            if (this.formatterTabChar == null) {
                this.formatterTabChar = " ";
            }
            this.tabSize = (object10 = map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size")) != null ? Integer.parseInt(object10.toString()) : 4;
            this.formatterBracePositionForBlock = this.parseOption(map, "com.aptana.ide.editors.codeassist.formatter.brace_position_for_block");
            String sma = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
            if (sma != null && sma.length() > 0) {
                this.doFormatting = false;
            }
        }
    }
}

