/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.outline;

import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.parsing.nodes.CSSDeclarationNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSParseNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSSelectorNode;
import com.aptana.ide.editor.css.parsing.nodes.CSSSimpleSelectorNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CSSLabelProvider
extends LabelProvider {
    private static final Image PROPERTY_ICON = CSSPlugin.getImage("icons/property_icon.gif");
    private static final Image SELECTOR_ICON = CSSPlugin.getImage("icons/rule_icon.gif");

    public Image getImage(Object element) {
        Image result = element instanceof CSSSelectorNode ? SELECTOR_ICON : (element instanceof CSSDeclarationNode ? PROPERTY_ICON : super.getImage(element));
        return result;
    }

    public String getText(Object element) {
        StringBuffer result = new StringBuffer();
        if (element instanceof CSSSelectorNode) {
            CSSSelectorNode selector = (CSSSelectorNode)((Object)element);
            int i = 0;
            while (i < selector.getChildCount()) {
                CSSSimpleSelectorNode simpleSelector = (CSSSimpleSelectorNode)selector.getChild(i);
                CSSParseNode partsChildren = (CSSParseNode)simpleSelector.getChild(0);
                CSSParseNode combinator = (CSSParseNode)simpleSelector.getChild(1);
                if (combinator.getTypeIndex() != 15) {
                    result.append(" ").append(combinator.getText()).append(" ");
                }
                int j = 0;
                while (j < partsChildren.getChildCount()) {
                    CSSParseNode part = (CSSParseNode)partsChildren.getChild(j);
                    String text = part.getText();
                    char firstCharacter = text.charAt(0);
                    if (firstCharacter != '.' && firstCharacter != '#') {
                        result.append(" ");
                    }
                    result.append(text);
                    ++j;
                }
                ++i;
            }
        } else if (element instanceof CSSDeclarationNode) {
            CSSDeclarationNode declaration = (CSSDeclarationNode)((Object)element);
            String name = declaration.getAttribute("name");
            result.append(name).append(" : ");
            CSSParseNode expression = (CSSParseNode)declaration.getChild(0);
            this.addExpression(result, expression);
        } else {
            result.append(super.getText(element));
        }
        return result.toString();
    }

    private void addExpression(StringBuffer builder, CSSParseNode expression) {
        int i = 0;
        while (i < expression.getChildCount()) {
            CSSParseNode term = (CSSParseNode)expression.getChild(i);
            String joiningOperator = term.getAttribute("joining-operator");
            builder.append(joiningOperator);
            if (joiningOperator.equals(",")) {
                builder.append(" ");
            }
            String operator = term.getAttribute("operator");
            builder.append(operator);
            String value = term.getAttribute("value");
            builder.append(value);
            if (term.hasChildren()) {
                CSSParseNode child = (CSSParseNode)term.getChild(0);
                this.addExpression(builder, child);
                builder.append(term.getEndingLexeme().getText());
            }
            ++i;
        }
    }
}

