/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.preferences;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.css.BrowserExtensionLoader;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.preferences.Messages;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreviewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer previewViewer;
    private Label description;
    private Composite displayArea;
    private Group browsers;
    private Button useCustomTemplate;
    private Text defaultTemplate;
    private Button useUrl;
    private Label globalUrlLabel;
    private Text globalUrlText;
    private Button browseButton;
    private Button useTempFiles;

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.useTempFiles = new Button(this.displayArea, 32);
        this.useTempFiles.setText(Messages.PreviewPreferencePage_UseTempFilesText);
        this.useTempFiles.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.editor.css.USE_TEMP_FILES_FOR_PREVIEW"));
        this.description = new Label(this.displayArea, 64);
        this.description.setText(Messages.PreviewPreferencePage_DescriptionText);
        this.browsers = new Group(this.displayArea, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.browsers.setLayout((Layout)gridLayout);
        this.browsers.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browsers.setText(Messages.PreviewPreferencePage_BrowsersText);
        Table table = new Table((Composite)this.browsers, 2084);
        table.setFont(parent.getFont());
        this.previewViewer = new CheckboxTableViewer(table);
        this.previewViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.previewViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.previewViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (Platform.getOS().equals("macosx") && PreviewPreferencePage.this.previewViewer.getChecked((Object)"Firefox") && !PreviewPreferencePage.this.previewViewer.getChecked((Object)"Safari")) {
                    MessageDialog.openInformation((Shell)PreviewPreferencePage.this.getShell(), (String)Messages.PreviewPreferencePage_FirefoxIssueTitle, (String)Messages.PreviewPreferencePage_FireFoxIssueMessage);
                    PreviewPreferencePage.this.previewViewer.setChecked((Object)"Firefox", false);
                }
            }
        });
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPreviewBrowsers();
        this.addCheckedBrowsers();
        Label templateDescription = new Label(this.displayArea, 16448);
        templateDescription.setText(Messages.PreviewPreferencePage_TemplateDescText);
        GridData tdData = new GridData(4, 4, true, false);
        tdData.verticalIndent = 5;
        templateDescription.setLayoutData((Object)tdData);
        boolean useTemplate = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_USE_TEMPLATE_PREFERENCE");
        this.useCustomTemplate = new Button(this.displayArea, 16);
        this.useCustomTemplate.setText(Messages.PreviewPreferencePage_UseCustomTemplateText);
        this.useCustomTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean template = PreviewPreferencePage.this.useCustomTemplate.getSelection();
                PreviewPreferencePage.this.defaultTemplate.setEnabled(template);
                PreviewPreferencePage.this.globalUrlText.setEnabled(!template);
                PreviewPreferencePage.this.browseButton.setEnabled(!template);
            }
        });
        this.useCustomTemplate.setSelection(useTemplate);
        Group template = new Group(this.displayArea, 0);
        template.setText(Messages.PreviewPreferencePage_TemplateGroupTitle);
        GridLayout tLayout = new GridLayout(1, true);
        tLayout.marginHeight = 0;
        tLayout.marginWidth = 0;
        template.setLayout((Layout)tLayout);
        GridData tData = new GridData(4, 4, true, false);
        tData.horizontalIndent = 13;
        template.setLayoutData((Object)tData);
        this.defaultTemplate = new Text((Composite)template, 2882);
        GridData dtData = new GridData(4, 4, true, true);
        dtData.heightHint = 225;
        dtData.widthHint = 500;
        this.defaultTemplate.setText(this.getPreferenceStore().getString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_TEMPLATE_PREFERENCE"));
        this.defaultTemplate.setLayoutData((Object)dtData);
        this.defaultTemplate.setEnabled(useTemplate);
        this.useUrl = new Button(this.displayArea, 16);
        this.useUrl.setText(Messages.PreviewPreferencePage_UseUrlText);
        this.useUrl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean url = PreviewPreferencePage.this.useUrl.getSelection();
                PreviewPreferencePage.this.defaultTemplate.setEnabled(!url);
                PreviewPreferencePage.this.globalUrlText.setEnabled(url);
                PreviewPreferencePage.this.browseButton.setEnabled(url);
            }
        });
        this.useUrl.setSelection(!useTemplate);
        Composite globalUrl = new Composite(this.displayArea, 0);
        GridLayout guLayout = new GridLayout(3, false);
        guLayout.marginHeight = 0;
        guLayout.marginWidth = 0;
        guLayout.marginBottom = 10;
        globalUrl.setLayout((Layout)guLayout);
        GridData gData = new GridData(4, 4, true, false);
        gData.horizontalIndent = 15;
        globalUrl.setLayoutData((Object)gData);
        this.globalUrlLabel = new Label(globalUrl, 16384);
        this.globalUrlLabel.setText(Messages.PreviewPreferencePage_UrlLabel);
        this.globalUrlText = new Text(globalUrl, 2052);
        this.globalUrlText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.globalUrlText.setText(this.getPreferenceStore().getString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_URL_PREFERENCE"));
        this.globalUrlText.setEnabled(!useTemplate);
        this.browseButton = new Button(globalUrl, 8);
        this.browseButton.setText(Messages.PreviewPreferencePage_BrowseText);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(PreviewPreferencePage.this.browseButton.getShell(), 4096);
                String file = dialog.open();
                if (file != null) {
                    PreviewPreferencePage.this.globalUrlText.setText(file);
                }
            }
        });
        this.browseButton.setEnabled(!useTemplate);
        return this.displayArea;
    }

    private void addPreviewBrowsers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("com.aptana.ide.editors.browser");
        IExtension[] extensions = ep.getExtensions();
        ArrayList<String> browserPreviews = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String browserClass = ce[j].getAttribute("class");
                String browserName = BrowserExtensionLoader.getBrowserLabel(ce[j]);
                if (browserClass != null && browserName != null) {
                    browserPreviews.add(browserName);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(browserPreviews);
        this.previewViewer.setInput((Object)browserPreviews.toArray());
    }

    private void addCheckedBrowsers() {
        String all_browsers = this.getPreferenceStore().getString("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE");
        String[] browsers = all_browsers.split(",");
        int i = 0;
        while (i < browsers.length) {
            this.previewViewer.setChecked((Object)browsers[i], true);
            ++i;
        }
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_URL_PREFERENCE", this.globalUrlText.getText());
        this.getPreferenceStore().setValue("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_TEMPLATE_PREFERENCE", this.defaultTemplate.getText());
        this.getPreferenceStore().setValue("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_USE_TEMPLATE_PREFERENCE", this.useCustomTemplate.getSelection());
        ArrayList<String> al = new ArrayList<String>();
        Object[] elements = this.previewViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            al.add(elements[i].toString());
            ++i;
        }
        this.getPreferenceStore().setValue("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE", StringUtils.join((String)",", (String[])al.toArray(new String[0])));
        this.getPreferenceStore().setValue("com.aptana.ide.editor.css.USE_TEMP_FILES_FOR_PREVIEW", this.useTempFiles.getSelection());
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        String prefs = this.getPreferenceStore().getDefaultString("com.aptana.ide.editor.css.BROWSER_PREVIEW_PREFERENCE");
        this.previewViewer.setCheckedElements((Object[])prefs.split(","));
        String url = this.getPreferenceStore().getDefaultString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_URL_PREFERENCE");
        this.globalUrlText.setText(url);
        String template = this.getPreferenceStore().getDefaultString("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_TEMPLATE_PREFERENCE");
        this.defaultTemplate.setText(template);
        boolean useTemplate = this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editor.css.CSSEDITOR_BROWSER_USE_TEMPLATE_PREFERENCE");
        this.useCustomTemplate.setSelection(useTemplate);
        this.useUrl.setSelection(!useTemplate);
        this.defaultTemplate.setEnabled(useTemplate);
        this.globalUrlText.setEnabled(!useTemplate);
        this.browseButton.setEnabled(!useTemplate);
        this.useTempFiles.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.editor.css.USE_TEMP_FILES_FOR_PREVIEW"));
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CSSPlugin.getDefault().getPreferenceStore());
    }
}

