/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.css.validator;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.css.CSSPlugin;
import com.aptana.ide.editor.css.validator.StylesheetValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.properties.css3.Css3Style;
import org.w3c.css.util.Utf8Properties;

public class AptanaCSSStyle
extends Css3Style {
    private static final String PROPERITES_FILE_NAME = "AptanaCSSProperties.properties";
    private static final Utf8Properties CSS_PROPERTIES = new Utf8Properties();
    private final Map<String, CssProperty> properties = new HashMap<String, CssProperty>();

    static {
        InputStream configStream = StylesheetValidator.class.getResourceAsStream(PROPERITES_FILE_NAME);
        try {
            CSS_PROPERTIES.load(configStream);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)"Unable loading CSS properties", (Throwable)e);
        }
    }

    public CssProperty getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public CssProperty getPropertyCascadingOrder(String propertyName) {
        CssProperty toReturn = this.properties.get(propertyName);
        if (toReturn == null) {
            toReturn = this.style.CascadingOrder(this.createNewDefaultInstance(propertyName), this.style, this.selector);
        }
        return toReturn;
    }

    public void setProperty(String propertyName, CssProperty propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    protected CssProperty createNewDefaultInstance(String propertyName) {
        String propertyClassName;
        block6: {
            String nameToSearch = propertyName;
            if (propertyName.startsWith("-")) {
                nameToSearch = propertyName.substring(1);
            }
            if ((propertyClassName = CSS_PROPERTIES.getProperty(nameToSearch)) != null) break block6;
            return null;
        }
        try {
            return (CssProperty)Class.forName(propertyClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error while creating new instance of " + ((Object)((Object)this)).getClass().getName() + " class", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while creating new instance of " + ((Object)((Object)this)).getClass().getName() + " class", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error while creating new instance of " + ((Object)((Object)this)).getClass().getName() + " class", e);
        }
    }
}

