/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.search.epl.Activator;
import com.aptana.ide.search.epl.FileSystemMatch;
import com.aptana.ide.search.epl.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;

public class AptanaFileSystemMatch
extends FileSystemMatch
implements IAdaptable {
    final int lineNumber;
    String lineContent;

    public AptanaFileSystemMatch(File element, int offset, int length, int lineNumber, String lineContent) {
        super(element, offset, length);
        this.lineContent = lineContent != null ? lineContent.trim() : null;
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getLineContent() {
        if (this.lineContent == null) {
            try {
                File file = this.getFile();
                if (file != null) {
                    String readContent = StreamUtils.readContent((InputStream)new FileInputStream(file), (String)Charset.defaultCharset().name());
                    int from = Math.max(0, this.getOffset() - 40);
                    int to = Math.min(readContent.length(), this.getOffset() + this.getLength() + 30);
                    this.lineContent = readContent.substring(from, to);
                }
            }
            catch (IOException e) {
                this.lineContent = StringUtils.format((String)Messages.AptanaFileMatch_IO_ERROR, (String)e.getMessage());
                IdeLog.logError((Plugin)Activator.getDefault(), (String)this.lineContent);
            }
        }
        return this.lineContent;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

