/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.views.fileexplorer.FileExplorerView;
import com.aptana.ide.search.epl.Activator;
import com.aptana.ide.search.epl.AptanaTextSearchQueryProvider;
import com.aptana.ide.search.epl.ContentAssistHandler;
import com.aptana.ide.search.epl.Messages;
import com.aptana.ide.search.epl.ReplaceAction2;
import com.aptana.ide.search.epl.ReplaceDialog2;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemReplaceAction2;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.util.FileTypeEditor;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class AptanaTextSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private static final int DIRECTORY_SCOPE = 12;
    private static final int OPEN_FILES_SCOPE = 13;
    private ScopeSelectionListener scopeSelectionListener = new ScopeSelectionListener();
    private static final int HISTORY_SIZE = 12;
    private static String STORE_IS_IGNORE_LINE_ENDINGS = "IGNORE_LINES_ENDINGS_SEARCH";
    private ContentAssistHandler fReplaceContentAssistHandler;
    public static final String EXTENSION_POINT_ID = "org.eclipse.search.internal.ui.text.TextSearchPage";
    private static final String PAGE_NAME = "TextSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_SEARCH_DERIVED = "SEARCH_DERIVED";
    private static final String STORE_SEARCH_MULTILINE = "SEARCH_MULTILINE";
    private static final String STORE_SEARCH_DIRECTORY = "SEARCH_DIRECTORY";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private static final String STORE_LINEDELIMETER = "STORE_LINEDELIMETER";
    private static final String SEARCH_SCOPE = "SEARCH_SCOPE";
    private List fPreviousSearchPatterns = new ArrayList(20);
    private boolean fNoLabel = false;
    private boolean fFirstTime = true;
    private boolean fIsCaseSensitive;
    private boolean fIsRegExSearch;
    private boolean fSearchDerived = true;
    private boolean fIsMultiline;
    private String fSearchDirectory;
    private int scope;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Combo fExtensions;
    private Button fIsRegExCheckbox;
    private CLabel fStatusLabel;
    private Text fText;
    private Text fMultiLineText;
    private ISearchPageContainer fContainer;
    private FileTypeEditor fFileTypeEditor;
    private Text fDirectory;
    private Button fSearchInDirectory;
    private Button fSearchInOpenFiles;
    boolean firstOpen;
    private Button fIsIgnoreLinesCheckBox;
    private boolean fIgnoreLines = true;
    private Combo linesDelimeter;
    private int fLineDelimeter;
    private Label lineDelimeterlabel;
    private Button fSearchDerivedCheckbox;

    private ISearchQuery newQuery() throws CoreException {
        SearchPatternData data = this.getPatternData();
        TextSearchPageInput input = new TextSearchPageInput(data.textPattern, data.isCaseSensitive, data.isRegExSearch, this.createTextSearchScope(), data.isDirectory, data.directory, data.openFiles, data.isIgnoreLineEndings);
        input.doRefresh = this.fSearchDerived;
        return new AptanaTextSearchQueryProvider().createQuery(input);
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public boolean performReplace() {
        IStatus status;
        block4: {
            try {
                status = NewSearchUI.runQueryInForeground((IRunnableContext)this.getContainer().getRunnableContext(), (ISearchQuery)this.newQuery());
                if (!status.matches(8)) break block4;
                return false;
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_querycreationproblem_message, (IStatus)e.getStatus());
                return false;
            }
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_runproblem_message, (IStatus)status);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                if (view != null) {
                    Object[] files;
                    Object[] elements;
                    Object filePage;
                    ISearchResultPage page = view.getActivePage();
                    if (page instanceof FileSearchPage) {
                        filePage = (FileSearchPage)page;
                        elements = filePage.getInput().getElements();
                        files = new IFile[elements.length];
                        System.arraycopy(elements, 0, files, 0, files.length);
                        new ReplaceAction2((FileSearchPage)filePage, (IFile[])files).run();
                    }
                    if (page instanceof FileSystemSearchPage) {
                        filePage = (FileSystemSearchPage)page;
                        elements = filePage.getInput().getElements();
                        files = new File[elements.length];
                        System.arraycopy(elements, 0, files, 0, files.length);
                        new FileSystemReplaceAction2((FileSystemSearchPage)((Object)filePage), (File[])files).run();
                    }
                }
            }
        });
        return true;
    }

    private String getPattern() {
        if (this.fPattern != null) {
            String text = this.fPattern.getText();
            text = text.replace("\\r", "\r");
            text = text.replace("\\n", "\n");
            return text;
        }
        String text = this.fText.getText();
        String lDel = "\n";
        if (!this.fIgnoreLines) {
            switch (this.fLineDelimeter) {
                case 0: {
                    lDel = "\r\n";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    lDel = "\r";
                    break;
                }
            }
        }
        text = text.replace("\r\n", "\n");
        text = text.replace("\r", "\n");
        text = text.replace("\n", lDel);
        return text;
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope((IWorkingSet[])workingSets, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
        }
        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource2 != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope((IResource[])arr, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope((IResource[])res, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.getPattern());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.isCaseSensitive(), this.isRegexp(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets(), this.isSearhingInDirectory(), this.getDirectoryText(), this.isSearchingInOpenFiles(), this.isIgnoreLines());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private boolean isRegexp() {
        return this.fIsRegExCheckbox.getSelection();
    }

    private boolean isIgnoreLines() {
        return this.fIsIgnoreLinesCheckBox.getSelection();
    }

    private boolean isSearchingInOpenFiles() {
        if (this.fSearchInOpenFiles == null) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in open files is null");
            return false;
        }
        return this.fSearchInOpenFiles.getSelection();
    }

    private String getDirectoryText() {
        return this.fDirectory.getText();
    }

    private boolean isSearhingInDirectory() {
        if (this.fSearchInDirectory == null) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in directory is null");
            return false;
        }
        return this.fSearchInDirectory.getSelection();
    }

    private String[] getPreviousExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(this.fPreviousSearchPatterns.size());
        int size = this.fPreviousSearchPatterns.size();
        int i = 0;
        while (i < size) {
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            String text = FileTypeEditor.typesToString((String[])data.fileNamePatterns);
            if (!extensions.contains(text)) {
                extensions.add(text);
            }
            ++i;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get((int)i)).textPattern;
            patterns[i] = patterns[i].replace("\r", "\\r");
            patterns[i] = patterns[i].replace("\n", "\\n");
            ++i;
        }
        return patterns;
    }

    private String[] getExtensions() {
        return this.fFileTypeEditor.getFileTypes();
    }

    private boolean isCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String lastSelected;
            if (this.fPattern != null) {
                if (this.fFirstTime) {
                    this.fFirstTime = false;
                    this.refreshPattern();
                    this.fExtensions.setItems(this.getPreviousExtensions());
                    if (!this.initializePatternControl()) {
                        this.fPattern.select(0);
                        this.fExtensions.setText("*");
                        this.handleWidgetSelected();
                    }
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        AptanaTextSearchPage.this.fPattern.setFocus();
                    }
                });
            } else {
                if (this.fFirstTime) {
                    this.fFirstTime = false;
                    this.fExtensions.setItems(this.getPreviousExtensions());
                    String[] sortedPrevPatterns = this.getSortedPrevPatterns();
                    if (sortedPrevPatterns.length > 0) {
                        String string = sortedPrevPatterns[0];
                        string = string.replace("\\r", "\r");
                        string = string.replace("\\n", "\n");
                        this.fMultiLineText.setText(string);
                    }
                    this.fExtensions.setText("*");
                    this.handleWidgetSelected();
                }
                this.fMultiLineText.setFocus();
            }
            FileExplorerView findView = (FileExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.aptana.ide.js.ui.views.FileExplorerView");
            if (findView != null && (lastSelected = FileExplorerView.lastSelected) != null) {
                File fs = new File(lastSelected);
                if (!fs.isDirectory()) {
                    fs = fs.getParentFile();
                }
                if (fs != null && fs.exists()) {
                    this.fDirectory.setText(fs.getPath());
                }
            }
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    private void refreshPattern() {
        String[] strings = this.getSortedPrevPatterns();
        this.fPattern.setItems(strings);
    }

    private String[] getSortedPrevPatterns() {
        LinkedHashSet set = new LinkedHashSet(Arrays.asList(this.getPreviousSearchPatterns()));
        String[] strings = new String[set.size()];
        set.toArray(strings);
        return strings;
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        boolean hasFilePattern = this.fExtensions.getText().length() > 0;
        this.getContainer().setPerformActionEnabled(regexStatus && hasFilePattern);
    }

    public void createControl(final Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        final Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(1, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        result.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.search.text_search_page_context");
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                AptanaTextSearchPage.this.modifyScope(parent, result);
            }
        });
        Point computeSize = parent.getShell().computeSize(-1, -1);
        Point size = parent.getShell().getSize();
        parent.getShell().setMinimumSize(computeSize);
        if (size.x < computeSize.x || size.y < computeSize.y) {
            parent.getShell().setSize(computeSize.x, computeSize.y);
        }
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                AptanaTextSearchPage.this.modifyScope(parent, result);
                parent.getShell().layout(true, true);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.isRegexp()) {
            block5: {
                try {
                    Pattern.compile(this.getPattern());
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, SearchMessages.SearchPage_containingText_hint);
        }
        return true;
    }

    private void addTextPatternControls(final Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_containingText_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.createPattern(group);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText(SearchMessages.SearchPage_containingText_hint);
        Composite cm = new Composite(group, 0);
        final Button showMultiline = new Button(cm, 16);
        GridData da = new GridData();
        da.horizontalSpan = 4;
        da.verticalAlignment = 128;
        Button showSingleLine = new Button(cm, 16);
        showSingleLine.setSelection(true);
        showSingleLine.setLayoutData((Object)da);
        showSingleLine.setLayoutData((Object)da);
        this.fIsCaseSensitiveCheckbox = new Button(cm, 32);
        this.fIsCaseSensitiveCheckbox.setText(SearchMessages.SearchPage_caseSensitive);
        this.fIsCaseSensitiveCheckbox.setSelection(this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fIsCaseSensitive = AptanaTextSearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fIsRegExCheckbox = new Button(cm, 32);
        this.fIsRegExCheckbox.setText(SearchMessages.SearchPage_regularExpression);
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fIsIgnoreLinesCheckBox = new Button(cm, 32);
        this.fIsIgnoreLinesCheckBox.setText(Messages.Ignore_Line_Engings);
        this.fIsIgnoreLinesCheckBox.setSelection(this.fIgnoreLines);
        this.fIsIgnoreLinesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fIgnoreLines = AptanaTextSearchPage.this.fIsIgnoreLinesCheckBox.getSelection();
                AptanaTextSearchPage.this.linesDelimeter.setVisible(!AptanaTextSearchPage.this.fIgnoreLines);
                AptanaTextSearchPage.this.lineDelimeterlabel.setVisible(!AptanaTextSearchPage.this.fIgnoreLines);
            }
        });
        this.lineDelimeterlabel = new Label(cm, 0);
        this.lineDelimeterlabel.setText("Line Delimeter:");
        this.linesDelimeter = new Combo(cm, 8);
        this.linesDelimeter.setVisible(false);
        this.fIsIgnoreLinesCheckBox.setVisible(false);
        this.linesDelimeter.setVisible(this.fIsMultiline && !this.fIgnoreLines);
        this.lineDelimeterlabel.setVisible(this.fIsMultiline && !this.fIgnoreLines);
        this.linesDelimeter.setItems(new String[]{"Windows", "Unix", "Mac"});
        this.linesDelimeter.select(this.fLineDelimeter);
        this.linesDelimeter.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fLineDelimeter = AptanaTextSearchPage.this.linesDelimeter.getSelectionIndex();
            }

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fLineDelimeter = AptanaTextSearchPage.this.linesDelimeter.getSelectionIndex();
            }
        });
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fIsRegExSearch = AptanaTextSearchPage.this.fIsRegExCheckbox.getSelection();
                AptanaTextSearchPage.this.updateOKStatus();
                AptanaTextSearchPage.this.writeConfiguration();
                AptanaTextSearchPage.this.setContentAssistsEnablement(AptanaTextSearchPage.this.fIsRegExSearch);
            }
        });
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
        GridLayout gridLayout = new GridLayout(5, false);
        cm.setLayout((Layout)gridLayout);
        gridLayout.marginHeight = 0;
        showMultiline.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (showMultiline.getSelection()) {
                    AptanaTextSearchPage.this.toMultiLine(group);
                } else {
                    AptanaTextSearchPage.this.toSingleLine(group);
                }
            }
        });
        showMultiline.setText(Messages.MULTILINE);
        showSingleLine.setText(Messages.SINGLLINE);
        if (this.fIsMultiline) {
            this.toMultiLine(group);
            showMultiline.setSelection(true);
            showSingleLine.setSelection(false);
        } else {
            this.setContentAssistsEnablement(this.fIsRegExSearch);
        }
    }

    private void toMultiLine(Composite group) {
        String text = this.fPattern.getText();
        this.setContentAssistsEnablement(false);
        this.fReplaceContentAssistHandler = null;
        this.linesDelimeter.setVisible(!this.fIgnoreLines);
        this.lineDelimeterlabel.setVisible(!this.fIgnoreLines);
        this.fIsIgnoreLinesCheckBox.setVisible(true);
        this.fMultiLineText = new Text(group, 2818);
        this.fMultiLineText.moveAbove((Control)this.fPattern);
        this.fText = this.fMultiLineText;
        this.fPattern.dispose();
        this.fPattern = null;
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 80;
        this.fMultiLineText.setLayoutData((Object)gridData);
        group.getParent().layout(true, true);
        this.fIsMultiline = true;
        this.writeConfiguration();
        text = text.replace("\\n", "\n");
        text = text.replace("\\r", "\r");
        this.fMultiLineText.setText(text);
        this.setContentAssistsEnablement(this.fIsRegExSearch);
    }

    private void toSingleLine(Composite group) {
        this.setContentAssistsEnablement(false);
        this.fReplaceContentAssistHandler = null;
        String txt = this.fMultiLineText.getText();
        this.linesDelimeter.setVisible(false);
        this.lineDelimeterlabel.setVisible(false);
        this.fIsIgnoreLinesCheckBox.setVisible(false);
        Combo createPattern = this.createPattern(group);
        this.refreshPattern();
        createPattern.setLayoutData((Object)new GridData(768));
        createPattern.moveAbove((Control)this.fText);
        this.fPattern = createPattern;
        this.fText.dispose();
        this.fIsMultiline = false;
        txt = txt.replace("\n", "\\n");
        txt = txt.replace("\r", "\\r");
        group.getParent().layout(true, true);
        createPattern.setText(txt);
        this.writeConfiguration();
        this.setContentAssistsEnablement(this.fIsRegExSearch);
    }

    private Combo createPattern(Composite group) {
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.handleWidgetSelected();
                AptanaTextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AptanaTextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        this.fPattern.setFocus();
        return this.fPattern;
    }

    private void handleWidgetSelected() {
        int selectionIndex;
        int n = selectionIndex = this.fPattern != null ? this.fPattern.getSelectionIndex() : 0;
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.getPattern().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fIsRegExCheckbox.setSelection(patternData.isRegExSearch);
        this.fIsIgnoreLinesCheckBox.setSelection(patternData.isIgnoreLineEndings);
        if (this.fPattern != null) {
            String textPattern = patternData.textPattern;
            textPattern = this.esapeNewLines(textPattern);
            this.fPattern.setText(textPattern);
        }
        this.fFileTypeEditor.setFileTypes(patternData.fileNamePatterns);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private String esapeNewLines(String textPattern) {
        textPattern = textPattern.replace("\r", "\\r");
        textPattern = textPattern.replace("\n", "\\n");
        return textPattern;
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null && text.length() > 0) {
            this.fPattern.setText(this.insertEscapeChars(text));
            if (this.getPreviousExtensions().length > 0) {
                this.fExtensions.setText(this.getPreviousExtensions()[0]);
            } else {
                String extension = this.getExtensionFromEditor();
                if (extension != null) {
                    this.fExtensions.setText(extension);
                } else {
                    this.fExtensions.setText("*");
                }
            }
            return true;
        }
        return false;
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        int lengthOfFirstLine = 0;
        lengthOfFirstLine = sbIn.length();
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return this.esapeNewLines(sbOut.toString());
    }

    private String getExtensionFromEditor() {
        IEditorInput elem;
        IEditorPart ep = SearchPlugin.getActivePage().getActiveEditor();
        if (ep != null && (elem = ep.getEditorInput()) instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)elem).getFile().getFileExtension();
            if (extension == null) {
                return ((IFileEditorInput)elem).getFile().getName();
            }
            return "*." + extension;
        }
        return null;
    }

    private void addFileNameControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_fileNamePatterns_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fExtensions = new Combo(group, 2052);
        this.fExtensions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AptanaTextSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fExtensions.setLayoutData((Object)data);
        this.fExtensions.setFont(group.getFont());
        Button button = new Button(group, 8);
        button.setText(SearchMessages.SearchPage_browse);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        gridData.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        button.setLayoutData((Object)gridData);
        button.setFont(group.getFont());
        this.fFileTypeEditor = this.createFileTypeEditor(button);
        Label description = new Label(group, 16384);
        description.setText(SearchMessages.SearchPage_fileNamePatterns_hint);
        description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        description.setFont(group.getFont());
        this.fSearchDerivedCheckbox = new Button(group, 32);
        this.fSearchDerivedCheckbox.setText("Refresh resources before search");
        this.fSearchDerivedCheckbox.setSelection(this.fSearchDerived);
        this.fSearchDerivedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaTextSearchPage.this.fSearchDerived = AptanaTextSearchPage.this.fSearchDerivedCheckbox.getSelection();
                AptanaTextSearchPage.this.writeConfiguration();
            }
        });
        GridData layoutData = new GridData(4, 0x1000000, false, false, 2, 1);
        layoutData.verticalIndent = 5;
        this.fSearchDerivedCheckbox.setLayoutData((Object)layoutData);
        this.fSearchDerivedCheckbox.setFont(group.getFont());
    }

    private FileTypeEditor createFileTypeEditor(Button button) {
        IEditorRegistry editorRegistry = SearchPlugin.getDefault().getWorkbench().getEditorRegistry();
        Constructor ctr = null;
        try {
            ctr = FileTypeEditor.class.getConstructor(IEditorRegistry.class, Combo.class, Button.class);
            return (FileTypeEditor)ctr.newInstance(editorRegistry, this.fExtensions, button);
        }
        catch (Exception exception) {
            try {
                ctr = FileTypeEditor.class.getConstructor(Combo.class, Button.class);
                return (FileTypeEditor)ctr.newInstance(this.fExtensions, button);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        this.fIgnoreLines = s.getBoolean(STORE_IS_IGNORE_LINE_ENDINGS);
        this.fSearchDerived = s.getBoolean(STORE_SEARCH_DERIVED);
        this.fIsMultiline = s.getBoolean(STORE_SEARCH_MULTILINE);
        try {
            this.scope = s.getInt(SEARCH_SCOPE);
        }
        catch (Exception exception) {
            this.scope = 0;
        }
        try {
            this.fLineDelimeter = s.getInt(STORE_LINEDELIMETER);
        }
        catch (NumberFormatException numberFormatException) {}
        this.fSearchDirectory = s.get(STORE_SEARCH_DIRECTORY);
        if (this.fSearchDirectory == null) {
            this.fSearchDirectory = "";
        }
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_SEARCH_DIRECTORY, this.fSearchDirectory);
        s.put(STORE_SEARCH_MULTILINE, this.fIsMultiline);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        s.put(STORE_IS_IGNORE_LINE_ENDINGS, this.fIgnoreLines);
        s.put(STORE_SEARCH_DERIVED, this.fSearchDerived);
        s.put(STORE_LINEDELIMETER, this.fLineDelimeter);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        s.put(SEARCH_SCOPE, this.scope);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fReplaceContentAssistHandler == null) {
                this.fReplaceContentAssistHandler = this.fPattern != null ? ContentAssistHandler.createHandlerForCombo(this.fPattern, ReplaceDialog2.createContentAssistant(true)) : ContentAssistHandler.createHandlerForText(this.fMultiLineText, ReplaceDialog2.createContentAssistant(true));
            }
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fReplaceContentAssistHandler == null) {
                return;
            }
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    private void statusMessage(boolean error, String message) {
        if (!error && message.length() == 0) {
            GridData da = new GridData();
            da.verticalSpan = 3;
            da.verticalAlignment = 128;
            GridData gridData2 = new GridData();
            gridData2.heightHint = 0;
            this.fStatusLabel.setLayoutData((Object)gridData2);
            this.getControl().getParent().layout(true, true);
            this.fNoLabel = true;
        } else if (this.fNoLabel) {
            GridData da = new GridData();
            da.verticalSpan = 2;
            da.verticalAlignment = 128;
            this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.getControl().getParent().layout(true, true);
            this.fNoLabel = false;
        }
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private void modifyScope(Composite parent, Composite result) {
        try {
            IdeLog.logInfo((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Accessing children of ", (Object[])new Object[]{parent.toString()}));
            Control[] children = parent.getChildren();
            IdeLog.logInfo((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"children taken ", (Object[])new Object[]{parent.toString()}));
            try {
                int a = 0;
                while (a < children.length) {
                    if (children[a] != result && !this.firstOpen) {
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory UI is creating");
                        this.firstOpen = true;
                        children = ((Composite)children[a]).getChildren();
                        final Group scopeGroup = (Group)children[0];
                        Control[] children2 = scopeGroup.getChildren();
                        int b = 0;
                        while (b < children2.length) {
                            Control control2 = children2[b];
                            if (control2 instanceof Button) {
                                Button m = (Button)control2;
                                if ((m.getStyle() & 0x10) != 0) {
                                    Object data = m.getData();
                                    if (data instanceof Integer) {
                                        Integer i = (Integer)data;
                                        if (i == 1) {
                                            m.setText(Messages.SelectedProjectResources);
                                        }
                                        if (i == 3) {
                                            m.setText("Current/Enclosing Project");
                                        }
                                    }
                                    m.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                                }
                                if ((m.getStyle() & 8) != 0) {
                                    GridData gridData = new GridData();
                                    m.setLayoutData((Object)gridData);
                                    gridData.widthHint = SWTUtil.getButtonWidthHint((Button)m);
                                    m.setLayoutData((Object)gridData);
                                }
                            }
                            ++b;
                        }
                        this.fSearchInDirectory = new Button((Composite)scopeGroup, 16);
                        this.fSearchInDirectory.setText(Messages.DIRECTORY);
                        this.fSearchInDirectory.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory UI is nearly created");
                        this.fDirectory = new Text((Composite)scopeGroup, 2056);
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 8;
                        gridData.horizontalSpan = 2;
                        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)"Search in directory was created");
                        this.fDirectory.setLayoutData((Object)gridData);
                        this.fDirectory.setText(this.fSearchDirectory);
                        this.fSearchInDirectory.setData((Object)new Integer(12));
                        Button choose = new Button((Composite)scopeGroup, 8);
                        choose.setText(Messages.CHOOSE);
                        choose.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                DirectoryDialog ddialog = new DirectoryDialog(AptanaTextSearchPage.this.fSearchInDirectory.getShell(), 0);
                                String open = ddialog.open();
                                if (open != null) {
                                    AptanaTextSearchPage.this.fSearchDirectory = open;
                                    AptanaTextSearchPage.this.writeConfiguration();
                                    AptanaTextSearchPage.this.fDirectory.setText(open);
                                    if (AptanaTextSearchPage.this.fSearchInDirectory.getSelection()) {
                                        AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(AptanaTextSearchPage.this.fDirectory.getText().length() > 0);
                                    }
                                }
                            }
                        });
                        this.fSearchInOpenFiles = new Button((Composite)scopeGroup, 16);
                        this.fSearchInOpenFiles.addSelectionListener((SelectionListener)this.scopeSelectionListener);
                        this.fSearchInOpenFiles.setText(Messages.OPEN_EDITORS);
                        this.fSearchInOpenFiles.setData((Object)new Integer(13));
                        GridData dd = new GridData(16384, 0x1000000, false, false);
                        this.fSearchInOpenFiles.setLayoutData((Object)dd);
                        GridData gridData2 = new GridData();
                        gridData2.widthHint = SWTUtil.getButtonWidthHint((Button)choose);
                        choose.setLayoutData((Object)gridData2);
                        this.fSearchInDirectory.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                boolean selection = AptanaTextSearchPage.this.fSearchInDirectory.getSelection();
                                if (!selection) {
                                    AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(true);
                                    return;
                                }
                                AptanaTextSearchPage.this.getContainer().setSelectedScope(1);
                                Control[] c = scopeGroup.getChildren();
                                int a = 0;
                                while (a < c.length) {
                                    Button b;
                                    Control cm = c[a];
                                    if (cm instanceof Button && (b = (Button)cm) != AptanaTextSearchPage.this.fSearchInDirectory && b.getSelection()) {
                                        b.setSelection(false);
                                    }
                                    ++a;
                                }
                                AptanaTextSearchPage.this.getContainer().setPerformActionEnabled(AptanaTextSearchPage.this.fDirectory.getText().length() > 0);
                            }
                        });
                        scopeGroup.layout(true, true);
                        this.selectCurrentScope();
                        break;
                    }
                    ++a;
                }
                if (this.fSearchInDirectory == null) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (String)"Search in directory UI was not created");
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Exception while modifing scope", (Throwable)e);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Exception on top of  modifing scope", (Throwable)e);
        }
    }

    private void selectCurrentScope() {
        if (this.fSearchInDirectory != null) {
            Composite parent = this.fSearchInDirectory.getParent();
            Control[] controlArray = parent.getChildren();
            int n = 0;
            int n2 = controlArray.length;
            while (n < n2) {
                Object data;
                Button btn;
                Control child = controlArray[n];
                if (child instanceof Button && ((btn = (Button)child).getStyle() & 0x10) != 0 && (data = btn.getData()) != null && data instanceof Integer) {
                    if ((Integer)data == this.scope) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                btn.setSelection(true);
                            }
                        });
                        break;
                    }
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            btn.setSelection(false);
                        }
                    });
                }
                ++n;
            }
        }
    }

    private class ScopeSelectionListener
    implements SelectionListener {
        private ScopeSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object data;
            if (!AptanaTextSearchPage.this.firstOpen) {
                return;
            }
            Widget widget = e.widget;
            if (widget != null && (data = widget.getData()) != null && data instanceof Integer) {
                AptanaTextSearchPage.this.scope = (Integer)data;
            }
        }
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;
        private boolean isDirectory;
        private String directory;
        private boolean openFiles;
        private boolean isIgnoreLineEndings;

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets, boolean isDirectory, String directory, boolean openFiles, boolean ignoreLines) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isIgnoreLineEndings = ignoreLines;
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.isDirectory = isDirectory;
            this.directory = directory;
            this.openFiles = openFiles;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            settings.put("isDirectory", this.isDirectory);
            settings.put("openFiles", this.openFiles);
            settings.put("directory", this.directory);
            settings.put("ignoreLines", this.isIgnoreLineEndings);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray("fileNamePatterns")) == null) {
                fileNamePatterns = new String[]{};
            }
            try {
                int scope = settings.getInt("scope");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                boolean isDirecotory = settings.getBoolean("isDirectory");
                String directory = settings.get("directory");
                boolean isOpenFiles = settings.getBoolean("openFiles");
                boolean isiLines = settings.getBoolean("ignoreLines");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, fileNamePatterns, scope, workingSets, isDirecotory, directory, isOpenFiles, isiLines);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public String getPattern() {
            return this.textPattern;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.isRegExSearch;
        }

        public boolean isStringMatcherPattern() {
            return !this.isRegExSearch;
        }
    }

    public static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;
        private final boolean isDirectory;
        private final String directory;
        private final boolean isOpenFiles;
        private boolean fIsIgnoreLineEndings;
        public boolean doRefresh;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public String getDirectory() {
            return this.directory;
        }

        public boolean isIgnoreLineEndings() {
            return this.fIsIgnoreLineEndings;
        }

        public boolean isOpenFiles() {
            return this.isOpenFiles;
        }

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope, boolean isDir, String directory, boolean openFiles, boolean isIgnoreLineEndings) {
            this.fSearchText = searchText;
            this.isDirectory = isDir;
            this.directory = directory;
            this.isOpenFiles = openFiles;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
            this.fIsIgnoreLineEndings = isIgnoreLineEndings;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }

        public boolean isRefresh() {
            return this.doRefresh;
        }
    }
}

