/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.search.epl.filesystem.ui.text;

import com.aptana.ide.search.epl.AptanaFileSystemMatch;
import com.aptana.ide.search.epl.FileSearchQuery;
import com.aptana.ide.search.epl.FileSystemMatch;
import com.aptana.ide.search.epl.SearchAgainConfirmationDialog;
import com.aptana.ide.search.epl.filesystem.text.SearchMessages;
import com.aptana.ide.search.epl.filesystem.ui.text.FileSystemSearchPage;
import com.aptana.ide.search.epl.filesystem.ui.text.ReplaceDialog2;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FileSystemReplaceAction2
extends Action {
    private IWorkbenchSite fSite;
    private File[] fElements;
    private FileSystemSearchPage fPage;

    public FileSystemReplaceAction2(FileSystemSearchPage page, File[] elements) {
        Assert.isNotNull((Object)((Object)page));
        this.fSite = page.getSite();
        this.fElements = elements != null ? elements : new File[0];
        this.fPage = page;
        this.setText(SearchMessages.ReplaceAction_label_all);
        this.setEnabled(this.fElements.length != 0);
    }

    public FileSystemReplaceAction2(FileSystemSearchPage page) {
        Assert.isNotNull((Object)((Object)page));
        this.fSite = page.getSite();
        this.fPage = page;
        Item[] items = null;
        StructuredViewer viewer = this.fPage.getViewer();
        if (viewer instanceof TreeViewer) {
            items = ((TreeViewer)viewer).getTree().getItems();
        } else if (viewer instanceof TableViewer) {
            items = ((TableViewer)viewer).getTable().getItems();
        }
        this.fElements = this.collectFiles(new ItemIterator(items));
        this.setText(SearchMessages.ReplaceAction_label_all);
        this.setEnabled(this.fElements.length != 0);
    }

    public FileSystemReplaceAction2(FileSystemSearchPage page, IStructuredSelection selection) {
        this.fSite = page.getSite();
        this.fPage = page;
        this.setText(SearchMessages.ReplaceAction_label_selected);
        this.fElements = this.collectFiles(selection.iterator());
        this.setEnabled(this.fElements.length != 0);
    }

    /*
     * Unable to fully structure code
     */
    private File[] collectFiles(Iterator resources) {
        files = new HashSet<E>();
        result = this.fPage.getInput();
        if (result != null) ** GOTO lbl9
        return new File[0];
lbl-1000:
        // 1 sources

        {
            resource = null;
            next = resources.next();
            resource = next instanceof AptanaFileSystemMatch != false ? ((AptanaFileSystemMatch)next).getFile() : (File)next;
            this.process(resource, files, result);
lbl9:
            // 2 sources

            ** while (resources.hasNext())
        }
lbl10:
        // 1 sources

        return files.toArray(new File[files.size()]);
    }

    private void process(File resource, Set files, AbstractTextSearchResult result) {
        if (resource.isFile()) {
            if (result.getMatchCount((Object)resource) > 0) {
                files.add(resource);
            }
        } else {
            File[] listFiles = resource.listFiles();
            int a = 0;
            while (a < listFiles.length) {
                this.process(listFiles[a], files, result);
                ++a;
            }
        }
    }

    public void run() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot());
        try {
            try {
                Platform.getJobManager().beginRule(rule, null);
                if (this.validateResources((FileSearchQuery)this.fPage.getInput().getQuery())) {
                    ReplaceDialog2 dialog = new ReplaceDialog2(this.fSite.getShell(), this.fElements, this.fPage);
                    dialog.open();
                }
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        finally {
            Platform.getJobManager().endRule(rule);
        }
    }

    private boolean validateResources(final FileSearchQuery operation) {
        this.getReadOnlyFiles();
        final ArrayList<File> outOfDateEntries = new ArrayList<File>();
        int j = 0;
        while (j < this.fElements.length) {
            File entry = this.fElements[j];
            Match[] markers = this.fPage.getDisplayedMatches(entry);
            int i = 0;
            while (i < markers.length) {
                if (this.isOutOfDate((AptanaFileSystemMatch)markers[i])) {
                    outOfDateEntries.add(entry);
                    break;
                }
                ++i;
            }
            ++j;
        }
        ArrayList<File> outOfSyncEntries = new ArrayList<File>();
        int i = 0;
        while (i < this.fElements.length) {
            File entry = this.fElements[i];
            if (this.isOutOfSync(entry)) {
                outOfSyncEntries.add(entry);
            }
            ++i;
        }
        if (outOfDateEntries.size() > 0 || outOfSyncEntries.size() > 0) {
            if (this.askForResearch(outOfDateEntries, outOfSyncEntries)) {
                ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.fSite.getShell());
                try {
                    pmd.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                            FileSystemReplaceAction2.this.research(monitor, outOfDateEntries, operation);
                        }
                    });
                    return true;
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.fSite.getShell(), (String)SearchMessages.ReplaceAction_label, (String)SearchMessages.ReplaceAction_research_error);
                }
                catch (InterruptedException interruptedException) {}
            }
            return false;
        }
        return true;
    }

    private File[] getReadOnlyFiles() {
        HashSet<File> readOnly = new HashSet<File>();
        int i = 0;
        while (i < this.fElements.length) {
            if (this.fElements[i].canWrite()) {
                readOnly.add(this.fElements[i]);
            }
            ++i;
        }
        File[] readOnlyArray = new File[readOnly.size()];
        return readOnly.toArray(readOnlyArray);
    }

    private void research(IProgressMonitor monitor, List outOfDateEntries, FileSearchQuery operation) throws CoreException {
        String message = SearchMessages.ReplaceAction2_statusMessage;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.search", 0, message, null);
        for (File entry : outOfDateEntries) {
            IStatus status = this.research(operation, monitor, entry);
            if (status == null || status.isOK()) continue;
            multiStatus.add(status);
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private boolean askForResearch(List outOfDateEntries, List outOfSyncEntries) {
        SearchAgainConfirmationDialog dialog = new SearchAgainConfirmationDialog(this.fSite.getShell(), (ILabelProvider)this.fPage.getViewer().getLabelProvider(), outOfSyncEntries, outOfDateEntries);
        return dialog.open() == 0;
    }

    private boolean isOutOfDate(FileSystemMatch match) {
        if (match.getCreationTimeStamp() != match.getFile().lastModified()) {
            return true;
        }
        ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer fb = bm.getTextFileBuffer((IPath)new Path(match.getFile().getAbsolutePath()));
        return fb != null && fb.isDirty();
    }

    private boolean isOutOfSync(File entry) {
        return false;
    }

    private IStatus research(FileSearchQuery operation, IProgressMonitor monitor, File entry) {
        Match[] matches = this.fPage.getDisplayedMatches(entry);
        IStatus status = operation.searchInFile(this.getResult(), monitor, entry);
        int i = 0;
        while (i < matches.length) {
            this.getResult().removeMatch(matches[i]);
            ++i;
        }
        return status;
    }

    private AbstractTextSearchResult getResult() {
        return this.fPage.getInput();
    }

    private static class ItemIterator
    implements Iterator {
        private Item[] fArray;
        private int fNextPosition;

        ItemIterator(Item[] array) {
            this.fArray = array;
            this.fNextPosition = 0;
        }

        public boolean hasNext() {
            return this.fNextPosition < this.fArray.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.fArray[this.fNextPosition++].getData();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

