/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class FileTricks {
    private static Class<?> cShellFolder;
    private static Class<?> cShellFolderManager;
    private static Constructor ctrShellFolderManager;
    private static Method mCreateShellFolder;
    private static Object sfm;

    static {
        try {
            cShellFolder = Class.forName("sun.awt.shell.ShellFolder");
            cShellFolderManager = Class.forName("sun.awt.shell.ShellFolderManager");
            ctrShellFolderManager = cShellFolderManager.getDeclaredConstructor(new Class[0]);
            ctrShellFolderManager.setAccessible(true);
            sfm = ctrShellFolderManager.newInstance(new Object[0]);
            mCreateShellFolder = cShellFolderManager.getDeclaredMethod("createShellFolder", File.class);
            mCreateShellFolder.setAccessible(true);
        }
        catch (Exception exception) {
            cShellFolder = null;
            cShellFolderManager = null;
            ctrShellFolderManager = null;
            mCreateShellFolder = null;
            sfm = null;
        }
    }

    protected FileTricks() {
    }

    public static File attemptReplaceWithShellFolder(File actual) {
        File result = actual;
        if (cShellFolder != null && !cShellFolder.isInstance(actual)) {
            try {
                result = (File)mCreateShellFolder.invoke(sfm, actual);
            }
            catch (Exception e) {
                IdeLog.logInfo(AptanaCorePlugin.getDefault(), Messages.FileTricks_AWT_UnableToReplaceFolder, e);
            }
        }
        return result;
    }

    public static final class FileSnapshot {
        private static Method mGetBooleanAttributes;
        private static int BA_DIRECTORY;
        private static int BA_EXISTS;
        private static int BA_REGULAR;
        private static int BA_HIDDEN;
        private static Object fs;
        public final boolean isDirectory;
        public final boolean exists;
        public final boolean isRegular;
        public final boolean isHidden;

        static {
            try {
                Class<?> cFile = Class.forName("java.io.File");
                Class<?> cFileSystem = Class.forName("java.io.FileSystem");
                mGetBooleanAttributes = cFileSystem.getDeclaredMethod("getBooleanAttributes", File.class);
                Field fBA_EXISTS = cFileSystem.getDeclaredField("BA_EXISTS");
                Field fBA_REGULAR = cFileSystem.getDeclaredField("BA_REGULAR");
                Field fBA_DIRECTORY = cFileSystem.getDeclaredField("BA_DIRECTORY");
                Field fBA_HIDDEN = cFileSystem.getDeclaredField("BA_HIDDEN");
                Field fFs = cFile.getDeclaredField("fs");
                mGetBooleanAttributes.setAccessible(true);
                fFs.setAccessible(true);
                fBA_EXISTS.setAccessible(true);
                fBA_REGULAR.setAccessible(true);
                fBA_DIRECTORY.setAccessible(true);
                fBA_HIDDEN.setAccessible(true);
                BA_EXISTS = (Integer)fBA_EXISTS.get(null);
                BA_REGULAR = (Integer)fBA_REGULAR.get(null);
                BA_DIRECTORY = (Integer)fBA_DIRECTORY.get(null);
                BA_HIDDEN = (Integer)fBA_HIDDEN.get(null);
                fs = fFs.get(null);
            }
            catch (Exception exception) {}
        }

        public FileSnapshot(File f) {
            boolean h;
            boolean r;
            boolean e;
            boolean d;
            try {
                int ba = (Integer)mGetBooleanAttributes.invoke(fs, f);
                d = (ba & BA_DIRECTORY) != 0;
                e = (ba & BA_EXISTS) != 0;
                r = (ba & BA_REGULAR) != 0;
                h = (ba & BA_HIDDEN) != 0;
            }
            catch (Exception exception) {
                d = f.isDirectory();
                e = d || f.exists();
                r = f.isFile();
                h = f.isHidden();
            }
            this.isDirectory = d;
            this.exists = e;
            this.isRegular = r;
            this.isHidden = h;
        }
    }
}

