/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.EclipseUtils;
import com.aptana.ide.core.IdeLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.internal.ui.UpdateUI;

public class InitialStartup
implements IStartup {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";

    public void earlyStartup() {
        try {
            Preferences preferences = EclipseUtils.getUpdatePluginPreferences();
            IdeLog.logInfo(AptanaCorePlugin.getDefault(), "Clean preference: " + preferences.getBoolean("com.aptana.ide.core.PREF_CLEAN_RESTART"));
            if (preferences.getBoolean("com.aptana.ide.core.PREF_CLEAN_RESTART")) {
                preferences.setValue("com.aptana.ide.core.PREF_CLEAN_RESTART", false);
                EclipseUtils.saveUpdatePluginPreferences();
                AptanaCorePlugin.getDefault().savePluginPreferences();
                System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
                String commandLine = this.buildCommandLine("-clean");
                if (commandLine != null) {
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), "New command line " + commandLine);
                    System.setProperty(PROP_EXIT_DATA, commandLine);
                    this.restartIDE();
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), "Unable to clean configuration", e);
        }
        IdeLog.flushCache();
    }

    private void restartIDE() {
        UIJob job = new UIJob("Restarting IDE"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Job[] jobs = Platform.getJobManager().find((Object)"earlyStartup");
                if (jobs.length > 0) {
                    Job[] jobArray = jobs;
                    int n = 0;
                    int n2 = jobArray.length;
                    while (n < n2) {
                        Job job = jobArray[n];
                        if (job.getState() != 0) {
                            this.schedule(100L);
                            return Status.OK_STATUS;
                        }
                        ++n;
                    }
                }
                UpdateUI.getDefault();
                UpdateUI.requestRestart((boolean)true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private String buildCommandLine(String commands) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), "VM arguments null for restart of IDE");
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        if (vmargs != null) {
            result.append(vmargs);
        }
        if ((property = System.getProperty(PROP_COMMANDS)) == null) {
            result.append(commands);
            result.append(NEW_LINE);
        } else {
            result.append(commands);
            result.append(NEW_LINE);
            result.append(property);
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append(vmargs);
        }
        return result.toString();
    }
}

