/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.ILoggable;
import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.model.BaseModelObject;
import com.aptana.ide.core.model.ILocationObject;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequest;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.IServiceResponse;
import com.aptana.ide.core.model.ISynchronizableObject;
import com.aptana.ide.core.model.ITransformObject;
import com.aptana.ide.core.model.ServiceErrors;
import com.aptana.ide.core.xpath.XPathUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreModelObject
extends BaseModelObject
implements ILocationObject,
ISynchronizableObject,
ILoggable,
ITransformObject {
    protected static final XPath XPATH = XPathFactory.newInstance().newXPath();
    public static final String ID_ELEMENT = "id";
    public static final String URLS = "urls";
    public static final String URL = "url";
    public static final String PATHS = "paths";
    public static final String PATH = "path";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    protected String id = null;
    protected IServiceProvider provider;
    protected IServiceRequestBuilder builder;
    protected URL location = null;
    protected URL defaultLocation = null;
    protected ILogger logger;
    private int lastUpdateStatus = -1;
    protected ServiceErrors lastErrors;

    protected abstract String getItemString();

    @Override
    public URL getDefaultLocation() {
        return this.defaultLocation;
    }

    @Override
    public URL getLocation() {
        if (this.location == null && this.defaultLocation != null) {
            return this.defaultLocation;
        }
        return this.location;
    }

    @Override
    public IServiceRequestBuilder getRequestBuilder() {
        return this.builder;
    }

    @Override
    public IServiceProvider getServiceProvider() {
        return this.provider;
    }

    @Override
    public boolean hasLocation() {
        return this.location != null && !this.location.equals(this.defaultLocation);
    }

    @Override
    public void setDefaultLocation(URL defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    @Override
    public void setLocation(URL location) {
        if (this.isModelChanged(this.location, location)) {
            this.location = location;
            this.fireChange();
        }
    }

    @Override
    public synchronized void fromXML(String xml) {
        try {
            XPath xpath = XPathUtils.getNewXPath();
            Node site = (Node)xpath.evaluate("/" + this.getItemString(), XPathUtils.createSource(xml), XPathConstants.NODE);
            this.fromNode(site);
        }
        catch (XPathExpressionException e1) {
            this.logError("XPath error building " + this.getLoggingPrefix() + " from xml: " + e1.getMessage());
        }
    }

    @Override
    public void setRequestBuilder(IServiceRequestBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void setServiceProvider(IServiceProvider provider) {
        this.provider = provider;
    }

    public abstract String getLoggingPrefix();

    public void performUploadAction(Map<String, String> nameValuePairs) {
        this.performAction(nameValuePairs, "POST");
    }

    public void performUploadAction(String name, String value) {
        this.performAction(name, value, "POST");
    }

    public void performUploadAction(String nameValuePairs) {
        this.performAction(nameValuePairs, "POST");
    }

    public void performUpdateAction(Map<String, String> nameValuePairs) {
        this.performAction(nameValuePairs, "GET");
    }

    public void performUpdateAction(String name, String value) {
        this.performAction(name, value, "GET");
    }

    public void performUpdateAction(String nameValuePairs) {
        this.performAction(nameValuePairs, "GET");
    }

    @Override
    public IServiceErrors performAction(Map<String, String> nameValuePairs, String type) {
        StringBuffer query = new StringBuffer("?");
        if (nameValuePairs != null) {
            for (String name : nameValuePairs.keySet()) {
                String value = nameValuePairs.get(name);
                query.append(name);
                query.append('=');
                query.append(value);
                query.append('&');
            }
        }
        return this.performAction(query.toString(), type);
    }

    @Override
    public IServiceErrors performAction(String name, String value, String type) {
        return this.performAction(String.valueOf(name) + "=" + value, type);
    }

    protected void handleActionResponse(IServiceResponse response) {
    }

    @Override
    public IServiceErrors performAction(String nameValuePairs, String type) {
        ServiceErrors errors = null;
        if (this.hasLocation()) {
            String query = "";
            String baseURL = this.getLocation().toExternalForm();
            if (baseURL.indexOf(63) == -1) {
                if (!nameValuePairs.startsWith("?")) {
                    query = String.valueOf(query) + "?";
                }
            } else {
                query = String.valueOf(query) + "&";
            }
            query = String.valueOf(query) + nameValuePairs;
            try {
                URL actionURL = new URL(String.valueOf(baseURL) + query);
                if (this.provider != null && this.builder != null) {
                    IServiceResponse response = null;
                    IServiceRequest request = this.builder.generateRequest(this, type);
                    if (request != null) {
                        this.logInfo(String.valueOf(this.getLoggingPrefix()) + " perform action content:" + request.getContents());
                    } else {
                        this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on perform action");
                    }
                    response = this.provider.callService(actionURL, request);
                    if (response != null) {
                        this.logInfo(String.valueOf(this.getLoggingPrefix()) + " perform action response:" + response.getContents());
                        this.logInfo(String.valueOf(this.getLoggingPrefix()) + " perform action response status:" + response.getStatus());
                        errors = new ServiceErrors();
                        errors.setStatus(response.getStatus());
                        if (response.getStatus() != 200 && response.getStatus() != -200) {
                            errors.fromXML(response.getContents());
                        }
                        this.handleActionResponse(response);
                    }
                }
            }
            catch (MalformedURLException e) {
                this.logError("Error creating action url: " + e.getMessage());
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    protected void logInfo(String message) {
        if (this.logger != null) {
            this.logger.logInfo(message);
        }
    }

    protected void logError(String message) {
        if (this.logger != null) {
            this.logger.logError(message);
        }
    }

    protected void logError(String message, Throwable th) {
        if (this.logger != null) {
            this.logger.logError(message, th);
        }
    }

    protected void logWarning(String message) {
        if (this.logger != null) {
            this.logger.logWarning(message);
        }
    }

    @Override
    public IServiceErrors commit() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "PUT");
            if (request != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " commit content:" + StringUtils.getPublishableMessage(request.getContents()));
            } else {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on commit");
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " commit response:" + response.getContents());
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " commit response status:" + response.getStatus());
                if (response.getStatus() == 201 && response.getData() instanceof URL) {
                    this.setLocation((URL)response.getData());
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.setContents(response.getContents());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                    if (response.getStatus() == 200) {
                        this.fireChange();
                    }
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    public IServiceErrors xmlRest(String method) {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, method);
            if (request != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " xml rest content:" + request.getContents());
            } else {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on xml rest");
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " xml rest response:" + response.getContents());
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " xml rest response status:" + response.getStatus());
                if (response.getStatus() == 201 || response.getStatus() == 200 || response.getStatus() == 204) {
                    if (response.getData() instanceof String) {
                        this.fromXML((String)response.getData());
                    } else if (response.getData() instanceof URL) {
                        this.setLocation((URL)response.getData());
                    }
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    public IServiceErrors upload() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "POST");
            if (request != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " upload content:" + request.getContents());
            } else {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on upload");
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " upload response:" + response.getContents());
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " upload response status:" + response.getStatus());
                if (response.getStatus() == 201 && response.getData() instanceof URL) {
                    this.setLocation((URL)response.getData());
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                    if (response.getStatus() == 200) {
                        this.fireChange();
                    }
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public IServiceErrors delete() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "DELETE");
            if (request != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " delete content:" + request.getContents());
            } else {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on delete");
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " delete response status:" + response.getStatus());
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " delete response:" + response.getContents());
                if (response.getStatus() == 204) {
                    this.setLocation(null);
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public IServiceErrors update() {
        ServiceErrors errors = null;
        if (this.provider != null && this.builder != null) {
            IServiceResponse response = null;
            IServiceRequest request = this.builder.generateRequest(this, "GET");
            if (request != null) {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " update content:" + request.getContents());
            } else {
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " null request generated on update");
            }
            if (this.hasLocation()) {
                response = this.provider.callService(this.getLocation(), request);
            } else if (this.getDefaultLocation() != null) {
                response = this.provider.callService(this.getDefaultLocation(), request);
            }
            if (response != null) {
                this.lastUpdateStatus = response.getStatus();
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " update response status:" + response.getStatus());
                this.logInfo(String.valueOf(this.getLoggingPrefix()) + " update response:" + StringUtils.getPublishableMessage(response.getData()));
                if (response.getStatus() == 200) {
                    if (response.getData() instanceof String) {
                        this.fromXML((String)response.getData());
                    } else if (response.getData() instanceof URL) {
                        this.setLocation((URL)response.getData());
                    }
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                } else if (response.getStatus() != -200) {
                    errors = new ServiceErrors();
                    errors.setStatus(response.getStatus());
                    errors.fromXML(response.getContents());
                }
            }
        }
        this.setLastServiceErrors(errors);
        return errors;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public synchronized void clear() {
    }

    public int getLastUpdateStatus() {
        return this.lastUpdateStatus;
    }

    protected String getTextContent(String xpath, Node node) {
        String text = null;
        try {
            Node subNode = (Node)XPATH.evaluate(xpath, node, XPathConstants.NODE);
            if (subNode != null) {
                text = subNode.getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            this.logError(String.valueOf(this.getLoggingPrefix()) + " XPath error parsing: " + e.getMessage());
        }
        return text;
    }

    @Override
    public ServiceErrors getLastServiceErrors() {
        return this.lastErrors;
    }

    public void setLastServiceErrors(ServiceErrors lastErrors) {
        this.lastErrors = lastErrors;
    }
}

