/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model.user;

import com.aptana.ide.core.model.AuthUtils;
import com.aptana.ide.core.model.ILocationObject;
import com.aptana.ide.core.model.IServiceRequest;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.ITransformObject;
import com.aptana.ide.core.model.XMLServiceRequest;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.model.user.UserRequestBuilder;

public class AuthenticatedUserRequestBuilder
implements IServiceRequestBuilder {
    private User user;
    private UserRequestBuilder builder = new UserRequestBuilder();

    public IServiceRequest generateRequest(ILocationObject object, String type) {
        XMLServiceRequest request = null;
        if (object == null || object.getLocation() == null) {
            return request;
        }
        if (object instanceof ITransformObject) {
            request = "PUT".equals(type) || "DELETE".equals(type) ? new XMLServiceRequest(((ITransformObject)((Object)object)).toXML()) : new XMLServiceRequest("");
            request.setRequestType(type);
            if (object instanceof User) {
                return this.builder.generateRequest(object, type);
            }
            if (this.user != null) {
                request.setAuthentication(AuthUtils.getAuthorizationHeader(this.user.getUsername(), this.user.getPassword()));
            }
        }
        return request;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

