/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.internal.core.resources;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.core.resources.IUniformResourceChangeListener;
import com.aptana.ide.internal.core.events.UniformResourceChangeEvent;
import com.aptana.ide.internal.core.resources.MarkerDelta;
import com.aptana.ide.internal.core.resources.MarkerInfo;
import com.aptana.ide.internal.core.resources.MarkerSet;
import com.aptana.ide.internal.core.resources.Messages;
import com.aptana.ide.internal.core.resources.ResourceInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerTypeDefinitionCache;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;

public final class MarkerManager {
    private static final MarkerInfo[] NO_MARKER_INFO = new MarkerInfo[0];
    private static MarkerManager instance;
    private MarkerTypeDefinitionCache cache = new MarkerTypeDefinitionCache();
    private long nextMarkerId = 0L;
    private Map resources = new HashMap();
    private ListenerList listeners = new ListenerList();
    private IMarker rootMarker;
    private Map currentDeltas = null;
    private Object lock = new Object();

    public static MarkerManager getInstance() {
        if (instance == null) {
            instance = new MarkerManager();
        }
        return instance;
    }

    private MarkerManager() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            this.rootMarker = workspace.getRoot().createMarker("com.aptana.ide.internal.core.resources.ExternalResourcesMarker");
        }
        catch (CoreException e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), "", e);
        }
        if (this.rootMarker != null) {
            workspace.addResourceChangeListener(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    MarkerManager.this.handleResourceChanged();
                }
            }, 8);
        }
    }

    public MarkerInfo findMarkerInfo(IUniformResource resource, long id) {
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            return null;
        }
        MarkerSet markers = info.getMarkers(false);
        if (markers == null) {
            return null;
        }
        return (MarkerInfo)markers.get(id);
    }

    public void add(IUniformResource resource, MarkerInfo marker) throws CoreException {
        MarkerSet markers;
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            info = this.createResourceInfo(resource);
        }
        if ((markers = info.getMarkers(true)) == null) {
            markers = new MarkerSet(1);
        }
        this.basicAdd(resource, markers, marker);
        if (!markers.isEmpty()) {
            info.setMarkers(markers);
        }
        IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(1, resource, marker)};
        this.changedMarkers(resource, changes);
    }

    public boolean isPersistent(MarkerInfo info) {
        if (!this.cache.isPersistent(info.getType())) {
            return false;
        }
        Object isTransient = info.getAttribute("transient");
        return isTransient == null || !(isTransient instanceof Boolean) || (Boolean)isTransient == false;
    }

    public void removeMarker(IUniformResource resource, long id) throws CoreException {
        MarkerInfo marker = this.findMarkerInfo(resource, id);
        if (marker == null) {
            return;
        }
        ResourceInfo info = this.getResourceInfo(resource);
        MarkerSet markers = info.getMarkers(true);
        int size = markers.size();
        markers.remove((IMarkerSetElement)marker);
        info.setMarkers(markers.size() == 0 ? null : markers);
        if (markers.size() != size) {
            IMarkerSetElement[] changes = new IMarkerSetElement[]{new MarkerDelta(2, resource, marker)};
            this.changedMarkers(resource, changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changedMarkers(IUniformResource resource, IMarkerSetElement[] changes) throws CoreException {
        if (changes == null || changes.length == 0) {
            return;
        }
        URI uri = resource.getURI();
        Object object = this.lock;
        synchronized (object) {
            MarkerSet previousChanges;
            MarkerSet result;
            if (this.currentDeltas == null) {
                this.currentDeltas = new HashMap();
            }
            if ((result = MarkerDelta.merge(previousChanges = (MarkerSet)((Object)this.currentDeltas.get(uri)), changes)).size() == 0) {
                this.currentDeltas.remove(uri);
            } else {
                this.currentDeltas.put(uri, result);
            }
        }
        if (this.rootMarker != null) {
            this.rootMarker.setAttribute("updateId", this.rootMarker.getAttribute("updateId", 0) + 1);
        }
    }

    public boolean isSubtype(String type, String superType) {
        return this.cache.isSubtype(type, superType);
    }

    public MarkerInfo[] findMarkersInfo(IUniformResource resource, String type, boolean includeSubtypes) {
        ArrayList<MarkerInfo> result = new ArrayList<MarkerInfo>();
        ResourceInfo info = this.getResourceInfo(resource);
        if (info == null) {
            return NO_MARKER_INFO;
        }
        MarkerSet markers = info.getMarkers(false);
        if (markers == null) {
            return NO_MARKER_INFO;
        }
        IMarkerSetElement[] elements = markers.elements();
        int i = 0;
        while (i < elements.length) {
            MarkerInfo marker = (MarkerInfo)elements[i];
            if (type == null) {
                result.add(marker);
            } else if (includeSubtypes) {
                if (this.isSubtype(marker.getType(), type)) {
                    result.add(marker);
                }
            } else if (marker.getType().equals(type)) {
                result.add(marker);
            }
            ++i;
        }
        if (result.size() == 0) {
            return NO_MARKER_INFO;
        }
        return result.toArray(new MarkerInfo[result.size()]);
    }

    private ResourceInfo getResourceInfo(IUniformResource resource) {
        return (ResourceInfo)this.resources.get(resource.getURI());
    }

    private ResourceInfo createResourceInfo(IUniformResource resource) {
        ResourceInfo info = new ResourceInfo();
        this.resources.put(resource.getURI(), info);
        return info;
    }

    private void basicAdd(IUniformResource resource, MarkerSet markers, MarkerInfo newMarker) throws CoreException {
        if (newMarker.getId() != -1L) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.core", 0, Messages.MarkerManager_MarkerIDIsDefined, null));
        }
        newMarker.setId(this.nextMarkerId());
        markers.add((IMarkerSetElement)newMarker);
    }

    private long nextMarkerId() {
        return this.nextMarkerId++;
    }

    public void addResourceChangeListener(IUniformResourceChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeResourceChangeListener(IUniformResourceChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void externalResourceChanged(IUniformResource resource) {
        this.handleResourceChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceChanged() {
        MarkerSet[] markers;
        if (this.currentDeltas == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            markers = this.currentDeltas.values().toArray(new MarkerSet[this.currentDeltas.size()]);
            this.currentDeltas = null;
        }
        Object[] list = this.listeners.getListeners();
        int j = 0;
        while (j < markers.length) {
            Object[] deltas = new IMarkerDelta[markers[j].size()];
            markers[j].copyInto(deltas);
            IUniformResource resource = null;
            if (deltas.length > 0 && deltas[0] instanceof MarkerDelta) {
                resource = ((MarkerDelta)((Object)deltas[0])).getUniformResource();
            }
            UniformResourceChangeEvent event = new UniformResourceChangeEvent(this, resource, (IMarkerDelta[])deltas);
            int i = 0;
            while (i < list.length) {
                try {
                    ((IUniformResourceChangeListener)list[i]).resourceChanged(event);
                }
                catch (Exception e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), "", e);
                }
                ++i;
            }
            ++j;
        }
    }
}

