/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.contentassist;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.contentassist.AdditionalInfoController;
import com.aptana.ide.editors.unified.contentassist.ContentAssistSubjectControlAdapter;
import com.aptana.ide.editors.unified.contentassist.ContentAssistant;
import com.aptana.ide.editors.unified.contentassist.Helper;
import com.aptana.ide.editors.unified.contentassist.IContentAssistListener;
import com.aptana.ide.editors.unified.contentassist.IUnifiedCompletionProposal;
import com.aptana.ide.editors.unified.contentassist.PopupCloser;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CompletionProposalPopup
implements IContentAssistListener {
    public static final int PROPOSAL_ITEM_HEIGHT = 7;
    private ITextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private AdditionalInfoController fAdditionalInfoController;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fProposalShell;
    private Table fProposalTable;
    private boolean fInserting = false;
    private ProposalSelectionListener fKeyListener;
    private List<DocumentEvent> fDocumentEvents = new ArrayList<DocumentEvent>();
    private IDocumentListener fDocumentListener;
    private long fInvocationCounter = 0L;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private int fFilterOffset;
    private char fActivationKey;
    private boolean _insertOnTab;
    private int fUserAgents = 0;
    private ICompletionProposal fLastProposal;
    private IContentAssistSubjectControl fContentAssistSubjectControl;
    private ContentAssistSubjectControlAdapter fContentAssistSubjectControlAdapter;
    private Point fSize;
    private IEditingSupport fFocusHelper;
    private boolean fIsFilteredSubset;
    int defaultIndex = -1;
    private char fLastKeyPressed;

    public CompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = viewer;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fViewer);
    }

    public CompletionProposalPopup(ContentAssistant contentAssistant, IContentAssistSubjectControl contentAssistSubjectControl, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fContentAssistSubjectControl = contentAssistSubjectControl;
        this.fAdditionalInfoController = infoController;
        this.fContentAssistSubjectControlAdapter = new ContentAssistSubjectControlAdapter(this.fContentAssistSubjectControl);
    }

    public String showProposals(final boolean autoActivated) {
        Control control;
        if (this.fKeyListener == null) {
            this.fKeyListener = new ProposalSelectionListener();
        }
        if ((control = this.fContentAssistSubjectControlAdapter.getControl()) != null && !control.isDisposed()) {
            this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int count;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset, autoActivated);
                    int n = count = CompletionProposalPopup.this.fComputedProposals == null ? 0 : CompletionProposalPopup.this.fComputedProposals.length;
                    if (count == 0) {
                        CompletionProposalPopup.this.hide();
                    } else if (count == 1 && !autoActivated && CompletionProposalPopup.this.canAutoInsert(CompletionProposalPopup.this.fComputedProposals[0])) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fComputedProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else {
                        CompletionProposalPopup.this.createPopup();
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private ICompletionProposal[] computeProposals(int offset, boolean autoActivated) {
        if (this.fContentAssistSubjectControl != null) {
            return this.fContentAssistant.computeCompletionProposals(this.fContentAssistSubjectControl, offset, this.fActivationKey);
        }
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, offset, this.fActivationKey, autoActivated);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        Color c;
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        Control control = this.fContentAssistSubjectControlAdapter.getControl();
        this.fProposalShell = new Shell(control.getShell(), 16400);
        this.fProposalTable = new Table((Composite)this.fProposalShell, 0x10000300);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CompletionProposalPopup.this.handleSetData(event);
            }
        };
        this.fProposalTable.addListener(36, listener);
        final IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        this._insertOnTab = store.getBoolean("com.aptana.ide.editors.INSERT_ON_TAB");
        String agents = store.getString("com.aptana.ide.editor.USER_AGENT_PREFERENCE");
        this.fUserAgents = agents != null && !agents.equals("") ? agents.split(",").length : 0;
        TableColumn initialInfo = new TableColumn(this.fProposalTable, 16384);
        initialInfo.setWidth(16);
        int i = 0;
        while (i < this.fUserAgents) {
            TableColumn tc = new TableColumn(this.fProposalTable, 16384);
            tc.setWidth(17);
            ++i;
        }
        TableColumn locationInfo = new TableColumn(this.fProposalTable, 16384);
        locationInfo.setWidth(16);
        this.fProposalTable.setLocation(0, 0);
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.setSizeConstraints(40, 10, true, false);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fProposalShell.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        Point size = this.fContentAssistant.restoreCompletionProposalPopupSize();
        if (size != null) {
            this.fProposalTable.setLayoutData((Object)data);
            this.fProposalShell.setSize(size);
        } else {
            data.heightHint = this.fProposalTable.getItemHeight() * 7;
            data.widthHint = 300;
            this.fProposalTable.setLayoutData((Object)data);
            this.fProposalShell.pack();
        }
        this.fProposalShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (CompletionProposalPopup.this.fAdditionalInfoController != null) {
                    CompletionProposalPopup.this.fAdditionalInfoController.setSizeConstraints(40, 10, true, false);
                }
                CompletionProposalPopup.this.fSize = CompletionProposalPopup.this.fProposalShell.getSize();
            }
        });
        if (!"carbon".equals(SWT.getPlatform())) {
            this.fProposalShell.setBackground(control.getDisplay().getSystemColor(2));
        }
        if ((c = this.fContentAssistant.getProposalSelectorBackground()) == null) {
            c = control.getDisplay().getSystemColor(25);
        }
        this.fProposalTable.setBackground(c);
        c = this.fContentAssistant.getProposalSelectorForeground();
        if (c == null) {
            c = control.getDisplay().getSystemColor(28);
        }
        this.fProposalTable.setForeground(c);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompletionProposalPopup.this.selectProposalWithMask(e.stateMask);
                if ("win32".equals(Platform.getOS())) {
                    CompletionProposalPopup.this.disposePopup();
                }
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable);
        final IPropertyChangeListener propListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.aptana.ide.editor.USER_AGENT_PREFERENCE")) {
                    if (Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                        CompletionProposalPopup.this.fProposalShell.dispose();
                    } else if (store != null) {
                        store.removePropertyChangeListener((IPropertyChangeListener)this);
                    }
                }
            }
        };
        store.addPropertyChangeListener(propListener);
        this.fProposalShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (store != null && propListener != null) {
                    store.removePropertyChangeListener(propListener);
                }
                CompletionProposalPopup.this.unregister();
            }
        });
        this.fProposalTable.setHeaderVisible(false);
    }

    private void handleSetData(Event event) {
        TableItem item = (TableItem)event.item;
        int index = this.fProposalTable.indexOf(item);
        this.defaultIndex = -1;
        if (index >= 0 && index < this.fFilteredProposals.length) {
            ICompletionProposal current = this.fFilteredProposals[index];
            String entry = current.getDisplayString().trim();
            item.setImage(current.getImage());
            item.setText(0, entry);
            item.setData((Object)current);
            if (current instanceof IUnifiedCompletionProposal) {
                IUnifiedCompletionProposal prop = (IUnifiedCompletionProposal)current;
                String loc = prop.getFileLocation();
                Image[] images = prop.getUserAgentImages();
                if (images != null) {
                    int j = 0;
                    while (j < images.length) {
                        Image image = images[j];
                        item.setImage(j + 1, image);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < this.fUserAgents) {
                        item.setImage(j + 1, null);
                        ++j;
                    }
                }
                if (this.fUserAgents > 0) {
                    item.setText(this.fUserAgents + 1, " " + loc);
                } else {
                    item.setText(this.fUserAgents + 1, loc);
                }
                if (current instanceof IUnifiedCompletionProposal && ((IUnifiedCompletionProposal)current).isDefaultSelection()) {
                    this.defaultIndex = index;
                }
            }
        }
        if (this.defaultIndex != -1) {
            this.selectProposal(this.defaultIndex, false, true);
        }
    }

    private ICompletionProposal getSelectedProposal() {
        int i = this.fProposalTable.getSelectionIndex();
        if (this.fFilteredProposals == null || i < 0 || i >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[i];
    }

    private boolean selectProposalWithMask(int stateMask) {
        ICompletionProposal p = this.getSelectedProposal();
        this.hide();
        if (p == null) {
            return false;
        }
        this.insertProposal(p, '\u0000', stateMask, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
        return true;
    }

    private void insertProposal(ICompletionProposal p, char trigger, int stateMask, final int offset) {
        this.fInserting = true;
        IRewriteTarget target = null;
        IEditingSupport helper = new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion focus) {
                return focus.getOffset() <= offset && focus.getOffset() + focus.getLength() >= offset;
            }

            public boolean ownsFocusShell() {
                return false;
            }
        };
        try {
            IContextInformation info;
            ICompletionProposalExtension2 e;
            IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
            if (this.fViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)this.fViewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)this.fViewer;
                registry.register(helper);
            }
            if (p instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                e = (ICompletionProposalExtension2)p;
                e.apply(this.fViewer, trigger, stateMask, offset);
            } else if (p instanceof ICompletionProposalExtension) {
                e = (ICompletionProposalExtension)p;
                e.apply(document, trigger, offset);
            } else {
                p.apply(document);
            }
            Point selection = p.getSelection(document);
            if (selection != null) {
                this.fContentAssistSubjectControlAdapter.setSelectedRange(selection.x, selection.y);
                this.fContentAssistSubjectControlAdapter.revealRange(selection.x, selection.y);
            }
            if ((info = p.getContextInformation()) != null) {
                int contextInformationOffset;
                if (p instanceof ICompletionProposalExtension) {
                    ICompletionProposalExtension e2 = (ICompletionProposalExtension)p;
                    contextInformationOffset = e2.getContextInformationPosition();
                } else {
                    if (selection == null) {
                        selection = this.fContentAssistSubjectControlAdapter.getSelectedRange();
                    }
                    contextInformationOffset = selection.x + selection.y;
                }
                this.fContentAssistant.showContextInformation(info, contextInformationOffset);
            } else {
                this.fContentAssistant.showContextInformation(null, -1);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)this.fViewer;
                registry.unregister(helper);
            }
            this.fInserting = false;
        }
    }

    public boolean hasFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            return this.fProposalShell.isFocusControl() || this.fProposalTable.isFocusControl();
        }
        return false;
    }

    public void hide() {
        this.fLastKeyPressed = '\u0000';
        this.unregister();
        if (this.fViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)this.fViewer;
            registry.unregister(this.fFocusHelper);
        }
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            if (this.fAdditionalInfoController != null) {
                this.fAdditionalInfoController.disposeInformationControl();
            }
            this.fProposalShell.setVisible(false);
        }
    }

    public void disposePopup() {
        if (this.fProposalShell != null && !this.fProposalShell.isDisposed()) {
            this.fProposalShell.dispose();
        }
    }

    private void unregister() {
        if (this.fDocumentListener != null) {
            IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
            if (document != null) {
                document.removeDocumentListener(this.fDocumentListener);
            }
            this.fDocumentListener = null;
        }
        this.fDocumentEvents.clear();
        if (this.fKeyListener != null && this.fContentAssistSubjectControlAdapter.getControl() != null && !this.fContentAssistSubjectControlAdapter.getControl().isDisposed()) {
            this.fContentAssistSubjectControlAdapter.removeKeyListener(this.fKeyListener);
            this.fKeyListener = null;
        }
        if (this.fLastProposal != null) {
            if (this.fLastProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ICompletionProposalExtension2 extension = (ICompletionProposalExtension2)this.fLastProposal;
                extension.unselected(this.fViewer);
            }
            this.fLastProposal = null;
        }
        this.fFilteredProposals = null;
        this.fComputedProposals = null;
        this.fContentAssistant.possibleCompletionsClosed();
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed() && this.fProposalShell.isVisible();
    }

    private void setProposals(ICompletionProposal[] proposals, boolean isFilteredSubset) {
        if (Helper.okToUse((Widget)this.fProposalTable)) {
            ICompletionProposal oldProposal = this.getSelectedProposal();
            if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
                ((ICompletionProposalExtension2)oldProposal).unselected(this.fViewer);
            }
            this.fFilteredProposals = proposals;
            int newLen = proposals.length;
            int defaultIndex = -1;
            int suggestedIndex = -1;
            String longestString = "";
            String longestLoc = "";
            int totalItems = 0;
            this.fProposalTable.setItemCount(newLen);
            this.fProposalTable.clearAll();
            int i = 0;
            while (i < proposals.length) {
                ICompletionProposal proposal = proposals[i];
                String entry = proposal.getDisplayString().trim();
                if (entry.length() > longestString.length()) {
                    longestString = entry;
                }
                if (proposal instanceof IUnifiedCompletionProposal) {
                    IUnifiedCompletionProposal prop = (IUnifiedCompletionProposal)proposal;
                    String loc = prop.getFileLocation();
                    if (loc.length() > longestLoc.length()) {
                        longestLoc = loc;
                    }
                    if (((IUnifiedCompletionProposal)proposal).isDefaultSelection()) {
                        defaultIndex = i;
                    } else if (((IUnifiedCompletionProposal)proposal).isSuggestedSelection()) {
                        suggestedIndex = i;
                    }
                }
                ++i;
            }
            String measureString = "MMMM" + longestString + "MMM";
            GC gc = new GC((Drawable)this.fProposalTable.getShell());
            Point locationWidth = gc.stringExtent(String.valueOf(longestLoc) + "MMM");
            measureString = String.valueOf(measureString) + longestLoc + "MMM";
            Point widestText = gc.stringExtent(String.valueOf(longestString) + "MMMMMM");
            Point extent = gc.stringExtent(measureString);
            gc.dispose();
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                measureString = "MMMM" + longestString + "MMMM";
                int j = 1;
                while (j < this.fProposalTable.getColumnCount()) {
                    if (j == this.fUserAgents + 1) {
                        if (this.fProposalTable.getColumn(j).getWidth() != locationWidth.x) {
                            this.fProposalTable.getColumn(j).setWidth(locationWidth.x);
                        }
                    } else if (this.fProposalTable.getColumn(j).getWidth() != 19) {
                        this.fProposalTable.getColumn(j).setWidth(19);
                    }
                    ++j;
                }
            } else {
                this.fProposalTable.getColumn(this.fUserAgents + 1).pack();
            }
            TableColumn first = this.fProposalTable.getColumn(0);
            if (first.getWidth() != widestText.x) {
                this.fProposalTable.getColumn(0).setWidth(widestText.x);
            }
            int width = extent.x;
            if (this.fUserAgents > 0) {
                width = System.getProperty("os.name").startsWith("Mac OS") ? (width += this.fUserAgents * (this.fProposalTable.getColumn(1).getWidth() - 5)) : (width += this.fUserAgents * 10);
            }
            if (totalItems > 7) {
                totalItems = 7;
            }
            int height = this.fProposalTable.getItemHeight() * 7;
            GridData data = new GridData(1808);
            data.heightHint = height;
            data.widthHint = width;
            this.fProposalTable.setLayoutData((Object)data);
            this.fProposalShell.pack(true);
            if (defaultIndex != -1) {
                this.selectProposal(defaultIndex, false, true);
            } else if (suggestedIndex != -1) {
                this.fProposalTable.deselectAll();
                this.setScroll(suggestedIndex);
            } else if (this.fProposalTable != null) {
                if (this.fLastKeyPressed == '\b' && defaultIndex == -1) {
                    this.hide();
                } else {
                    this.fProposalTable.setTopIndex(0);
                    this.fProposalTable.deselectAll();
                }
            }
        }
    }

    public static Point computeLocation(Rectangle proposalBox, Rectangle displayBounds, Point caretLocation, int lineHeight) {
        if (caretLocation.y + proposalBox.height > displayBounds.height + displayBounds.y) {
            return new Point(caretLocation.x, caretLocation.y - (lineHeight + proposalBox.height));
        }
        return new Point(caretLocation.x, caretLocation.y + lineHeight);
    }

    Point getSize() {
        return this.fSize;
    }

    private void displayProposals() {
        if (!Helper.okToUse((Widget)this.fProposalShell) || !Helper.okToUse((Widget)this.fProposalTable)) {
            return;
        }
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            IDocument document;
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.fDocumentEvents.add(event);
                        }
                    }

                    public void documentChanged(DocumentEvent event) {
                        if (!CompletionProposalPopup.this.fInserting) {
                            CompletionProposalPopup.this.filterProposals();
                        }
                    }
                };
            }
            if ((document = this.fContentAssistSubjectControlAdapter.getDocument()) != null) {
                document.addDocumentListener(this.fDocumentListener);
            }
            if (this.fFocusHelper == null) {
                this.fFocusHelper = new IEditingSupport(){

                    public boolean isOriginator(DocumentEvent event, IRegion focus) {
                        return false;
                    }

                    public boolean ownsFocusShell() {
                        return true;
                    }
                };
            }
            if (this.fViewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)this.fViewer;
                registry.register(this.fFocusHelper);
            }
            this.fProposalShell.setVisible(true);
            if (!this.fContentAssistSubjectControlAdapter.supportsVerifyKeyListener() && Helper.okToUse((Widget)this.fProposalShell)) {
                this.fProposalShell.setFocus();
            }
            if (this.fAdditionalInfoController != null && Helper.okToUse((Widget)this.fProposalTable)) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        } else {
            this.hide();
        }
    }

    public boolean verifyKey(VerifyEvent e) {
        if (!Helper.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char key = e.character;
        this.fLastKeyPressed = e.character;
        if (key == '\u0000') {
            int newSelection = this.fProposalTable.getSelectionIndex();
            int visibleRows = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            boolean smartToggle = false;
            switch (e.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.hide();
                    return true;
                }
                case 0x1000001: {
                    if (--newSelection >= 0) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000002: {
                    if (++newSelection <= this.fProposalTable.getItemCount() - 1) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000006: {
                    if ((newSelection += visibleRows) < this.fProposalTable.getItemCount()) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000005: {
                    if ((newSelection -= visibleRows) >= 0) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000007: {
                    this.hide();
                    return true;
                }
                case 0x1000008: {
                    this.hide();
                    return true;
                }
                default: {
                    if (e.keyCode != 16777298 && e.keyCode != SWT.MOD1 && e.keyCode != SWT.MOD2 && e.keyCode != SWT.MOD3 && e.keyCode != SWT.MOD4) {
                        this.hide();
                    }
                    return true;
                }
            }
            this.selectProposal(newSelection, smartToggle, false);
            e.doit = false;
            return false;
        }
        switch (key) {
            case '\t': {
                if (!this._insertOnTab) {
                    e.doit = true;
                    this.hide();
                    break;
                }
                if (this.selectProposalWithMask(e.stateMask)) {
                    e.doit = false;
                    break;
                }
                return true;
            }
            case '\u001b': {
                e.doit = false;
                this.hide();
                break;
            }
            case '\n': 
            case '\r': {
                if (this.selectProposalWithMask(e.stateMask)) {
                    e.doit = false;
                    break;
                }
                return true;
            }
            default: {
                ICompletionProposalExtension t;
                char[] triggers;
                ICompletionProposal p = this.getSelectedProposal();
                if (!(p instanceof ICompletionProposalExtension) || !this.contains(triggers = (t = (ICompletionProposalExtension)p).getTriggerCharacters(), key)) break;
                e.doit = false;
                this.hide();
                this.insertProposal(p, key, e.stateMask, this.fContentAssistSubjectControlAdapter.getSelectedRange().x);
            }
        }
        return true;
    }

    private void selectProposal(int index, boolean smartToggle, boolean autoScroll) {
        ICompletionProposal proposal;
        if (this.fFilteredProposals == null) {
            return;
        }
        ICompletionProposal oldProposal = this.getSelectedProposal();
        if (oldProposal instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)oldProposal).unselected(this.fViewer);
        }
        if ((proposal = this.fFilteredProposals[index]) instanceof ICompletionProposalExtension2 && this.fViewer != null) {
            ((ICompletionProposalExtension2)proposal).selected(this.fViewer, smartToggle);
        }
        this.fLastProposal = proposal;
        this.fProposalTable.setSelection(index);
        if (autoScroll) {
            this.setScroll(index);
        }
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private void setScroll(int index) {
        int topIndex = index - 4 > 0 ? index - 4 : 0;
        this.fProposalTable.setTopIndex(topIndex);
    }

    private boolean contains(char[] characters, char c) {
        if (characters == null) {
            return false;
        }
        int i = 0;
        while (i < characters.length) {
            if (c == characters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void processEvent(VerifyEvent e) {
    }

    private void filterProposals() {
        ++this.fInvocationCounter;
        final Control control = this.fContentAssistSubjectControlAdapter.getControl();
        control.getDisplay().asyncExec(new Runnable(){
            final long fCounter;
            {
                this.fCounter = CompletionProposalPopup.this.fInvocationCounter;
            }

            public void run() {
                if (this.fCounter != CompletionProposalPopup.this.fInvocationCounter) {
                    return;
                }
                if (control.isDisposed()) {
                    return;
                }
                int offset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                ICompletionProposal[] proposals = null;
                try {
                    try {
                        if (offset > -1) {
                            DocumentEvent event = TextUtilities.mergeProcessedDocumentEvents((List)CompletionProposalPopup.this.fDocumentEvents);
                            proposals = CompletionProposalPopup.this.computeFilteredProposals(offset, event);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    CompletionProposalPopup.this.fDocumentEvents.clear();
                }
                CompletionProposalPopup.this.fFilterOffset = offset;
                if (proposals != null && proposals.length > 0) {
                    CompletionProposalPopup.this.fContentAssistant.promoteKeyListener();
                    CompletionProposalPopup.this.setProposals(proposals, CompletionProposalPopup.this.fIsFilteredSubset);
                } else {
                    CompletionProposalPopup.this.hide();
                }
            }
        });
    }

    private ICompletionProposal[] computeFilteredProposals(int offset, DocumentEvent event) {
        ICompletionProposal[] proposals;
        if (offset == this.fInvocationOffset && event == null) {
            this.fIsFilteredSubset = false;
            return this.fComputedProposals;
        }
        if (offset < this.fInvocationOffset) {
            this.fIsFilteredSubset = false;
            this.fInvocationOffset = offset;
            this.fComputedProposals = this.computeProposals(this.fInvocationOffset, false);
            return this.fComputedProposals;
        }
        if (offset < this.fFilterOffset) {
            proposals = this.fComputedProposals;
            this.fIsFilteredSubset = false;
        } else {
            proposals = this.fFilteredProposals;
            this.fIsFilteredSubset = true;
        }
        if (proposals == null) {
            this.fIsFilteredSubset = false;
            return null;
        }
        IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
        int length = proposals.length;
        ArrayList<ICompletionProposalExtension2> filtered = new ArrayList<ICompletionProposalExtension2>(length);
        int i = 0;
        while (i < length) {
            ICompletionProposalExtension2 p;
            if (proposals[i] instanceof ICompletionProposalExtension2) {
                p = (ICompletionProposalExtension2)proposals[i];
                if (p.validate(document, offset, event)) {
                    filtered.add(p);
                }
            } else if (proposals[i] instanceof ICompletionProposalExtension) {
                p = (ICompletionProposalExtension)proposals[i];
                if (p.isValidFor(document, offset)) {
                    filtered.add(p);
                }
            } else {
                this.fIsFilteredSubset = false;
                this.fInvocationOffset = offset;
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset, false);
                return this.fComputedProposals;
            }
            ++i;
        }
        return filtered.toArray(new ICompletionProposal[filtered.size()]);
    }

    public void setFocus() {
        if (Helper.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }

    private boolean canAutoInsert(ICompletionProposal proposal) {
        if (this.fContentAssistant.isAutoInserting()) {
            if (proposal instanceof ICompletionProposalExtension4) {
                ICompletionProposalExtension4 ext = (ICompletionProposalExtension4)proposal;
                return ext.isAutoInsertable();
            }
            return true;
        }
        return false;
    }

    public String incrementalComplete() {
        if (Helper.okToUse((Widget)this.fProposalShell) && this.fFilteredProposals != null) {
            this.completeCommonPrefix();
        } else {
            Control control = this.fContentAssistSubjectControlAdapter.getControl();
            if (this.fKeyListener == null) {
                this.fKeyListener = new ProposalSelectionListener();
            }
            if (!Helper.okToUse((Widget)this.fProposalShell) && !control.isDisposed()) {
                this.fContentAssistSubjectControlAdapter.addKeyListener(this.fKeyListener);
            }
            BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    int count;
                    CompletionProposalPopup.this.fInvocationOffset = ((CompletionProposalPopup)CompletionProposalPopup.this).fContentAssistSubjectControlAdapter.getSelectedRange().x;
                    CompletionProposalPopup.this.fFilterOffset = CompletionProposalPopup.this.fInvocationOffset;
                    CompletionProposalPopup.this.fFilteredProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset, false);
                    int n = count = CompletionProposalPopup.this.fFilteredProposals == null ? 0 : CompletionProposalPopup.this.fFilteredProposals.length;
                    if (count == 0) {
                        CompletionProposalPopup.this.hide();
                    } else if (count == 1 && CompletionProposalPopup.this.canAutoInsert(CompletionProposalPopup.this.fFilteredProposals[0])) {
                        CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fFilteredProposals[0], '\u0000', 0, CompletionProposalPopup.this.fInvocationOffset);
                        CompletionProposalPopup.this.hide();
                    } else if (CompletionProposalPopup.this.completeCommonPrefix()) {
                        CompletionProposalPopup.this.hide();
                    } else {
                        CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.fFilteredProposals;
                        CompletionProposalPopup.this.createPopup();
                    }
                }
            });
        }
        return this.getErrorMessage();
    }

    private void createPopup() {
        this.createProposalSelector();
        this.setProposals(this.fComputedProposals, false);
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
        this.displayProposals();
    }

    private boolean completeCommonPrefix() {
        if (this.fFilteredProposals.length == 1) {
            if (this.canAutoInsert(this.fFilteredProposals[0])) {
                this.insertProposal(this.fFilteredProposals[0], '\u0000', 0, this.fFilterOffset);
                this.hide();
                return true;
            }
            return false;
        }
        IDocument document = this.fContentAssistSubjectControlAdapter.getDocument();
        CharSequence rightCasePostfix = null;
        ArrayList<ICompletionProposal> rightCase = new ArrayList<ICompletionProposal>();
        boolean checkWrongCase = true;
        CharSequence wrongCasePrefix = null;
        int wrongCasePrefixStart = 0;
        CharSequence wrongCasePostfix = null;
        ArrayList<ICompletionProposal> wrongCase = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < this.fFilteredProposals.length) {
            ICompletionProposal proposal = this.fFilteredProposals[i];
            CharSequence insertion = this.getPrefixCompletion(proposal);
            int start = this.getPrefixCompletionOffset(proposal);
            try {
                int prefixLength = this.fFilterOffset - start;
                int relativeCompletionOffset = Math.min(insertion.length(), prefixLength);
                String prefix = document.get(start, prefixLength);
                if (insertion.toString().startsWith(prefix)) {
                    checkWrongCase = false;
                    rightCase.add(proposal);
                    CharSequence newPostfix = insertion.subSequence(relativeCompletionOffset, insertion.length());
                    if (rightCasePostfix == null) {
                        rightCasePostfix = new StringBuffer(newPostfix.toString());
                    } else {
                        this.truncatePostfix((StringBuffer)rightCasePostfix, newPostfix);
                    }
                } else if (checkWrongCase) {
                    CharSequence newPrefix = insertion.subSequence(0, relativeCompletionOffset);
                    if (this.isPrefixCompatible(wrongCasePrefix, wrongCasePrefixStart, newPrefix, start, document)) {
                        wrongCasePrefix = newPrefix;
                        wrongCasePrefixStart = start;
                        CharSequence newPostfix = insertion.subSequence(relativeCompletionOffset, insertion.length());
                        if (wrongCasePostfix == null) {
                            wrongCasePostfix = new StringBuffer(newPostfix.toString());
                        } else {
                            this.truncatePostfix((StringBuffer)wrongCasePostfix, newPostfix);
                        }
                        wrongCase.add(proposal);
                    } else {
                        checkWrongCase = false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (rightCasePostfix != null && ((StringBuffer)rightCasePostfix).length() == 0 && rightCase.size() > 1) {
                return false;
            }
            ++i;
        }
        if (rightCase.size() == 1) {
            ICompletionProposal proposal = (ICompletionProposal)rightCase.get(0);
            if (this.canAutoInsert(proposal)) {
                this.insertProposal(proposal, '\u0000', 0, this.fInvocationOffset);
                this.hide();
                return true;
            }
            return false;
        }
        if (checkWrongCase && wrongCase.size() == 1) {
            ICompletionProposal proposal = (ICompletionProposal)wrongCase.get(0);
            if (this.canAutoInsert(proposal)) {
                this.insertProposal(proposal, '\u0000', 0, this.fInvocationOffset);
                this.hide();
                return true;
            }
            return false;
        }
        CharSequence prefix = checkWrongCase ? wrongCasePrefix : "";
        CharSequence postfix = checkWrongCase ? wrongCasePostfix : rightCasePostfix;
        if (prefix == null || postfix == null) {
            return false;
        }
        try {
            int to = Math.min(document.getLength(), this.fFilterOffset + postfix.length());
            StringBuffer inDocument = new StringBuffer(document.get(this.fFilterOffset, to - this.fFilterOffset));
            this.truncatePostfix(inDocument, postfix);
            document.replace(this.fFilterOffset - prefix.length(), prefix.length() + inDocument.length(), String.valueOf(prefix.toString()) + postfix.toString());
            this.fContentAssistSubjectControlAdapter.setSelectedRange(this.fFilterOffset + postfix.length(), 0);
            this.fContentAssistSubjectControlAdapter.revealRange(this.fFilterOffset + postfix.length(), 0);
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isPrefixCompatible(CharSequence oneSequence, int oneOffset, CharSequence twoSequence, int twoOffset, IDocument document) throws BadLocationException {
        if (oneSequence == null || twoSequence == null) {
            return true;
        }
        int min = Math.min(oneOffset, twoOffset);
        int oneEnd = oneOffset + oneSequence.length();
        int twoEnd = twoOffset + twoSequence.length();
        String one = String.valueOf(document.get(oneOffset, min - oneOffset)) + oneSequence + document.get(oneEnd, Math.min(this.fFilterOffset, this.fFilterOffset - oneEnd));
        String two = String.valueOf(document.get(twoOffset, min - twoOffset)) + twoSequence + document.get(twoEnd, Math.min(this.fFilterOffset, this.fFilterOffset - twoEnd));
        return one.equals(two);
    }

    private void truncatePostfix(StringBuffer buffer, CharSequence sequence) {
        int min = Math.min(buffer.length(), sequence.length());
        int c = 0;
        while (c < min) {
            if (sequence.charAt(c) != buffer.charAt(c)) {
                buffer.delete(c, buffer.length());
                return;
            }
            ++c;
        }
        buffer.delete(min, buffer.length());
    }

    private int getPrefixCompletionOffset(ICompletionProposal proposal) {
        if (proposal instanceof ICompletionProposalExtension3) {
            return ((ICompletionProposalExtension3)proposal).getPrefixCompletionStart(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
        }
        return this.fInvocationOffset;
    }

    private CharSequence getPrefixCompletion(ICompletionProposal proposal) {
        CharSequence insertion = null;
        if (proposal instanceof ICompletionProposalExtension3) {
            insertion = ((ICompletionProposalExtension3)proposal).getPrefixCompletionText(this.fContentAssistSubjectControlAdapter.getDocument(), this.fFilterOffset);
        }
        if (insertion == null) {
            insertion = proposal.getDisplayString();
        }
        return insertion;
    }

    public char getActivationKey() {
        return this.fActivationKey;
    }

    public void setActivationKey(char activationKey) {
        this.fActivationKey = activationKey;
    }

    private final class ProposalSelectionListener
    implements KeyListener {
        private ProposalSelectionListener() {
        }

        public void keyPressed(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, true, true);
            }
        }

        public void keyReleased(KeyEvent e) {
            int index;
            if (!Helper.okToUse((Widget)CompletionProposalPopup.this.fProposalShell)) {
                return;
            }
            if (e.character == '\u0000' && e.keyCode == SWT.MOD1 && (index = CompletionProposalPopup.this.fProposalTable.getSelectionIndex()) >= 0) {
                CompletionProposalPopup.this.selectProposal(index, false, true);
            }
        }
    }
}

