/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.contentassist;

import com.aptana.ide.editors.unified.contentassist.ContentAssistant;
import com.aptana.ide.editors.unified.contentassist.Helper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

class PopupCloser
extends ShellAdapter
implements FocusListener,
SelectionListener {
    private ContentAssistant fContentAssistant;
    private Table fTable;
    private ScrollBar fScrollbar;
    private boolean fScrollbarClicked = false;
    private Shell fShell;

    PopupCloser() {
    }

    public void install(ContentAssistant contentAssistant, Table table) {
        this.fContentAssistant = contentAssistant;
        this.fTable = table;
        if (Helper.okToUse((Widget)this.fTable)) {
            Shell shell = this.fTable.getShell();
            if (Helper.okToUse((Widget)shell)) {
                this.fShell = shell;
                this.fShell.addShellListener((ShellListener)this);
            }
            this.fTable.addFocusListener((FocusListener)this);
            this.fScrollbar = this.fTable.getVerticalBar();
            if (this.fScrollbar != null) {
                this.fScrollbar.addSelectionListener((SelectionListener)this);
            }
        }
    }

    public void uninstall() {
        this.fContentAssistant = null;
        if (Helper.okToUse((Widget)this.fShell)) {
            this.fShell.removeShellListener((ShellListener)this);
        }
        this.fShell = null;
        if (Helper.okToUse((Widget)this.fScrollbar)) {
            this.fScrollbar.removeSelectionListener((SelectionListener)this);
        }
        if (Helper.okToUse((Widget)this.fTable)) {
            this.fTable.removeFocusListener((FocusListener)this);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.fScrollbarClicked = true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.fScrollbarClicked = true;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(final FocusEvent e) {
        this.fScrollbarClicked = false;
        Display d = this.fTable.getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                if (Helper.okToUse((Widget)PopupCloser.this.fTable) && !PopupCloser.this.fTable.isFocusControl() && !PopupCloser.this.fScrollbarClicked && PopupCloser.this.fContentAssistant != null) {
                    PopupCloser.this.fContentAssistant.popupFocusLost(e);
                }
            }
        });
    }

    public void shellDeactivated(ShellEvent e) {
        if (this.fContentAssistant != null) {
            this.fContentAssistant.hide();
        }
    }

    public void shellClosed(ShellEvent e) {
        if (this.fContentAssistant != null) {
            this.fContentAssistant.hide();
        }
    }
}

