/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.internal.ui.dialogs.PreferencesAccess;
import com.aptana.ide.ui.editors.preferences.formatter.DefaultCodeFormatterConstants;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.ProfileManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class FormatterProfileManager
extends ProfileManager {
    public static final String JAVA_PROFILE = "org.eclipse.jdt.ui.default.sun_profile";
    public static final String NO_FORMATTING = "com.aptana.ide.formatting._noformatting";
    public static final String DEFAULT_PROFILE = "org.eclipse.jdt.ui.default.sun_profile";
    private static final ProfileManager.KeySet[] KEY_SETS = new ProfileManager.KeySet[]{new ProfileManager.KeySet("com.aptana.ide.editors.codeassist", new ArrayList(FormatterProfileManager.getNoFormattingSettings().keySet())), new ProfileManager.KeySet("com.aptana.ide.editors.codeassist", Collections.EMPTY_LIST)};
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";

    public FormatterProfileManager(List profiles, IScopeContext context, PreferencesAccess preferencesAccess, String pluginId) {
        super(FormatterProfileManager.addBuiltinProfiles(profiles, pluginId), context, preferencesAccess, KEY_SETS, PROFILE_KEY, FORMATTER_SETTINGS_VERSION, pluginId);
    }

    private static List addBuiltinProfiles(List profiles, String pluginId) {
        Map javaSettings = FormatterProfileManager.getJavaSettings();
        if (pluginId.equals("com.aptana.ide.editor.php")) {
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.brace_position_for_method_declaration", "next_line");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.brace_position_for_block", "next_line");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.brace_position_for_block_in_case", "next_line");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.brace_position_for_switch", "next_line");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.tabulation.char", " ");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.tabulation.size", "4");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_body", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.indent_statements_compare_to_block", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_switch", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.indent_switchstatements_compare_to_cases", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.indent_breaks_compare_to_cases", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns", Boolean.TRUE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.keep_then_statement_on_same_line", Boolean.FALSE.toString());
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.blank_lines_before_imports", "5");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.blank_lines_before_method", "0");
            javaSettings.put("com.aptana.ide.editors.codeassist.formatter.number_of_blank_lines_at_beginning_of_method_body", "0");
        }
        ProfileManager.BuiltInProfile javaProfile = new ProfileManager.BuiltInProfile("org.eclipse.jdt.ui.default.sun_profile", FormatterMessages.ProfileManager_java_conventions_profile_name, javaSettings, 1, 1, "");
        ProfileManager.BuiltInProfile noFormatting = new ProfileManager.BuiltInProfile(NO_FORMATTING, FormatterMessages.ProfileManager_noformatting_profile_name, FormatterProfileManager.getNoFormattingSettings(), 1, 1, "");
        profiles.add(javaProfile);
        profiles.add(noFormatting);
        return profiles;
    }

    public static Map getNoFormattingSettings() {
        Map original = FormatterProfileManager.getJavaSettings();
        original.put("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant", "yes");
        return original;
    }

    public static Map getEclipse21Settings() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        return options;
    }

    public static Map getEclipseSettings() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        return options;
    }

    public static Map getJavaSettings() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        return options;
    }

    public static Map getDefaultSettings() {
        return FormatterProfileManager.getEclipseSettings();
    }

    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String tabSetting;
        IEclipsePreferences node;
        String profileId = instanceScope.getNode(this.pluginId).get(PROFILE_KEY, null);
        if (profileId == null && "org.eclipse.jdt.ui.default.sun_profile".equals(profileId = new DefaultScope().getNode(this.pluginId).get(PROFILE_KEY, null)) && (node = instanceScope.getNode(this.pluginId)) != null && " ".equals(tabSetting = node.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", null))) {
            profileId = "org.eclipse.jdt.ui.default.sun_profile";
        }
        return profileId;
    }

    public ProfileManager.Profile getDefaultProfile() {
        return this.getProfile("org.eclipse.jdt.ui.default.sun_profile");
    }
}

