/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.codeassist.Activator;
import com.aptana.ide.editors.unified.ICodeFormatter;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.Messages;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UnifiedColorizer;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.editors.unified.painting.WhitespacePainter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import java.text.ParseException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class Preview {
    protected final Document fPreviewDocument;
    protected IParseState parseState;
    protected final IParser parser;
    protected final ICodeFormatter formatter;
    protected final IPreferenceStore fPreferenceStore;
    protected TextViewer fSourceViewer;
    protected Map fWorkingValues;
    private int fTabSize = 0;
    private WhitespacePainter fWhitespaceCharacterPainter;
    private UnifiedColorizer colorizer = UnifiedColorizer.getInstance();
    private LanguageColorizer languageColorizer;

    public Preview(Map workingValues, Composite parent, String language, IPreferenceStore pstore) {
        IPreferenceStore prioritizedSettings;
        this.parser = LanguageRegistry.createParser((String)language);
        this.formatter = LanguageRegistry.getCodeFormatter((String)language);
        this.parseState = this.parser.createParseState(null);
        this.fPreviewDocument = new Document();
        this.fWorkingValues = workingValues;
        this.languageColorizer = LanguageRegistry.getLanguageColorizer((String)language);
        this.fPreferenceStore = prioritizedSettings = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        this.fSourceViewer = new TextViewer(parent, 2824);
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
        this.fSourceViewer.getTextWidget().setBackground(this.languageColorizer.getBackground());
        this.fSourceViewer.getTextWidget().addLineStyleListener(new LineStyleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lineGetStyle(LineStyleEvent e) {
                int lineLength;
                int orgOffset;
                if (Preview.this.parseState == null) {
                    return;
                }
                LexemeList lexemeList = Preview.this.parseState.getLexemeList();
                if (lexemeList == null) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedEditor_LexemeListIsNull);
                    return;
                }
                int offset = orgOffset = e.lineOffset;
                int extra = 0;
                int maxLineLength = lineLength = e.lineText.length();
                Lexeme[] lexemes = null;
                LexemeList lexemeList2 = lexemeList;
                synchronized (lexemeList2) {
                    int startingIndex = lexemeList.getLexemeCeilingIndex(offset);
                    int endingIndex = lexemeList.getLexemeFloorIndex(offset + maxLineLength);
                    if (startingIndex == -1 && endingIndex != -1) {
                        startingIndex = endingIndex;
                    }
                    if (endingIndex == -1 && startingIndex != -1) {
                        endingIndex = startingIndex;
                    }
                    if (startingIndex != -1 && endingIndex != -1) {
                        lexemes = lexemeList.cloneRange(startingIndex, endingIndex);
                    }
                }
                if (lexemes != null) {
                    Vector styles = new Vector();
                    Preview.this.colorizer.createStyles(Preview.this.parseState, styles, lexemes, true);
                    StyleRange[] styleResults = styles.toArray(new StyleRange[0]);
                    if (extra > 0) {
                        int i = 0;
                        while (i < styleResults.length) {
                            StyleRange range = styleResults[i];
                            range.start -= extra;
                            ++i;
                        }
                    }
                    e.styles = styleResults;
                }
            }
        });
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        new JavaSourcePreviewerUpdater();
        this.updateWidget();
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        int tabSize = Preview.getPositiveIntValue((String)this.fWorkingValues.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size"), 0);
        if (tabSize != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(tabSize);
        }
        this.fTabSize = tabSize;
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        this.doFormatPreview();
        this.updateWidget();
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
        this.updateWidget();
    }

    protected void updateWidget() {
        String string = this.fSourceViewer.getDocument().get();
        this.parseState = this.parser.createParseState(null);
        this.parseState.setEditState(string, null, 0, 0);
        try {
            this.parser.parse(this.parseState);
            LexemeList lexemeList = this.parseState.getLexemeList();
            int a = 0;
            while (a < lexemeList.size()) {
                LanguageRegistry.getLanguageColorizer((String)lexemeList.get(a).getLanguage());
                ++a;
            }
        }
        catch (ParseException e1) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)e1.getMessage());
        }
        catch (LexerException e1) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)e1.getMessage());
        }
        this.fSourceViewer.getDocument().set(this.fSourceViewer.getDocument().get());
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int defaultValue) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultValue;
    }

    public Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public void setWorkingValues(Map workingValues) {
        this.fWorkingValues = workingValues;
    }

    public void showInvisibleCharacters(boolean enable) {
        if (enable) {
            if (this.fWhitespaceCharacterPainter == null) {
                IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
                String spaceChar = store.getString("com.aptana.ide.editor.SPACE_WHITESPACE_STRING");
                String tabChar = store.getString("com.aptana.ide.editor.TAB_WHITESPACE_STRING");
                this.fWhitespaceCharacterPainter = new WhitespacePainter((ITextViewer)this.fSourceViewer, spaceChar, tabChar, 1000);
                this.fWhitespaceCharacterPainter.setColor(UnifiedColorManager.getInstance().getColor(new RGB(200, 200, 200)));
                this.fWhitespaceCharacterPainter.handleDrawRequest(null);
                this.fSourceViewer.addPainter((IPainter)this.fWhitespaceCharacterPainter);
            }
        } else {
            if (this.fWhitespaceCharacterPainter != null) {
                this.fSourceViewer.removePainter((IPainter)this.fWhitespaceCharacterPainter);
                this.fWhitespaceCharacterPainter.deactivate(true);
                this.fWhitespaceCharacterPainter.dispose();
            }
            this.fWhitespaceCharacterPainter = null;
        }
    }

    private final class JavaSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ((JavaSourcePreviewerUpdater)JavaSourcePreviewerUpdater.this).Preview.this.fSourceViewer.getTextWidget().setBackground(Preview.this.languageColorizer.getBackground());
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ((JavaSourcePreviewerUpdater)JavaSourcePreviewerUpdater.this).Preview.this.fSourceViewer.getTextWidget().setBackground(Preview.this.languageColorizer.getBackground());
                Preview.this.updateWidget();
            }
        };

        public JavaSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            Preview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            Preview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener(JavaSourcePreviewerUpdater.this.fontListener);
                    ((JavaSourcePreviewerUpdater)JavaSourcePreviewerUpdater.this).Preview.this.fPreferenceStore.removePropertyChangeListener(JavaSourcePreviewerUpdater.this.propertyListener);
                }
            });
        }
    }
}

