/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.editors.preferences.formatter;

import com.aptana.ide.editors.codeassist.Activator;
import com.aptana.ide.ui.editors.preferences.formatter.FormatterMessages;
import com.aptana.ide.ui.editors.preferences.formatter.Preview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class SnippetPreview
extends Preview {
    private ArrayList fSnippets = new ArrayList();

    public SnippetPreview(Map workingValues, Composite parent, String editor, IPreferenceStore store) {
        super(workingValues, parent, editor, store);
    }

    protected void doFormatPreview() {
        if (this.fSnippets.isEmpty()) {
            this.fPreviewDocument.set("");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (PreviewSnippet snippet : this.fSnippets) {
            String formattedSource;
            try {
                formattedSource = snippet.source;
            }
            catch (Exception e) {
                Status status = new Status(4, "com.aptana.ide.editors.codeassist", 0, FormatterMessages.JavaPreview_formatter_exception, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                continue;
            }
            buffer.append("\n");
            buffer.append(formattedSource);
            buffer.append("\n");
            buffer.append("\n");
        }
        this.fPreviewDocument.set(buffer.toString());
    }

    public void add(PreviewSnippet snippet) {
        this.fSnippets.add(snippet);
    }

    public void remove(PreviewSnippet snippet) {
        this.fSnippets.remove(snippet);
    }

    public void addAll(Collection snippets) {
        this.fSnippets.addAll(snippets);
    }

    public void clear() {
        this.fSnippets.clear();
    }

    public static final class PreviewSnippet {
        public String header;
        public final String source;
        public final int kind;

        public PreviewSnippet(int kind, String source) {
            this.kind = kind;
            this.source = source;
        }
    }
}

