/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import java.util.ArrayList;

public final class ServerPathUtils {
    public static String getFileNameByPathWithParameters(String path) {
        if (ServerPathUtils.startsWithQuote(path)) {
            String[] parts = ServerPathUtils.parseCommand(path);
            if (parts == null || parts.length == 0) {
                return null;
            }
            return parts[1];
        }
        int fileNameEndPos = ServerPathUtils.getFileEndPosition(path);
        if (fileNameEndPos == -1) {
            return path;
        }
        return path.substring(0, fileNameEndPos);
    }

    public static String[] getParameters(String path) {
        if (ServerPathUtils.startsWithQuote(path)) {
            String[] parts = ServerPathUtils.parseCommand(path);
            if (parts == null || parts.length == 0) {
                return new String[0];
            }
            String[] toReturn = new String[parts.length - 1];
            int i = 1;
            while (i < parts.length) {
                toReturn[i - 1] = parts[i];
                ++i;
            }
            return toReturn;
        }
        int fileNameEndPos = ServerPathUtils.getFileEndPosition(path);
        if (fileNameEndPos == -1) {
            return new String[0];
        }
        String parametersSubString = path.substring(fileNameEndPos, path.length());
        return ServerPathUtils.parseCommand(parametersSubString);
    }

    private static int getFileEndPosition(String path) {
        String subPath = path;
        int firstQuotePos = path.indexOf(34);
        if (firstQuotePos != -1) {
            subPath = path.substring(0, firstQuotePos);
        }
        int lastSlashPos = subPath.lastIndexOf(47);
        int lastBackSlashPos = subPath.lastIndexOf(92);
        int lastSeparator = 0;
        lastSeparator = lastSlashPos > lastBackSlashPos ? lastSlashPos : lastBackSlashPos;
        if (lastSeparator <= 0) {
            return -1;
        }
        int fileNameEndPos = -1;
        int pos = lastSeparator;
        while (pos < path.length()) {
            if (Character.isWhitespace(path.charAt(pos))) {
                fileNameEndPos = pos;
            }
            ++pos;
        }
        return fileNameEndPos;
    }

    private static String[] parseCommand(String command) {
        ArrayList<String> result = new ArrayList<String>();
        char previousChar = '\u0000';
        char ch = '\u0000';
        StringBuilder currentPart = new StringBuilder();
        boolean insideQuotes = false;
        int i = 0;
        while (i < command.length()) {
            previousChar = ch;
            ch = command.charAt(i);
            if (insideQuotes) {
                if (ch == '\'' && previousChar != '\\') {
                    result.add(currentPart.toString());
                    currentPart.replace(0, currentPart.length(), "");
                    insideQuotes = false;
                } else {
                    currentPart.append(ch);
                }
            } else if (Character.isWhitespace(ch)) {
                if (currentPart.length() != 0) {
                    result.add(currentPart.toString());
                    currentPart.replace(0, currentPart.length(), "");
                }
            } else if (ch == '\'' && previousChar != '\\') {
                insideQuotes = true;
            } else {
                currentPart.append(ch);
            }
            ++i;
        }
        if (currentPart.length() != 0) {
            result.add(currentPart.toString());
        }
        String[] toReturn = new String[result.size()];
        return result.toArray(toReturn);
    }

    static boolean startsWithQuote(String str) {
        if (str.length() == 0) {
            return false;
        }
        return str.trim().charAt(0) == '\"';
    }
}

