/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl;

import com.aptana.ide.server.core.IAbstractConfiguration;
import java.util.HashMap;

public class Configuration
implements IAbstractConfiguration {
    private static final String[] NO_VALUES = new String[0];
    private HashMap map = new HashMap();

    public IAbstractConfiguration createSubConfiguration(String name) {
        this.checkName(name);
        Configuration cm = new Configuration();
        this.map.put(name, cm);
        return cm;
    }

    public boolean getBooleanAttribute(String name) {
        this.checkName(name);
        Object object = this.map.get(name);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return bl;
        }
        return false;
    }

    public int getIntAttribute(String name) {
        this.checkName(name);
        Object object = this.map.get(name);
        if (object == null) {
            return 0;
        }
        if (object instanceof Integer) {
            Integer bl = (Integer)object;
            return bl;
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String[] getStringArrayAttribute(String name) {
        this.checkName(name);
        Object object = this.map.get(name);
        if (object == null) {
            return NO_VALUES;
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        return null;
    }

    public String getStringAttribute(String name) {
        this.checkName(name);
        Object object = this.map.get(name);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public IAbstractConfiguration getSubConfiguration(String name) {
        this.checkName(name);
        Object object = this.map.get(name);
        if (object == null) {
            return null;
        }
        if (object instanceof IAbstractConfiguration) {
            return (IAbstractConfiguration)object;
        }
        return null;
    }

    public void removeAttribute(String name) {
        this.checkName(name);
        this.map.remove(name);
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.checkName(name);
        this.map.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setIntAttribute(String name, int value) {
        this.checkName(name);
        this.map.put(name, new Integer(value));
    }

    public void setStringArrayAttribute(String name, String[] value) {
        this.checkName(name);
        this.map.put(name, value);
    }

    public void setStringAttribute(String name, String value) {
        this.checkName(name);
        this.map.put(name, value);
    }

    public void setSubConfiguration(String name, IAbstractConfiguration configuration) {
        this.checkName(name);
        this.map.put(name, configuration);
    }

    public String[] propertyNames() {
        String[] set = new String[this.map.size()];
        this.map.keySet().toArray(set);
        return set;
    }
}

