/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;

public class PreferencesConfiguration
implements IAbstractConfiguration {
    private static final String[] EMPTY_ARRAY = new String[0];
    Preferences prefs;
    String baseKey;

    public PreferencesConfiguration(Preferences prefs, String key) {
        this.prefs = prefs;
        this.baseKey = key;
    }

    public IAbstractConfiguration createSubConfiguration(String name) {
        return new PreferencesConfiguration(this.prefs, this.getKey(name));
    }

    private String getKey(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return StringUtils.format((String)"{0}.{1}", (Object[])new Object[]{this.baseKey, name});
    }

    public boolean getBooleanAttribute(String name) {
        return this.prefs.getBoolean(this.getKey(name));
    }

    public int getIntAttribute(String name) {
        return this.prefs.getInt(this.getKey(name));
    }

    public String[] getStringArrayAttribute(String name) {
        String string = this.prefs.getString(this.getKey(name));
        if (string.length() == 0) {
            return EMPTY_ARRAY;
        }
        return string.split(",");
    }

    public void setStringArrayAttribute(String name, String[] value) {
        StringBuffer bf = new StringBuffer();
        int a = 0;
        while (a < value.length) {
            bf.append(value[a]);
            if (a != value.length - 1) {
                bf.append(',');
            }
            ++a;
        }
        this.prefs.setValue(this.getKey(name), bf.toString());
    }

    public String getStringAttribute(String name) {
        return this.prefs.getString(this.getKey(name));
    }

    public IAbstractConfiguration getSubConfiguration(String name) {
        return this.createSubConfiguration(name);
    }

    public void removeAttribute(String name) {
        this.prefs.setValue(this.getKey(name), "");
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.prefs.setValue(this.getKey(name), value);
    }

    public void setIntAttribute(String name, int value) {
        this.prefs.setValue(this.getKey(name), value);
    }

    public void setStringAttribute(String name, String value) {
        this.prefs.setValue(this.getKey(name), value);
    }

    public void setSubConfiguration(String name, IAbstractConfiguration configuration) {
        String[] propertyNames = configuration.propertyNames();
        int a = 0;
        while (a < propertyNames.length) {
            this.setStringAttribute(this.getKey(propertyNames[a]), configuration.getStringAttribute(propertyNames[a]));
            ++a;
        }
    }

    public String[] propertyNames() {
        String[] propertyNames = this.prefs.propertyNames();
        ArrayList<String> filtered = new ArrayList<String>();
        String start = this.getKey("");
        int a = 0;
        while (a < propertyNames.length) {
            if (propertyNames[a].startsWith(start)) {
                filtered.add(propertyNames[a].substring(start.length()));
            }
            ++a;
        }
        String[] result = new String[filtered.size()];
        filtered.toArray(result);
        return result;
    }
}

