/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.ServerCore;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class RegistryLazyObject
implements IAdaptable {
    protected final IConfigurationElement element;
    private Object object = null;

    protected boolean shouldCache() {
        return true;
    }

    public RegistryLazyObject(IConfigurationElement element) {
        this.element = element;
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    protected Object getObject() {
        if (this.object == null) {
            try {
                Object createExecutableExtension = this.element.createExecutableExtension("class");
                if (!this.shouldCache()) {
                    return createExecutableExtension;
                }
                this.object = createExecutableExtension;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ServerCore.getDefault(), (String)"exception while instantiating registry object", (Throwable)e);
            }
        }
        return this.object;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryLazyObject other = (RegistryLazyObject)obj;
        return this.getId().equals(other.getId());
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter(this.getObject(), adapter);
    }

    protected boolean getBooleanAttribute(String string) {
        String attribute = this.element.getAttribute(string);
        if (attribute == null || attribute.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(attribute);
    }

    protected boolean hasValue(String value, String attr) {
        String attribute = this.element.getAttribute(attr);
        if (attribute == null) {
            return false;
        }
        String[] split = attribute.split(",");
        return Arrays.asList(split).contains(value);
    }
}

