/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl;

import com.aptana.ide.server.core.impl.RegistryLazyObject;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public abstract class RegistryObjectCollection {
    private final String id;
    private HashMap extensions;

    public RegistryObjectCollection(String id) {
        this.id = id;
    }

    public RegistryLazyObject getObject(String id) {
        this.checkLoad();
        return (RegistryLazyObject)this.extensions.get(id);
    }

    public RegistryLazyObject[] getAll() {
        this.checkLoad();
        RegistryLazyObject[] result = new RegistryLazyObject[this.extensions.size()];
        this.extensions.values().toArray(result);
        return result;
    }

    private void checkLoad() {
        if (this.extensions == null) {
            this.extensions = new HashMap();
            IConfigurationElement[] configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(this.id);
            int a = 0;
            while (a < configurationElementsFor.length) {
                IConfigurationElement configurationElement = configurationElementsFor[a];
                RegistryLazyObject registryLazyObject = this.createObject(configurationElement);
                this.extensions.put(registryLazyObject.getId(), registryLazyObject);
                ++a;
            }
        }
    }

    protected abstract RegistryLazyObject createObject(IConfigurationElement var1);
}

