/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSErrorManager;
import com.aptana.ide.editor.js.JSFileLanguageService;
import com.aptana.ide.editor.js.JSLanguageEnvironment;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.jscomment.JSCommentFileLanguageService;
import com.aptana.ide.editor.scriptdoc.ScriptDocFileLanguageService;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDocParseState;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.managers.FileContextManager;
import com.aptana.ide.editors.profiles.ProfileManager;
import com.aptana.ide.editors.unified.BaseFileServiceFactory;
import com.aptana.ide.editors.unified.FileService;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.ILanguageEnvironment;
import com.aptana.ide.editors.unified.IParentOffsetMapper;
import com.aptana.ide.editors.unified.LanguageRegistry;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.editors.unified.errors.IErrorManager;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.IParser;
import org.eclipse.core.runtime.Plugin;

public final class JSFileServiceFactory
extends BaseFileServiceFactory {
    private static JSFileServiceFactory instance;

    public static JSFileServiceFactory getInstance() {
        if (instance == null) {
            instance = new JSFileServiceFactory();
        }
        return instance;
    }

    private JSFileServiceFactory() {
        UnifiedEditorsPlugin editorsPlugin = UnifiedEditorsPlugin.getDefault();
        if (editorsPlugin != null) {
            ProfileManager profileManager = editorsPlugin.getProfileManager();
            ILanguageEnvironment jsEnvironment = JSLanguageEnvironment.getInstance();
            profileManager.addLanguageSupport("text/javascript", jsEnvironment, (IFileServiceFactory)this);
        }
    }

    protected IParser createScanner() {
        IParser result = null;
        if (UnifiedEditorsPlugin.getDefault().useFastScan()) {
            result = LanguageRegistry.getScanner((String)"text/javascript");
        }
        return result;
    }

    public FileService createFileService(IFileSourceProvider sourceProvider, boolean parse) {
        String uri;
        FileService context;
        if (PluginUtils.isPluginLoaded((Plugin)UnifiedEditorsPlugin.getDefault()) && (context = FileContextManager.get((String)(uri = sourceProvider.getSourceURI()))) != null) {
            FileService fs = context;
            IParseState ps = fs.getParseState();
            IFileSourceProvider sp = fs.getSourceProvider();
            if (ps != null && sp != null && sp == sourceProvider) {
                fs.doFullParse();
                return fs;
            }
        }
        IParser parser = this.createParser();
        IParser scanner = this.createScanner();
        IParseState parseState = parser.createParseState(null);
        FileService fileService = new FileService(parser, parseState, sourceProvider, "text/javascript");
        fileService.setScanner(scanner);
        ParentOffsetMapper parentMapper = new ParentOffsetMapper(fileService);
        fileService.setErrorManager((IErrorManager)new JSErrorManager(fileService));
        JSFileLanguageService jsfls = new JSFileLanguageService(fileService, parseState, parser, (IParentOffsetMapper)parentMapper);
        fileService.addLanguageService("text/javascript", (IFileLanguageService)jsfls);
        IParser scriptDocParser = parser.getParserForMimeType("text/scriptdoc");
        ScriptDocFileLanguageService sdfls = new ScriptDocFileLanguageService(fileService, parseState, scriptDocParser, (IParentOffsetMapper)parentMapper);
        fileService.addLanguageService("text/scriptdoc", (IFileLanguageService)sdfls);
        IParser jsCommentParser = parser.getParserForMimeType("text/jscomment");
        JSCommentFileLanguageService cmfls = new JSCommentFileLanguageService(fileService, parseState, jsCommentParser, (IParentOffsetMapper)parentMapper);
        fileService.addLanguageService("text/jscomment", (IFileLanguageService)cmfls);
        ScriptDocParseState sdps = null;
        IParseState[] children = parseState.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IParseState state = children[i];
                if (state instanceof ScriptDocParseState) {
                    sdps = (ScriptDocParseState)state;
                    break;
                }
                ++i;
            }
        }
        if (sdps != null) {
            jsfls.setDocumentationStore(sdps.getDocumentationStore());
        }
        if (parse) {
            fileService.doFullParse();
        }
        return fileService;
    }

    protected IParser createParser() {
        IParser parser = LanguageRegistry.getParser((String)"text/javascript");
        if (parser == null) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)StringUtils.format((String)"Unable to create parser. Parser for MIME type {0} not registered in LanguageRegistry", (String)"text/javascript"));
        }
        return parser;
    }
}

