/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.context;

import com.aptana.ide.editor.js.context.JSContextItem;
import com.aptana.ide.editor.js.context.JSFieldContextItem;
import com.aptana.ide.editor.js.context.JSFunctionContextItem;
import com.aptana.ide.editor.js.context.JSFunctionInfo;
import com.aptana.ide.editor.js.context.JSLexemeUtils;
import com.aptana.ide.editor.js.context.JSPrototypeContextItem;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.context.ContextItem;
import com.aptana.ide.editors.unified.context.IContextAwareness;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.Hashtable;
import java.util.Stack;

public class JSContextAwareness
implements IContextAwareness {
    private ContextItem fileContext = new ContextItem("global");
    private static JSContextAwareness instance;

    public JSContextAwareness(IUnifiedEditor editor) {
    }

    public void update(IFileService context) {
        int functionDepth = 0;
        boolean inFunction = false;
        Hashtable<String, JSContextItem> funcsHash = new Hashtable<String, JSContextItem>();
        Stack<ContextItem> functionStack = new Stack<ContextItem>();
        ContextItem currentFunction = null;
        this.fileContext.clearAll();
        LexemeList lexemeList = context.getLexemeList();
        if (lexemeList == null) {
            return;
        }
        JSLexemeUtils utils = new JSLexemeUtils(lexemeList);
        int lexemeListSize = lexemeList.size();
        int lexc = 0;
        while (lexc < lexemeListSize) {
            Lexeme lexeme = lexemeList.get(lexc);
            if (!inFunction && lexeme.typeIndex == 30) {
                lexeme = utils.getNextIdentifier(lexc + 1);
                if (lexeme != null) {
                    JSContextItem contentElement;
                    String name;
                    String doc = null;
                    IFileLanguageService langService = context.getLanguageService(lexeme.getToken().getLanguage());
                    if (langService != null) {
                        doc = langService.getDocumentationFromLexeme(lexeme);
                    }
                    if (funcsHash.get(name = lexeme.getText()) != null) {
                        contentElement = (JSContextItem)((Object)funcsHash.get(name));
                        contentElement.setName(lexeme.getText());
                        contentElement.setOffset(lexeme.offset);
                        contentElement.length = lexeme.length;
                        contentElement.doc = doc;
                    } else {
                        contentElement = new JSFieldContextItem(lexeme.getText());
                        contentElement.doc = doc;
                        contentElement.setOffset(lexeme.offset);
                        contentElement.length = lexeme.length;
                        funcsHash.put(name, contentElement);
                        if (currentFunction == null) {
                            this.fileContext.addItem((ContextItem)contentElement);
                        } else {
                            currentFunction.addItem((ContextItem)contentElement);
                        }
                    }
                }
            } else if (lexeme.typeIndex == 22) {
                inFunction = true;
                JSFunctionInfo fi = utils.getFunctionInfo(lexc);
                if (fi != null) {
                    LexemeList ll;
                    IFileLanguageService langService;
                    String doc = null;
                    if (fi.nameOffset != -1 && (langService = context.getLanguageService(lexeme.getToken().getLanguage())) != null && (ll = langService.getFileContext().getLexemeList()) != null) {
                        Lexeme l = ll.getLexemeFromOffset(fi.nameOffset);
                        doc = langService.getDocumentationFromLexeme(l);
                    }
                    JSFunctionContextItem contentElement = new JSFunctionContextItem(fi.name);
                    contentElement.values.put("params", fi.params);
                    contentElement.offset = fi.offset;
                    contentElement.length = fi.length;
                    contentElement.doc = doc;
                    currentFunction = contentElement;
                    if (fi.name.indexOf(".") == -1) {
                        contentElement.setName(fi.name);
                        if (funcsHash.get(fi.name) != null) {
                            ContextItem ce = (ContextItem)funcsHash.get(fi.name);
                            ce.setOffset(contentElement.getOffset());
                        } else {
                            funcsHash.put(fi.name, contentElement);
                            this.fileContext.addItem((ContextItem)contentElement);
                        }
                    } else {
                        String[] parts = fi.name.split("\\.");
                        String funcPrefix = "";
                        ContextItem parentItem = null;
                        int i = 0;
                        while (i < parts.length - 1) {
                            if (funcsHash.get(funcPrefix = String.valueOf(funcPrefix) + parts[i]) == null) {
                                JSContextItem c = null;
                                c = parts[i].equals("prototype") ? new JSPrototypeContextItem("prototype") : new JSFieldContextItem();
                                if (i == 0) {
                                    this.fileContext.addItem((ContextItem)c);
                                }
                                c.setName(parts[i]);
                                c.setOffset(contentElement.getOffset());
                                funcsHash.put(funcPrefix, c);
                                if (parentItem != null) {
                                    parentItem.addItem((ContextItem)c);
                                }
                                parentItem = c;
                            } else {
                                parentItem = (ContextItem)funcsHash.get(funcPrefix);
                            }
                            funcPrefix = String.valueOf(funcPrefix) + ".";
                            ++i;
                        }
                        if (funcPrefix.endsWith(".")) {
                            funcPrefix = funcPrefix.substring(0, funcPrefix.length() - 1);
                        }
                        String baseName = parts[parts.length - 1];
                        contentElement.setName(baseName);
                        funcsHash.put(String.valueOf(funcPrefix) + "." + baseName, contentElement);
                        ContextItem jsfc = (ContextItem)funcsHash.get(funcPrefix);
                        jsfc.addItem((ContextItem)contentElement);
                    }
                }
            } else if (inFunction && lexeme.typeIndex == 34) {
                ++functionDepth;
                functionStack.push(currentFunction);
            } else if (inFunction && lexeme.typeIndex == 42) {
                --functionDepth;
                if (functionStack.size() > 0) {
                    currentFunction = (ContextItem)functionStack.pop();
                }
                if (functionDepth == 0) {
                    inFunction = false;
                    currentFunction = null;
                } else if (functionStack.size() > 0) {
                    currentFunction = (ContextItem)functionStack.peek();
                }
            }
            ++lexc;
        }
    }

    public ContextItem getFileContext() {
        return this.fileContext;
    }

    public static JSContextAwareness getInstance(IUnifiedEditor editor) {
        if (instance == null) {
            instance = new JSContextAwareness(editor);
        }
        return instance;
    }
}

