/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.context;

import com.aptana.ide.editor.js.context.JSFunctionInfo;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;

public class JSLexemeUtils {
    private LexemeList lexemeList;
    private Lexeme currentLexeme;
    private int currentLexemeIndex;

    public JSLexemeUtils(LexemeList lexemeList) {
        this.lexemeList = lexemeList;
    }

    public LexemeList getLexemeList() {
        return this.lexemeList;
    }

    public Lexeme getCurrentLexeme() {
        return this.currentLexeme;
    }

    public int getCurrentLexemeIndex() {
        return this.currentLexemeIndex;
    }

    public int getLexemeIndexFromDocumentOffset(int offset) {
        if (offset < 0 || this.lexemeList.size() == 0) {
            return -1;
        }
        int index = this.lexemeList.getLexemeIndex(offset - 1);
        if (index < 1) {
            index = index < -1 ? -index - 2 : 0;
        }
        return index;
    }

    public int getLexemeFloorIndex(int offset) {
        return this.lexemeList.getLexemeFloorIndex(offset);
    }

    public int getLexemeCeilingIndex(int offset) {
        return this.lexemeList.getLexemeCeilingIndex(offset);
    }

    public Lexeme getLexemeFromDocumentOffset(int offset) {
        int index = this.getLexemeIndexFromDocumentOffset(offset);
        if (index > -1) {
            return this.lexemeList.get(index);
        }
        return null;
    }

    public void calculateCurrentLexeme(int offset) {
        this.currentLexemeIndex = this.getLexemeIndexFromDocumentOffset(offset);
        this.currentLexeme = this.currentLexemeIndex > -1 ? this.lexemeList.get(this.currentLexemeIndex) : null;
    }

    public Lexeme getNextIdentifier(int index) {
        int i = index;
        while (i < this.lexemeList.size()) {
            Lexeme lexeme = this.lexemeList.get(i);
            if (lexeme.typeIndex != 1 && lexeme.typeIndex != 8) {
                return null;
            }
            if (lexeme.typeIndex == 8) {
                return lexeme;
            }
            ++i;
        }
        return null;
    }

    public Lexeme getPreviousIdentifier(int index) {
        int i = index;
        while (i >= 0) {
            Lexeme lexeme = this.lexemeList.get(i);
            if (lexeme.typeIndex != 1 && lexeme.typeIndex != 8) {
                return null;
            }
            if (lexeme.typeIndex == 8) {
                return lexeme;
            }
            --i;
        }
        return null;
    }

    public String getNextTypeIdentifier(int startIndex) {
        String name = "";
        int index = startIndex;
        int size = this.lexemeList.size();
        Lexeme lexeme = this.lexemeList.get(index);
        while (index < size && (lexeme.typeIndex == 8 || lexeme.typeIndex == 35)) {
            name = String.valueOf(name) + lexeme.getText();
            if (++index >= size) continue;
            lexeme = this.lexemeList.get(index);
        }
        return name.equals("") ? null : name;
    }

    public String getTypeAfterEqualNew(int index) {
        int equalsIndex = this.findNextTokenType(index, 40);
        if (equalsIndex == -1) {
            return null;
        }
        int newIndex = this.findNextTokenType(equalsIndex + 1, 23);
        if (newIndex == -1) {
            return null;
        }
        int identifierIndex = this.findNextTokenType(equalsIndex + 1, 8);
        if (identifierIndex == -1) {
            return null;
        }
        return this.getNextTypeIdentifier(identifierIndex);
    }

    public int getIndexAfterTypeIdentifier(int index) {
        int equalsIndex;
        if ((equalsIndex = this.findNextTokenType(++index, 40)) == -1) {
            return -1;
        }
        int identifierIndex = this.findNextTokenType(equalsIndex + 1, 8);
        return identifierIndex;
    }

    public int findNextTokenType(int startIndex, int typeIndex) {
        int index = startIndex;
        int size = this.lexemeList.size();
        if (index >= size) {
            return -1;
        }
        Lexeme lexeme = this.lexemeList.get(index);
        while (index < size || lexeme.getCategoryIndex() == 1) {
            if (lexeme.typeIndex == typeIndex) {
                return index;
            }
            if (++index >= size) break;
            lexeme = this.lexemeList.get(index);
        }
        return -1;
    }

    public int isNextTokenType(int startIndex, int typeIndex) {
        int index = startIndex;
        int size = this.lexemeList.size();
        if (index >= size || index < 0) {
            return -1;
        }
        Lexeme lexeme = this.lexemeList.get(index);
        while (index < size && lexeme.getCategoryIndex() == 1) {
            if (++index >= size) break;
            lexeme = this.lexemeList.get(index);
        }
        if (lexeme.typeIndex == typeIndex) {
            return lexeme.offset;
        }
        return -1;
    }

    public int isPrevTokenType(int startIndex, int typeIndex) {
        int index = startIndex;
        int size = this.lexemeList.size();
        if (index >= size || index < 0) {
            return -1;
        }
        Lexeme lexeme = this.lexemeList.get(index);
        while (index <= 0 && lexeme.getCategoryIndex() == 1) {
            if (--index < 0) break;
            lexeme = this.lexemeList.get(index);
        }
        if (lexeme.typeIndex == typeIndex) {
            return lexeme.offset;
        }
        return -1;
    }

    public JSFunctionInfo getFunctionInfo(int currentIndex) {
        return this.getFunctionInfo(currentIndex, false);
    }

    private JSFunctionInfo getFunctionInfo(int currentIndex, boolean recurse) {
        int i = currentIndex;
        while (i < this.lexemeList.size()) {
            String params;
            Lexeme lexeme = this.lexemeList.get(i);
            if (lexeme.typeIndex == 8) {
                params = this.findParameters(i);
                String parent = null;
                if (!recurse) {
                    parent = this.findParentFunction(i);
                }
                parent = parent == null ? "" : String.valueOf(parent) + ".";
                JSFunctionInfo fi = new JSFunctionInfo(String.valueOf(parent) + lexeme.getText(), lexeme.offset, params);
                fi.nameOffset = lexeme.offset;
                return fi;
            }
            if (lexeme.typeIndex == 50) {
                params = this.findParameters(i - 1);
                int listIdx = currentIndex - 1;
                while (listIdx > 0) {
                    Lexeme lx1 = this.lexemeList.get(listIdx);
                    if (lx1.typeIndex == 40) {
                        JSFunctionInfo fi;
                        String parent = null;
                        if (!recurse) {
                            parent = this.findParentFunction(listIdx);
                        }
                        if ((fi = this.findIdentifierBeforeEqual(listIdx)) != null) {
                            if (parent != null) {
                                fi.name = String.valueOf(parent) + "." + fi.name;
                            }
                            fi.params = params;
                            return fi;
                        }
                        return null;
                    }
                    if (lx1.typeIndex == 78) {
                        while (listIdx > 0) {
                            Lexeme lx2 = this.lexemeList.get(listIdx);
                            if (lx2.typeIndex == 88 || lx2.typeIndex == 8) {
                                String name = lx2.getText();
                                if (lx2.typeIndex == 88) {
                                    name = name.substring(1, name.length() - 1);
                                }
                                String parentName = null;
                                if (!recurse) {
                                    parentName = this.findParentFunction(listIdx, 1);
                                }
                                if (parentName != null) {
                                    JSFunctionInfo fi = new JSFunctionInfo(String.valueOf(parentName) + "." + name, lx2.offset, params);
                                    fi.nameOffset = lx2.offset;
                                    return fi;
                                }
                                JSFunctionInfo fi = new JSFunctionInfo(name, lx2.offset, params);
                                fi.nameOffset = lx2.offset;
                                return fi;
                            }
                            --listIdx;
                        }
                    }
                    --listIdx;
                }
            }
            ++i;
        }
        return null;
    }

    public int findDocOffset(int currentIndex) {
        if (currentIndex > 0) {
            Lexeme lx = this.lexemeList.get(--currentIndex);
            if (lx.typeIndex == 91) {
                return lx.offset;
            }
        }
        return -1;
    }

    private String findParameters(int index) {
        String params = "";
        boolean found = false;
        int i = index;
        while (i < this.lexemeList.size()) {
            Lexeme lexeme = this.lexemeList.get(i);
            if (lexeme.typeIndex == 50) {
                while (lexeme.typeIndex != 58 && i < this.lexemeList.size()) {
                    lexeme = this.lexemeList.get(i++);
                    params = String.valueOf(params) + lexeme.getText().trim();
                    found = true;
                }
                if (found) break;
            }
            ++i;
        }
        if (!found || params.trim().length() == 0) {
            return "()";
        }
        return params;
    }

    private String findParentFunction(int currentIndex) {
        return this.findParentFunction(currentIndex, 0);
    }

    private String findParentFunction(int currentIndex, int startDepth) {
        int level = startDepth;
        while (currentIndex > 0) {
            Lexeme lx;
            if (!(lx = this.lexemeList.get(--currentIndex)).getLanguage().equals("text/javascript")) continue;
            if (lx.typeIndex == 42) {
                ++level;
            } else if (lx.typeIndex == 34) {
                --level;
            }
            if (level >= startDepth) continue;
            while (currentIndex > 0) {
                Lexeme lx1 = this.lexemeList.get(currentIndex);
                if (lx.getLanguage().equals("text/javascript")) {
                    if (lx1.typeIndex == 40) {
                        String id = this.findIdentifierBeforeEqual((int)currentIndex).name;
                        String parent = this.findParentFunction(currentIndex);
                        if (parent != null) {
                            return String.valueOf(parent) + "." + id;
                        }
                        return id;
                    }
                    if (lx1.typeIndex == 22) {
                        String name = this.getFunctionInfo((int)currentIndex, (boolean)true).name;
                        String parent = this.findParentFunction(currentIndex);
                        if (parent != null) {
                            return String.valueOf(parent) + "." + name;
                        }
                        return name;
                    }
                }
                --currentIndex;
            }
        }
        return null;
    }

    public JSFunctionInfo findIdentifierBeforeEqual(int currentIndex) {
        while (currentIndex >= 0) {
            Lexeme lx2 = this.lexemeList.get(currentIndex--);
            if (lx2.typeIndex != 8) continue;
            String name = "";
            int offset = -1;
            while (lx2.typeIndex == 8 || lx2.typeIndex == 35 || lx2.typeIndex == 26) {
                name = lx2.typeIndex == 26 ? name.substring(1) : String.valueOf(lx2.getText()) + name;
                offset = lx2.offset;
                int index = currentIndex--;
                if (lx2.isAfterEOL() || index < 0) break;
                lx2 = this.lexemeList.get(index);
            }
            JSFunctionInfo fi = new JSFunctionInfo(name, offset);
            fi.nameOffset = offset;
            return fi;
        }
        return null;
    }
}

