/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.parsing.nodes;

import com.aptana.ide.editors.actions.ICanBeNotNavigatable;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.nodes.ParseNodeBase;

public class JSParseNode
extends ParseNodeBase
implements ICanBeNotNavigatable {
    private boolean _includesSemicolon;

    public JSParseNode(int typeIndex, Lexeme startLexeme) {
        super(typeIndex, "text/javascript", startLexeme);
    }

    public boolean getIncludesSemicolon() {
        return this._includesSemicolon;
    }

    public String getName() {
        switch (this.getTypeIndex()) {
            case 1: {
                return "assignment";
            }
            case 2: {
                return "add-and-assign";
            }
            case 3: {
                return "arithmetic-shift-right-and-assign";
            }
            case 4: {
                return "bitwise-and-and-assign";
            }
            case 5: {
                return "bitwise-or-and-assign";
            }
            case 6: {
                return "bitwise-xor-and-assign";
            }
            case 7: {
                return "divide-and-assign";
            }
            case 8: {
                return "mod-and-assign";
            }
            case 9: {
                return "multiply-and-assign";
            }
            case 10: {
                return "shift-left-and-assign";
            }
            case 11: {
                return "shift-right-and-assign";
            }
            case 12: {
                return "subtract-and-assign";
            }
            case 13: {
                return "get-element";
            }
            case 14: {
                return "get-property";
            }
            case 15: {
                return "equals";
            }
            case 16: {
                return "greater-than";
            }
            case 17: {
                return "greater-than-or-equal";
            }
            case 18: {
                return "identity";
            }
            case 19: {
                return "in";
            }
            case 20: {
                return "instanceof";
            }
            case 21: {
                return "less-than";
            }
            case 22: {
                return "less-than-or-equal";
            }
            case 23: {
                return "logical-and";
            }
            case 24: {
                return "logical-or";
            }
            case 25: {
                return "not-equal";
            }
            case 26: {
                return "not-identity";
            }
            case 27: {
                return "add";
            }
            case 28: {
                return "arithmetic-shift-right";
            }
            case 29: {
                return "bitwise-and";
            }
            case 30: {
                return "bitwise-or";
            }
            case 31: {
                return "bitwise-xor";
            }
            case 32: {
                return "divide";
            }
            case 33: {
                return "mod";
            }
            case 34: {
                return "multiply";
            }
            case 35: {
                return "shift-left";
            }
            case 36: {
                return "shift-right";
            }
            case 37: {
                return "subtract";
            }
            case 38: {
                return "catch";
            }
            case 39: {
                return "conditional";
            }
            case 40: {
                return "new";
            }
            case 41: {
                return "declaration";
            }
            case 42: {
                return "do";
            }
            case 43: {
                return "empty";
            }
            case 44: {
                return "finally";
            }
            case 45: {
                return "for-in";
            }
            case 46: {
                return "for";
            }
            case 47: {
                return "function";
            }
            case 48: {
                return "if";
            }
            case 49: {
                return "invoke";
            }
            case 50: {
                return "labelled";
            }
            case 51: {
                return "break";
            }
            case 52: {
                return "continue";
            }
            case 53: {
                return "arguments";
            }
            case 54: {
                return "array-literal";
            }
            case 55: {
                return "comma";
            }
            case 56: {
                return "default";
            }
            case 57: {
                return "case";
            }
            case 58: {
                return "switch";
            }
            case 59: {
                return "object-literal";
            }
            case 60: {
                return "parameters";
            }
            case 61: {
                return "statements";
            }
            case 62: {
                return "var";
            }
            case 63: {
                return "false";
            }
            case 64: {
                return "identifier";
            }
            case 65: {
                return "null";
            }
            case 66: {
                return "number";
            }
            case 67: {
                return "regexp";
            }
            case 68: {
                return "string";
            }
            case 69: {
                return "true";
            }
            case 70: {
                return "name-value-pair";
            }
            case 71: {
                return "this";
            }
            case 72: {
                return "try";
            }
            case 73: {
                return "delete";
            }
            case 74: {
                return "group";
            }
            case 75: {
                return "logical-not";
            }
            case 76: {
                return "bitwise-not";
            }
            case 77: {
                return "negate";
            }
            case 78: {
                return "positive";
            }
            case 79: {
                return "post-decrement";
            }
            case 80: {
                return "post-increment";
            }
            case 81: {
                return "pre-decrement";
            }
            case 82: {
                return "pre-increment";
            }
            case 83: {
                return "return";
            }
            case 84: {
                return "throw";
            }
            case 85: {
                return "typeof";
            }
            case 86: {
                return "void";
            }
            case 87: {
                return "while";
            }
            case 88: {
                return "with";
            }
        }
        return super.getName();
    }

    public void getSource(SourceWriter writer) {
        switch (this.getTypeIndex()) {
            case 1: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(" = ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 38: {
                writer.print("catch (");
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(") ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 39: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(" ? ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                writer.print(" : ");
                ((JSParseNode)this.getChild(2)).getSource(writer);
                break;
            }
            case 40: {
                writer.print("new ");
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print("(");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                writer.print(")");
                break;
            }
            case 41: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                if (this.getChildCount() <= 1 || this.getChild(1).getTypeIndex() == 43) break;
                writer.print(" = ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 42: {
                JSParseNode doBody = (JSParseNode)this.getChild(0);
                writer.print("do ");
                doBody.getSource(writer);
                if (doBody.getTypeIndex() != 61) {
                    writer.print(";");
                }
                writer.print(" while (");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                writer.print(")");
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                writer.print("finally ");
                ((JSParseNode)this.getChild(0)).getSource(writer);
                break;
            }
            case 45: {
                JSParseNode initializer = (JSParseNode)this.getChild(0);
                JSParseNode object = (JSParseNode)this.getChild(1);
                JSParseNode body = (JSParseNode)this.getChild(2);
                writer.print("for (");
                initializer.getSource(writer);
                writer.print(" in ");
                object.getSource(writer);
                writer.print(") ");
                body.getSource(writer);
                break;
            }
            case 46: {
                JSParseNode initializer = (JSParseNode)this.getChild(0);
                JSParseNode condition = (JSParseNode)this.getChild(1);
                JSParseNode advance = (JSParseNode)this.getChild(2);
                JSParseNode body = (JSParseNode)this.getChild(3);
                writer.print("for (");
                if (!initializer.isEmpty()) {
                    initializer.getSource(writer);
                }
                writer.print(";");
                if (!condition.isEmpty()) {
                    writer.print(" ");
                    condition.getSource(writer);
                }
                writer.print(";");
                if (!advance.isEmpty()) {
                    writer.print(" ");
                    advance.getSource(writer);
                }
                writer.print(") ");
                body.getSource(writer);
                break;
            }
            case 47: {
                JSParseNode parameters = (JSParseNode)this.getChild(0);
                JSParseNode body = (JSParseNode)this.getChild(1);
                writer.print("function");
                if (this.hasAttribute("name")) {
                    writer.print(" ");
                    writer.print(this.getAttribute("name"));
                    writer.print(" ");
                }
                writer.print("(");
                if (!parameters.isEmpty()) {
                    parameters.getSource(writer);
                }
                writer.print(") ");
                body.getSource(writer);
                break;
            }
            case 48: {
                JSParseNode condition = (JSParseNode)this.getChild(0);
                JSParseNode trueCase = (JSParseNode)this.getChild(1);
                JSParseNode falseCase = (JSParseNode)this.getChild(2);
                writer.print("if (");
                condition.getSource(writer);
                writer.print(") ");
                trueCase.getSource(writer);
                if (falseCase.isEmpty()) break;
                if (trueCase.getTypeIndex() != 61) {
                    writer.print(";");
                }
                writer.print(" else ");
                falseCase.getSource(writer);
                break;
            }
            case 49: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print("(");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                writer.print(")");
                break;
            }
            case 50: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(": ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 70: {
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(": ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 71: {
                writer.print("this");
                break;
            }
            case 72: {
                JSParseNode body = (JSParseNode)this.getChild(0);
                JSParseNode catchNode = (JSParseNode)this.getChild(1);
                JSParseNode finallyNode = (JSParseNode)this.getChild(2);
                writer.print("try ");
                body.getSource(writer);
                if (!catchNode.isEmpty()) {
                    writer.print(" ");
                    catchNode.getSource(writer);
                }
                if (finallyNode.isEmpty()) break;
                writer.print(" ");
                finallyNode.getSource(writer);
                break;
            }
            case 87: {
                writer.print("while (");
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(") ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case 88: {
                writer.print("with (");
                ((JSParseNode)this.getChild(0)).getSource(writer);
                writer.print(") ");
                ((JSParseNode)this.getChild(1)).getSource(writer);
                break;
            }
            case -1: {
                writer.print("ERROR");
                break;
            }
        }
    }

    public boolean isEmpty() {
        return this.getTypeIndex() == 43;
    }

    public void setIncludesSemicolon(boolean value) {
        this._includesSemicolon = value;
    }

    public boolean isNavigatable() {
        return false;
    }
}

