/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.js.runtime;

import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import java.util.Hashtable;
import java.util.Set;

public class JSScope
extends ObjectBase
implements IScope {
    private IFunction enclosingFunction;
    protected IScope _parentScope;

    public String getClassName() {
        return "Scope";
    }

    public String[] getLocalVariableNames() {
        return this.getLocalPropertyNames();
    }

    public IScope getParentScope() {
        return this._parentScope;
    }

    public void setParentScope(IScope parentScope) {
        this._parentScope = parentScope;
    }

    public IScope getOwningScope(String variableName) {
        IScope current = this;
        JSScope result = null;
        while (current != null) {
            if (current.hasLocalProperty(variableName)) {
                result = current;
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    public boolean hasVariable(String variableName) {
        Property property = this.getVariable(variableName);
        return property != null;
    }

    public IObject getVariableValue(String variableName, int fileIndex, int offset) {
        Property property = this.getVariable(variableName);
        return property != null ? property.getValue(fileIndex, offset) : ObjectBase.UNDEFINED;
    }

    public Property getVariable(String variableName) {
        IScope current = this;
        Property result = null;
        while (current != null) {
            if (current.hasLocalProperty(variableName)) {
                result = current.getLocalProperty(variableName);
                break;
            }
            current = current.getParentScope();
        }
        return result;
    }

    public Reference getVariableReference(String variableName) {
        return new Reference(this.getOwningScope(variableName), variableName);
    }

    public String[] getVariableNames() {
        IScope current = this;
        Hashtable<String, String> result = new Hashtable<String, String>();
        while (current != null) {
            String[] localNames = current.getLocalPropertyNames();
            int i = 0;
            while (i < localNames.length) {
                result.put(localNames[i], "");
                ++i;
            }
            current = current.getParentScope();
        }
        Set s = result.keySet();
        return s.toArray(new String[s.size()]);
    }

    public void putVariableValue(String variableName, IObject value, int fileIndex) {
        Property property = this.getVariable(variableName);
        if (property != null) {
            if (!property.isReadOnly()) {
                property.setValue(value, fileIndex);
            }
        } else {
            this.putPropertyValue(variableName, value, fileIndex);
        }
    }

    public void unputVariableName(String variableName) {
        IScope current = this;
        while (current != null) {
            if (current.hasLocalProperty(variableName)) {
                Property p = current.getLocalProperty(variableName);
                if (p.removeReference() != 0) break;
                current.deletePropertyName(variableName);
                break;
            }
            current = current.getParentScope();
        }
    }

    public IFunction getEnclosingFunction() {
        return this.enclosingFunction;
    }

    public void setEnclosingFunction(IFunction enclosingFunction) {
        this.enclosingFunction = enclosingFunction;
    }
}

