/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.jscomment.parsing;

import com.aptana.ide.editor.jscomment.parsing.JSCommentParserBase;
import com.aptana.ide.editor.jscomment.parsing.Messages;
import com.aptana.ide.editors.unified.folding.GenericCommentNode;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.parsing.ParserInitializationException;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.text.ParseException;

public class JSCommentParser
extends JSCommentParserBase {
    public static final String DEFAULT_GROUP = "default";
    public static final String ERROR_GROUP = "error";
    public static final String MULTI_LINE_GROUP = "multiline";
    public static final String SINGLE_LINE_GROUP = "singleline";

    public JSCommentParser() throws ParserInitializationException {
        this("text/jscomment");
    }

    public JSCommentParser(String mimeType) throws ParserInitializationException {
        super(mimeType);
    }

    private String getFollowText() {
        ILexer lexer = this.getLexer();
        if (lexer.getSourceLength() > lexer.getCurrentOffset()) {
            int len = Math.min(6, lexer.getSourceLength() - lexer.getCurrentOffset());
            return "\"" + lexer.getSource().substring(lexer.getCurrentOffset(), lexer.getCurrentOffset() + len) + "\"";
        }
        return "end of document";
    }

    public void parseAll(IParseNode parentNode) throws LexerException {
        ILexer lexer = this.getLexer();
        lexer.setLanguageAndGroup(this.getLanguage(), DEFAULT_GROUP);
        this.parseComment();
    }

    private void parseComment() throws LexerException {
        this.advance();
        int startingIndex = -1;
        int endingIndex = -1;
        if (this.currentLexeme != EOS) {
            if (this.currentLexeme.typeIndex == 1) {
                startingIndex = this.currentLexeme.getStartingOffset();
                try {
                    this.getLexer().setGroup(MULTI_LINE_GROUP);
                }
                catch (LexerException lexerException) {}
            } else if (this.currentLexeme.typeIndex == 2) {
                startingIndex = this.currentLexeme.getStartingOffset();
                try {
                    this.getLexer().setGroup(SINGLE_LINE_GROUP);
                }
                catch (LexerException lexerException) {}
            }
            while (this.currentLexeme != EOS) {
                endingIndex = this.currentLexeme.getEndingOffset();
                this.advance();
            }
        }
        if (endingIndex != -1 && startingIndex != -1) {
            GenericCommentNode node = new GenericCommentNode(startingIndex, endingIndex, "JSCOMMENT", "text/javascript");
            this.getParseState().addCommentRegion((IParseNode)node);
        }
    }

    protected void throwParseError(String message) throws ParseException {
        int lastValid;
        LexemeList lexemes = this.getLexemeList();
        int n = lastValid = this.currentLexeme == EOS ? lexemes.size() - 2 : lexemes.size() - 1;
        if (lastValid < 0) {
            message = Messages.JSCommentParser_PrematureTagEnd;
        } else {
            String position = "";
            position = this.currentLexeme != EOS ? " [" + this.currentLexeme.getText() + "]" : " [" + this.getFollowText() + "]";
            message = String.valueOf(Messages.JSCommentParser_ParseError) + position + ": " + message;
        }
        throw new ParseException(message, -1);
    }
}

