/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.js.JSOffsetMapper;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.IScope;
import com.aptana.ide.editor.js.runtime.JSFunction;
import com.aptana.ide.editor.scriptdoc.Messages;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editors.unified.UnifiedConfiguration;
import com.aptana.ide.editors.unified.utils.LineBreakingReader;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.metadata.UserAgent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public final class ScriptDocHelper {
    public static final String DEFAULT_DELIMITER = String.valueOf(System.getProperty("line.separator", "\r\n")) + "\u2022\t";

    private ScriptDocHelper() {
    }

    public static String createMethodDocumentationHTML(String identifier, FunctionDocumentation fDoc, IObject obj) {
        return ScriptDocHelper.createMethodDocumentationHTML(identifier, fDoc, obj, true, false);
    }

    public static String createMethodDocumentationHTML(String identifier, FunctionDocumentation fDoc, IObject obj, boolean addReturnTypes, boolean extended) {
        UserAgent[] agents;
        StringBuffer sb = new StringBuffer();
        TypedDescription[] pDocs = fDoc.getParams();
        if (pDocs.length == 0) {
            sb.append(ScriptDocHelper.createMethodSignatureString(identifier, fDoc, obj, true, addReturnTypes));
            if (fDoc.getDescription().trim() != "") {
                sb.append("<br><br>" + fDoc.getDescription());
            }
        } else {
            sb.append(ScriptDocHelper.createMethodSignatureString(identifier, fDoc, obj, true, addReturnTypes));
            sb.append("<br><br>" + fDoc.getDescription());
        }
        if ((agents = fDoc.getUserAgents()).length > 0) {
            sb.append(Messages.ScriptDocHelper_Supported1);
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                sb.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        if (extended) {
            String[] examples = fDoc.getExamples();
            if (examples.length > 0) {
                int i = 0;
                while (i < examples.length) {
                    String example = examples[i];
                    if (!example.startsWith("<b>Example:")) {
                        example = "<b>Example:</b><br>" + example;
                    }
                    sb.append("<br><br>" + example);
                    ++i;
                }
            }
            if (fDoc.getRemarks().trim() != "") {
                sb.append("<br><br>" + fDoc.getRemarks());
            }
            if (fDoc.getAliases() != null && fDoc.getAliases().getTypes().length > 0) {
                sb.append("<br><br><b>Also known as:</b> " + StringUtils.join((String)", ", (String[])fDoc.getAliases().getTypes()));
            }
        }
        return sb.toString();
    }

    public static String createMethodSignatureString(String identifier, FunctionDocumentation mDoc, IObject obj, boolean asHTML) {
        return ScriptDocHelper.createMethodSignatureString(identifier, mDoc, obj, asHTML, true);
    }

    public static String createMethodSignatureString(String identifier, FunctionDocumentation mDoc, IObject obj, boolean asHTML, boolean addReturnTypes) {
        int docLen;
        int objLen;
        int maxLen;
        StringBuffer methodSignature = new StringBuffer();
        methodSignature.append("<b>" + identifier + "</b>");
        TypedDescription[] pDocs = mDoc.getParams();
        String[] objParams = null;
        if (obj != null && obj instanceof JSFunction) {
            objParams = ((JSFunction)obj).getParameterNames();
        }
        if ((maxLen = Math.max(objLen = objParams == null ? 0 : objParams.length, docLen = pDocs == null ? 0 : pDocs.length)) > 0) {
            methodSignature.append("(");
        }
        int k = 0;
        while (k < maxLen) {
            String docName = k < docLen ? pDocs[k].getName() : "";
            String docCmpr = docName.replaceAll("\\[(.*)\\]", "$1");
            String objName = k < objLen ? objParams[k] : "";
            String name = objName.equals("") ? docName : objName;
            name = docCmpr.equals(name) ? docName : name;
            String types = "";
            if (k < docLen) {
                types = StringUtils.join((String)"|", (String[])pDocs[k].getTypes());
            }
            if (!types.equals("")) {
                methodSignature.append("<b>" + name + "</b>: " + types);
            } else {
                methodSignature.append("<b>" + name + "</b>: Object");
            }
            if (k < maxLen - 1) {
                methodSignature.append(", ");
            }
            ++k;
        }
        if (maxLen > 0) {
            methodSignature.append(")");
        }
        if (addReturnTypes) {
            if (mDoc.getReturn().getTypes().length > 0) {
                methodSignature.append(" : " + StringUtils.join((String)", ", (String[])mDoc.getReturn().getTypes()));
            } else {
                methodSignature.append(Messages.ScriptDocHelper_None1);
            }
        }
        if (!asHTML) {
            return StringUtils.stripHTML((String)methodSignature.toString());
        }
        return methodSignature.toString();
    }

    public static String getInformationForLexeme(JSOffsetMapper offsetMapper, Lexeme lexeme, boolean extended) {
        return ScriptDocHelper.getInformationForLexemeSimple(offsetMapper, lexeme, extended);
    }

    private static String getInformationForLexemeSimple(JSOffsetMapper offsetMapper, Lexeme lexeme, boolean extended) {
        IScope scope;
        String result = "";
        if (lexeme.getCategoryIndex() == 3) {
            return String.valueOf(Messages.ScriptDocHelper_JSKeyword) + lexeme.getText() + "</b>. ";
        }
        if (lexeme.getCategoryIndex() == 5) {
            return String.valueOf(Messages.ScriptDocHelper_JSLiteral) + lexeme.getText() + "</b>. ";
        }
        if (lexeme.getCategoryIndex() != 2) {
            return result;
        }
        IDocumentation doc = null;
        int curIndex = offsetMapper.getLexemeIndexFromDocumentOffset(lexeme.offset + lexeme.length);
        String fullName = JSOffsetMapper.getIdentName(curIndex, offsetMapper.getLexemeList());
        IObject obj = offsetMapper.lookupReturnTypeFromNameHash(fullName, scope = offsetMapper.getScope(lexeme, offsetMapper.getGlobal()), true);
        if (obj != null) {
            doc = obj.getDocumentation();
            if (doc != null && doc instanceof FunctionDocumentation) {
                return ScriptDocHelper.createMethodDocumentationHTML(lexeme.getText(), (FunctionDocumentation)doc, obj, true, extended);
            }
            if (doc != null && doc instanceof PropertyDocumentation) {
                return ScriptDocHelper.createPropertyDocumentationHTML(lexeme.getText(), (PropertyDocumentation)doc, true, true, extended);
            }
            if (obj instanceof JSFunction) {
                doc = new FunctionDocumentation();
                doc.setName(fullName);
                return ScriptDocHelper.createMethodDocumentationHTML(lexeme.getText(), (FunctionDocumentation)doc, obj, true, extended);
            }
        }
        return result;
    }

    public static String createPropertyDocumentationHTML(String identifier, PropertyDocumentation pDoc, boolean asHTML) {
        return ScriptDocHelper.createPropertyDocumentationHTML(identifier, pDoc, asHTML, true, false);
    }

    public static String createPropertyDocumentationHTML(String identifier, PropertyDocumentation pDoc, boolean asHTML, boolean addReturnTypes, boolean extended) {
        StringBuffer propertySignature = new StringBuffer();
        propertySignature.append("<b>" + identifier + "</b>");
        if (addReturnTypes) {
            if (pDoc.getReturn().getTypes().length > 0) {
                propertySignature.append(" : " + StringUtils.join((String)", ", (String[])pDoc.getReturn().getTypes()));
            } else {
                propertySignature.append(Messages.ScriptDocHelper_None2);
            }
        }
        propertySignature.append("<br><br>" + pDoc.getDescription() + "<br>");
        UserAgent[] agents = pDoc.getUserAgents();
        if (agents.length > 0) {
            propertySignature.append(Messages.ScriptDocHelper_Supported2);
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                propertySignature.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    propertySignature.append(", ");
                }
                ++i;
            }
        }
        if (extended) {
            String[] examples = pDoc.getExamples();
            if (examples.length > 0) {
                int i = 0;
                while (i < examples.length) {
                    String example = examples[i];
                    if (!example.startsWith("<b>Example:")) {
                        example = "<b>Example:</b><br>" + example;
                    }
                    propertySignature.append("<br><br>" + example + "<br>");
                    ++i;
                }
            }
            if (pDoc.getRemarks().trim() != "") {
                propertySignature.append("<br><br>" + pDoc.getRemarks() + "<br>");
            }
        }
        String propString = propertySignature.toString();
        if (asHTML) {
            return propString;
        }
        return StringUtils.stripHTML((String)propString);
    }

    public static String createPropertyDocumentationHTMLSimple(String identifier, PropertyDocumentation pDoc, boolean asHTML) {
        StringBuffer propertySignature = new StringBuffer();
        propertySignature.append("<b>" + identifier + "</b>");
        if (pDoc.getReturn().getTypes().length > 0) {
            propertySignature.append(" : " + StringUtils.join((String)", ", (String[])pDoc.getReturn().getTypes()));
        }
        propertySignature.append("<br><br>" + pDoc.getDescription() + "<br>");
        UserAgent[] agents = pDoc.getUserAgents();
        if (agents.length > 0) {
            propertySignature.append(Messages.ScriptDocHelper_Supported3);
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                propertySignature.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    propertySignature.append(", ");
                }
                ++i;
            }
        }
        String propString = propertySignature.toString();
        if (asHTML) {
            return propString;
        }
        return StringUtils.stripHTML((String)propString);
    }

    public static String createGenericDocumentationHTML(String identifier, IDocumentation pDoc, boolean asHTML) {
        StringBuffer propertySignature = new StringBuffer();
        propertySignature.append("<b>" + identifier + "</b>");
        propertySignature.append(" : " + propertySignature.append(pDoc.getClass().getName()));
        String propString = propertySignature.toString();
        if (asHTML) {
            return propString;
        }
        return StringUtils.stripHTML((String)propString);
    }

    public static String createParameterDocumentationList(TypedDescription[] parameterDocs, IObject obj) {
        StringBuffer paramText = new StringBuffer();
        String[] parameterNames = null;
        if (obj != null && obj instanceof JSFunction) {
            parameterNames = ((JSFunction)obj).getParameterNames();
        }
        if (!ScriptDocHelper.containsNonEmptyDescription(parameterDocs)) {
            return null;
        }
        if (parameterNames != null) {
            int i = 0;
            while (i < parameterNames.length) {
                String parameterName = parameterNames[i];
                TypedDescription curResult = ScriptDocHelper.findMatchingParameterDocumentation(parameterName, parameterDocs);
                paramText.append(ScriptDocHelper.createParameterDocumentation(curResult));
                if (i < parameterDocs.length - 1) {
                    paramText.append(DEFAULT_DELIMITER);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < parameterDocs.length) {
                TypedDescription parameter = parameterDocs[i];
                paramText.append(ScriptDocHelper.createParameterDocumentation(parameter));
                if (i < parameterDocs.length - 1) {
                    paramText.append(DEFAULT_DELIMITER);
                }
                ++i;
            }
        }
        return ScriptDocHelper.wrapString(paramText.toString(), 420, UnifiedConfiguration.getNewlineString());
    }

    private static String createParameterDocumentation(TypedDescription parameterDoc) {
        String paramInfo = "";
        String name = "";
        if (parameterDoc != null) {
            paramInfo = ScriptDocHelper.wrapString(StringUtils.formatAsPlainText((String)parameterDoc.getDescription()), 370, String.valueOf(UnifiedConfiguration.getNewlineString()) + "\t");
            name = parameterDoc.getName();
        }
        return String.valueOf(name) + ":" + UnifiedConfiguration.getNewlineString() + "\t" + paramInfo;
    }

    private static TypedDescription findMatchingParameterDocumentation(String parameterName, TypedDescription[] parameterDocs) {
        TypedDescription curResult = null;
        int j = 0;
        while (j < parameterDocs.length) {
            TypedDescription param = parameterDocs[j];
            String name = StringUtils.trimBrackets((String)param.getName().toUpperCase());
            if (name.equals(parameterName.toUpperCase())) {
                curResult = param;
                break;
            }
            if (j == parameterDocs.length - 1 && name.equals("...")) {
                curResult = param;
                break;
            }
            ++j;
        }
        return curResult;
    }

    private static boolean containsNonEmptyDescription(TypedDescription[] params) {
        boolean foundDescription = false;
        int j = 0;
        while (j < params.length) {
            TypedDescription param = params[j];
            if (param.getDescription() != null && !"".equals(param.getDescription())) {
                foundDescription = true;
            }
            ++j;
        }
        return foundDescription;
    }

    private static String wrapString(String s, int maxWidth, String delimiter) {
        StringReader sr = new StringReader(s);
        GC gc = new GC((Drawable)Display.getCurrent());
        String result = "";
        LineBreakingReader r = new LineBreakingReader((Reader)sr, gc, maxWidth);
        try {
            String line = r.readLine();
            while (line != null) {
                result = String.valueOf(result) + line;
                line = r.readLine();
                if (line == null) continue;
                result = String.valueOf(result) + delimiter;
            }
        }
        catch (IOException iOException) {}
        gc.dispose();
        return result;
    }
}

