/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.io.SourceWriter;
import com.aptana.ide.metadata.IDocumentation;
import com.aptana.ide.parsing.CodeLocation;
import com.aptana.ide.parsing.ErrorMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentationBase
implements IDocumentation {
    private static final String SDOC_LINE_START = " * ";
    private String fAuthor = "";
    private String fName = "";
    private String fDescription = "";
    private String fVersion = "";
    private List<String> fSees;
    private List<String> fSDocLocations;
    private int fType = 0;
    private HashMap<String, ArrayList<CodeLocation>> fID;
    private transient List<ErrorMessage> fErrors;
    private List<String> fExamples;
    private String fRemarks = "";
    private String userAgent = "";

    public String getName() {
        return this.fName;
    }

    public void setName(String value) {
        this.fName = value == null ? "" : value;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String value) {
        this.fDescription = value == null ? "" : value;
    }

    public String getExample() {
        String[] examples = this.getExamples();
        return StringUtils.join((String)(String.valueOf(FileUtils.NEW_LINE) + FileUtils.NEW_LINE), (String[])examples);
    }

    public String[] getExamples() {
        if (this.fExamples != null) {
            return this.fExamples.toArray(new String[0]);
        }
        return new String[0];
    }

    public void addExample(String value) {
        if (this.fExamples == null) {
            this.fExamples = new ArrayList<String>();
        }
        this.fExamples.add(value);
    }

    public String getRemarks() {
        return this.fRemarks;
    }

    public void setRemarks(String value) {
        this.fRemarks = value == null ? "" : value;
    }

    public String getAuthor() {
        return this.fAuthor;
    }

    public void setAuthor(String value) {
        this.fAuthor = value == null ? "" : value;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String value) {
        this.fVersion = value == null ? "" : value;
    }

    public String[] getSees() {
        if (this.fSees == null) {
            return new String[0];
        }
        return this.fSees.toArray(new String[0]);
    }

    public void addSee(String value) {
        String string = value = value == null ? "" : value;
        if (this.fSees == null) {
            this.fSees = new ArrayList<String>();
        }
        this.fSees.add(value);
    }

    public ErrorMessage[] getErrors() {
        if (this.fErrors == null) {
            return new ErrorMessage[0];
        }
        return this.fErrors.toArray(new ErrorMessage[0]);
    }

    public void clearErrors() {
        this.fErrors.clear();
        this.fErrors = null;
    }

    public void addError(ErrorMessage e) {
        if (this.fErrors == null) {
            this.fErrors = new ArrayList<ErrorMessage>();
        }
        this.fErrors.add(e);
    }

    public int getDocumentType() {
        return this.fType;
    }

    public void setDocumentType(int type) {
        this.fType = type;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public CodeLocation[] getID(String id) {
        if (this.fID == null) {
            return null;
        }
        if (this.fID.containsKey(id)) {
            ArrayList<CodeLocation> al = this.fID.get(id);
            return al.toArray(new CodeLocation[0]);
        }
        return null;
    }

    public void setID(String id, CodeLocation location) {
        if (this.fID == null) {
            this.fID = new HashMap();
        }
        if (this.fID.containsKey(id)) {
            ArrayList<CodeLocation> al = this.fID.get(id);
            al.add(location);
        } else {
            ArrayList<CodeLocation> list = new ArrayList<CodeLocation>();
            list.add(location);
            this.fID.put(id, list);
        }
    }

    public String[] getIDs() {
        if (this.fID == null) {
            return new String[0];
        }
        return this.fID.keySet().toArray(new String[0]);
    }

    public void read(DataInput input) throws IOException {
        this.fAuthor = input.readUTF();
        this.fName = input.readUTF();
        this.fDescription = input.readUTF();
        this.addExample(input.readUTF());
        this.fRemarks = input.readUTF();
        this.fVersion = input.readUTF();
        int size = input.readInt();
        if (size > 0) {
            this.fSees = new ArrayList<String>();
            int i = 0;
            while (i < size) {
                this.fSees.add(input.readUTF());
                ++i;
            }
        }
    }

    public String toSource() {
        SourceWriter writer = new SourceWriter();
        writer.println("/**");
        this.printBody(writer);
        writer.println(" */");
        return writer.toString();
    }

    protected void printBody(SourceWriter writer) {
        this.printTag(writer, "@author", this.fAuthor);
        this.printTag(writer, "@name", this.fName);
        this.printTag(writer, "@description", this.fDescription);
        this.printTag(writer, "@version", this.fVersion);
        this.printTags(writer, "@see", this.fSees);
        this.printTags(writer, "@sdoc", this.fSDocLocations);
        this.printTags(writer, "@example", this.fExamples);
        this.printTag(writer, "@remarks", this.fRemarks);
        this.printTag(writer, "@userAgent", this.userAgent);
    }

    protected void printTag(SourceWriter writer, String tagName, Boolean flag) {
        if (flag.booleanValue()) {
            writer.print(SDOC_LINE_START).println(tagName);
        }
    }

    protected void printTag(SourceWriter writer, String tagName, String content) {
        if (content != null && content.length() > 0) {
            writer.print(SDOC_LINE_START).print(tagName).print(" ").println(content);
        }
    }

    protected void printTag(SourceWriter writer, String tagName, TypedDescription typeInfo) {
        if (typeInfo != null) {
            String name = typeInfo.getName();
            String description = typeInfo.getDescription();
            String[] types = typeInfo.getTypes();
            if (types != null && types.length > 0) {
                writer.print(SDOC_LINE_START).print(tagName).print(" {");
                if (types != null && types.length > 0) {
                    writer.print(types[0]);
                    int i = 1;
                    while (i < types.length) {
                        writer.print("|").print(types[i]);
                        ++i;
                    }
                }
                writer.print("}");
                if (name != null && name.length() > 0) {
                    writer.print(" ").print(name);
                }
                if (description != null && description.length() > 0) {
                    writer.println();
                    writer.print(SDOC_LINE_START).print("     ").print(description);
                }
                writer.println();
            }
        }
    }

    protected void printTags(SourceWriter writer, String tagName, List<String> values) {
        if (values != null) {
            for (String value : values) {
                this.printTag(writer, tagName, value);
            }
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.fAuthor);
        output.writeUTF(this.fName);
        output.writeUTF(this.fDescription);
        output.writeUTF(this.getExample());
        output.writeUTF(this.fRemarks);
        output.writeUTF(this.fVersion);
        if (this.fSees != null) {
            output.writeInt(this.fSees.size());
            int i = 0;
            while (i < this.fSees.size()) {
                output.writeUTF(this.fSees.get(i));
                ++i;
            }
        } else {
            output.writeInt(0);
        }
    }

    public void addSDocLocation(String value) {
        String string = value = value == null ? "" : value;
        if (this.fSDocLocations == null) {
            this.fSDocLocations = new ArrayList<String>();
        }
        this.fSDocLocations.add(value);
    }

    public String[] getSDocLocations() {
        if (this.fSDocLocations == null) {
            return new String[0];
        }
        return this.fSDocLocations.toArray(new String[0]);
    }
}

