/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing.reader;

import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSFunctionConstructor;
import com.aptana.ide.editor.js.runtime.JSObjectConstructor;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.JSUndefined;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.AliasEntry;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDoc;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editor.scriptdoc.parsing.reader.Messages;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocException;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocInitializationException;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocReader;
import com.aptana.ide.io.TabledInputStream;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.metadata.UserAgent;
import java.io.DataInput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.TextAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeObjectsReader {
    private static final int FILE_INDEX = Integer.MIN_VALUE;
    private static final int FILE_OFFSET = Range.Empty.getStartingOffset();
    private Environment _environment;
    private ScriptDoc _docs;
    private Map<String, TextAttribute> names = new HashMap<String, TextAttribute>();
    private String userAgent = "";

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public ScriptDoc getScriptDoc() {
        return this._docs;
    }

    public NativeObjectsReader(Environment env) {
        this._environment = env;
    }

    public void load(InputStream stream) throws IOException {
        this.load(stream, true);
    }

    public void load(InputStream stream, boolean autoCreate) throws IOException {
        this._docs = new ScriptDoc();
        TabledInputStream input = new TabledInputStream(stream);
        this._docs.read((DataInput)input);
        this.postProcess(autoCreate);
    }

    public void loadXML(String filename) throws ScriptDocInitializationException, ScriptDocException {
        this.loadXML(filename, true);
    }

    public void loadXML(String filename, boolean autoCreate) throws ScriptDocInitializationException, ScriptDocException {
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(filename);
                this.loadXML(istream, autoCreate);
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(Messages.NativeObjectsReader_UnalbeToLocateXMLFile) + filename;
                ScriptDocException de = new ScriptDocException(msg, e);
                throw de;
            }
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                String msg = Messages.NativeObjectsReader_IOError;
                ScriptDocException de = new ScriptDocException(msg, e);
                throw de;
            }
        }
    }

    public void loadXML(InputStream stream) throws ScriptDocInitializationException, ScriptDocException {
        this.loadXML(stream, true);
    }

    public void loadXML(InputStream stream, boolean autoCreate) throws ScriptDocInitializationException, ScriptDocException {
        ScriptDocReader reader = new ScriptDocReader();
        reader.loadXML(stream);
        this._docs = reader.getDocumentation();
        this.postProcess(autoCreate);
    }

    private Reference createNamespace(IObject root, String fullyQualifiedType) {
        String[] parts = fullyQualifiedType.split("\\.");
        IObject current = root;
        int i = 0;
        while (i < parts.length - 1) {
            String propertyName = parts[i];
            if (current.hasProperty(propertyName)) {
                current = current.getPropertyValue(propertyName, Integer.MIN_VALUE, FILE_OFFSET);
            } else {
                IObject instance = this._environment.createObject(Integer.MIN_VALUE, (IRange)Range.Empty);
                current.putPropertyValue(propertyName, instance, Integer.MIN_VALUE, 4);
                UserAgent ua = new UserAgent();
                ua.setDescription("");
                ua.setOs("");
                ua.setOsVersion("");
                ua.setPlatform(this.getUserAgent());
                ua.setVersion("");
                PropertyDocumentation documentation = new PropertyDocumentation();
                documentation.setName(propertyName);
                documentation.setUserAgent(this.getUserAgent());
                documentation.addUserAgent(ua);
                instance.setDocumentation(documentation);
                current = instance;
            }
            ++i;
        }
        String name = parts[parts.length - 1];
        return new Reference(current, name);
    }

    private void postProcess(boolean autoCreate) {
        this.names.clear();
        if (this._environment != null) {
            FunctionDocumentation[] functions = this._docs.getFunctions();
            int i = 0;
            while (i < functions.length) {
                FunctionDocumentation currentFunction = functions[i];
                currentFunction.setUserAgent(this.userAgent);
                this.processFunction(currentFunction, autoCreate);
                String name = currentFunction.getName();
                if (!this.names.containsKey(name)) {
                    this.names.put(name, null);
                }
                ++i;
            }
            PropertyDocumentation[] properties = this._docs.getProperties();
            int i2 = 0;
            while (i2 < properties.length) {
                PropertyDocumentation currentProperty = properties[i2];
                currentProperty.setUserAgent(this.userAgent);
                this.processProperty(currentProperty, autoCreate);
                String name = currentProperty.getName();
                if (!this.names.containsKey(name)) {
                    this.names.put(name, null);
                }
                ++i2;
            }
            this.processAliases();
        }
    }

    private void processAliases() {
        JSScope global = this._environment.getGlobal();
        AliasEntry[] aliasEntryArray = this._docs.getAliases();
        int n = 0;
        int n2 = aliasEntryArray.length;
        while (n < n2) {
            AliasEntry alias = aliasEntryArray[n];
            Reference aliasProperty = this.createNamespace(global, alias.name);
            Reference aliasedProperty = this.createNamespace(global, alias.type);
            aliasProperty.setValue(aliasedProperty.getValue(Integer.MIN_VALUE, FILE_OFFSET), Integer.MIN_VALUE);
            ++n;
        }
    }

    private void processFunction(FunctionDocumentation functionDoc, boolean autoCreate) {
        String superType;
        String[] types;
        int fileIndex = Integer.MIN_VALUE;
        int offset = Range.Empty.getStartingOffset();
        String name = functionDoc.getName();
        String type = "";
        if (functionDoc.getMemberOf().getTypes().length > 0) {
            type = functionDoc.getMemberOf().getTypes()[0];
        }
        if (name.equals("#ctor")) {
            name = "constructor";
            functionDoc.setIsConstructor(true);
        } else {
            functionDoc.setIsConstructor(false);
        }
        IObject root = this._environment.getGlobal();
        IObject prototype = ObjectBase.UNDEFINED;
        JSFunctionConstructor gFn = (JSFunctionConstructor)root.getPropertyValue("Function", fileIndex, offset);
        if (type.equals("")) {
            prototype = root;
            functionDoc.getReturn().clearTypes();
            functionDoc.getReturn().addType(name);
        } else if (!type.equals("Global") && !type.equals("Window")) {
            IObject ob = root.getPropertyValue(type, fileIndex, offset);
            if (ob == ObjectBase.UNDEFINED) {
                root.putPropertyValue(type, gFn.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty), fileIndex, 6);
                ob = root.getPropertyValue(type, fileIndex, offset);
                FunctionDocumentation fDoc = new FunctionDocumentation();
                fDoc.setName(type);
                fDoc.setIsConstructor(true);
                ob.setDocumentation(fDoc);
            }
            root = ob;
            prototype = ob.getPropertyValue("prototype", fileIndex, offset);
        } else {
            prototype = root.getPropertyValue("prototype", fileIndex, offset);
            if (prototype == null || prototype == ObjectBase.UNDEFINED) {
                prototype = root;
            }
        }
        IObject lookup = prototype.getPropertyValue(name, fileIndex, offset);
        if (lookup == null || lookup == ObjectBase.UNDEFINED) {
            lookup = root.getPropertyValue(name, fileIndex, offset);
        }
        if (lookup == null || lookup == ObjectBase.UNDEFINED) {
            IObject newfn = gFn.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
            prototype.putPropertyValue(name, newfn, fileIndex, 6);
            lookup = newfn;
        }
        lookup.setDocumentation(functionDoc);
        if (functionDoc != null && functionDoc.getExtends() != null && (types = functionDoc.getExtends().getTypes()).length > 0 && !(superType = types[0]).equals("Object")) {
            Property prot;
            IObject superObj = this._environment.getGlobal().getPropertyValue(superType, fileIndex, 0);
            if (superObj == null || superObj instanceof JSUndefined) {
                superObj = gFn.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
                this._environment.getGlobal().putPropertyValue(superType, superObj, fileIndex, 6);
            }
            if (superObj != null && (prot = superObj.getProperty("prototype")) != null) {
                lookup.deletePropertyName("prototype");
                lookup.putPropertyValue("prototype", prot.getAssignment(0), fileIndex);
            }
        }
    }

    private void processProperty(PropertyDocumentation propertyDoc, boolean autoCreate) {
        String memberType;
        String[] types;
        int fileIndex = Integer.MIN_VALUE;
        int offset = Range.Empty.getStartingOffset();
        String name = propertyDoc.getName();
        String type = propertyDoc.getMemberOf().getTypes()[0];
        if (name.equals("Math")) {
            TypedDescription desc = propertyDoc.getReturn();
            desc.clearTypes();
            desc.addType("Math");
        }
        IObject root = this._environment.getGlobal();
        IObject prototype = ObjectBase.UNDEFINED;
        JSFunctionConstructor gFn = (JSFunctionConstructor)root.getPropertyValue("Function", fileIndex, offset);
        JSObjectConstructor gObj = (JSObjectConstructor)root.getPropertyValue("Object", fileIndex, offset);
        if (!type.equals("Global") && !type.equals("Window")) {
            IObject ob = root.getPropertyValue(type, fileIndex, offset);
            if (ob == ObjectBase.UNDEFINED) {
                root.putPropertyValue(type, gFn.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty), fileIndex, 6);
                ob = root.getPropertyValue(type, fileIndex, offset);
                FunctionDocumentation fDoc = new FunctionDocumentation();
                fDoc.setName(type);
                fDoc.setIsConstructor(true);
                ob.setDocumentation(fDoc);
            }
            root = ob;
            prototype = ob.getPropertyValue("prototype", fileIndex, offset);
        } else {
            prototype = root.getPropertyValue("prototype", fileIndex, offset);
        }
        IObject lookup = prototype.getPropertyValue(name, fileIndex, offset);
        if (!(lookup != null && lookup != ObjectBase.UNDEFINED || propertyDoc == null || propertyDoc.getIsInstance())) {
            lookup = root.getPropertyValue(name, fileIndex, offset);
        }
        if (lookup == null || lookup == ObjectBase.UNDEFINED) {
            IObject newobj = null;
            newobj = root instanceof IFunction ? ((IFunction)((Object)root)).construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty) : gObj.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
            prototype.putPropertyValue(name, newobj, fileIndex, 6);
            lookup = newobj;
        }
        lookup.setDocumentation(propertyDoc);
        if (propertyDoc != null && propertyDoc.getMemberOf() != null && (types = propertyDoc.getMemberOf().getTypes()).length > 0 && !(memberType = types[0]).equals("Object")) {
            Property prot;
            IObject memberObj = this._environment.getGlobal().getPropertyValue(memberType, fileIndex, 0);
            if (memberObj == null || memberObj instanceof JSUndefined) {
                memberObj = gFn.construct(this._environment, FunctionBase.EmptyArgs, fileIndex, (IRange)Range.Empty);
                this._environment.getGlobal().putPropertyValue(memberType, memberObj, fileIndex, 6);
            }
            if (memberObj != null && (prot = memberObj.getProperty("prototype")) != null) {
                lookup.deletePropertyName("prototype");
                lookup.putPropertyValue("prototype", prot.getAssignment(0), fileIndex);
            }
        }
    }

    public Map<String, TextAttribute> getNames() {
        return this.names;
    }
}

