/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.scriptdoc.parsing.reader;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.js.JSPlugin;
import com.aptana.ide.editor.js.runtime.Assignment;
import com.aptana.ide.editor.js.runtime.Environment;
import com.aptana.ide.editor.js.runtime.FunctionBase;
import com.aptana.ide.editor.js.runtime.IFunction;
import com.aptana.ide.editor.js.runtime.IObject;
import com.aptana.ide.editor.js.runtime.JSScope;
import com.aptana.ide.editor.js.runtime.NativeConstructorBase;
import com.aptana.ide.editor.js.runtime.ObjectBase;
import com.aptana.ide.editor.js.runtime.Property;
import com.aptana.ide.editor.js.runtime.Reference;
import com.aptana.ide.editor.scriptdoc.parsing.AliasEntry;
import com.aptana.ide.editor.scriptdoc.parsing.FunctionDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.MixinDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.PropertyDocumentation;
import com.aptana.ide.editor.scriptdoc.parsing.ScriptDoc;
import com.aptana.ide.editor.scriptdoc.parsing.TypedDescription;
import com.aptana.ide.editor.scriptdoc.parsing.reader.Messages;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocException;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocInitializationException;
import com.aptana.ide.editor.scriptdoc.parsing.reader.ScriptDocReader;
import com.aptana.ide.editor.scriptdoc.parsing.reader.SimpleDependencyGraph;
import com.aptana.ide.io.TabledInputStream;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.lexer.Range;
import com.aptana.ide.metadata.UserAgent;
import java.io.DataInput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class NativeObjectsReader2 {
    private static final String CONSTRUCTOR = "constructor";
    private static final String CTOR = "#ctor";
    private static final String EMPTY_STRING = "";
    private static final String GLOBAL = "Global";
    private static final String MATH = "Math";
    private static final String OBJECT = "Object";
    private static final String PROTOTYPE = "prototype";
    private static final String WINDOW = "Window";
    private static final int FILE_OFFSET = Range.Empty.getStartingOffset();
    private int _fileIndex;
    private Environment _environment;
    private ScriptDoc _docs;
    private String _userAgent;
    private List<Assignment> _assignments;

    public NativeObjectsReader2(Environment env) {
        this._environment = env;
        this._userAgent = EMPTY_STRING;
        this._fileIndex = Integer.MIN_VALUE;
        this._assignments = new ArrayList<Assignment>();
    }

    private void copyProperties(IObject source, IObject target) {
        if (source != null && source != ObjectBase.UNDEFINED && target != null && target != ObjectBase.UNDEFINED) {
            String[] names;
            String[] stringArray = names = source.getPropertyNames(true);
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String name = stringArray[n];
                if (!target.hasLocalProperty(name)) {
                    this.putLocalProperty(target, name, source.getProperty(name));
                }
                ++n;
            }
        }
    }

    private IObject createFunction() {
        return this._environment.createFunction(this._fileIndex, (IRange)Range.Empty);
    }

    private Reference createNamespace(IObject root, String fullyQualifiedType) {
        String[] parts = fullyQualifiedType.split("\\.");
        IObject current = root;
        int i = 0;
        while (i < parts.length - 1) {
            String propertyName = parts[i];
            if (current.hasProperty(propertyName)) {
                current = current.getPropertyValue(propertyName, this._fileIndex, FILE_OFFSET);
            } else {
                IObject instance = this._environment.createObject(this._fileIndex, (IRange)Range.Empty);
                this.putPropertyValue(current, propertyName, instance, 0);
                UserAgent ua = new UserAgent();
                ua.setDescription(EMPTY_STRING);
                ua.setOs(EMPTY_STRING);
                ua.setOsVersion(EMPTY_STRING);
                ua.setPlatform(this.getUserAgent());
                ua.setVersion(EMPTY_STRING);
                PropertyDocumentation documentation = new PropertyDocumentation();
                documentation.setName(propertyName);
                documentation.setUserAgent(this.getUserAgent());
                documentation.addUserAgent(ua);
                instance.setDocumentation(documentation);
                current = instance;
            }
            ++i;
        }
        String name = parts[parts.length - 1];
        return new Reference(current, name);
    }

    public Assignment[] getAssignments() {
        return this._assignments.toArray(new Assignment[this._assignments.size()]);
    }

    public int getFileIndex() {
        return this._fileIndex;
    }

    public ScriptDoc getScriptDoc() {
        return this._docs;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public void load(InputStream stream) throws IOException {
        this.load(stream, true);
    }

    public void load(InputStream stream, boolean autoCreate) throws IOException {
        this._docs = new ScriptDoc();
        TabledInputStream input = new TabledInputStream(stream);
        this._docs.read((DataInput)input);
        this.postProcess(autoCreate);
    }

    public void loadXML(InputStream stream) throws ScriptDocInitializationException, ScriptDocException {
        this.loadXML(stream, true);
    }

    public void loadXML(InputStream stream, boolean autoCreate) throws ScriptDocInitializationException, ScriptDocException {
        try {
            ScriptDocReader reader = new ScriptDocReader();
            reader.loadXML(stream);
            this._docs = reader.getDocumentation();
            this.postProcess(autoCreate);
        }
        catch (IllegalStateException e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Error loading ScriptDoc file", (Throwable)e);
        }
    }

    public void loadXML(String filename) throws ScriptDocInitializationException, ScriptDocException {
        this.loadXML(filename, true);
    }

    public void loadXML(String filename, boolean autoCreate) throws ScriptDocInitializationException, ScriptDocException {
        FileInputStream istream = null;
        try {
            try {
                istream = new FileInputStream(filename);
                this.loadXML(istream, autoCreate);
            }
            catch (IllegalStateException e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Error loading ScriptDoc file", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(Messages.NativeObjectsReader_UnalbeToLocateXMLFile) + filename;
                ScriptDocException de = new ScriptDocException(msg, e);
                throw de;
            }
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                String msg = Messages.NativeObjectsReader_IOError;
                ScriptDocException de = new ScriptDocException(msg, e);
                throw de;
            }
        }
    }

    private void postProcess(boolean autoCreate) {
        if (this._environment != null) {
            FunctionDocumentation[] functions = this._docs.getFunctions();
            IObject[] functionInstances = new IObject[functions.length];
            int i = 0;
            while (i < functions.length) {
                FunctionDocumentation currentFunction = functions[i];
                currentFunction.setUserAgent(this._userAgent);
                functionInstances[i] = this.processFunction(currentFunction, autoCreate);
                ++i;
            }
            PropertyDocumentation[] properties = this._docs.getProperties();
            int i2 = 0;
            while (i2 < properties.length) {
                PropertyDocumentation currentProperty = properties[i2];
                currentProperty.setUserAgent(this._userAgent);
                this.processProperty(currentProperty, autoCreate);
                ++i2;
            }
            this.processMixins(functions, functionInstances);
            this.processInheritance(functions, functionInstances);
            this.processAliases();
        }
    }

    private void processAliases() {
        JSScope global = this._environment.getGlobal();
        AliasEntry[] aliasEntryArray = this._docs.getAliases();
        int n = 0;
        int n2 = aliasEntryArray.length;
        while (n < n2) {
            AliasEntry alias = aliasEntryArray[n];
            Reference aliasProperty = this.createNamespace(global, alias.name);
            Reference aliasedProperty = this.createNamespace(global, alias.type);
            this.putPropertyValue(aliasProperty.getObjectBase(), aliasProperty.getPropertyName(), aliasedProperty.getValue(this._fileIndex, FILE_OFFSET), 0);
            ++n;
        }
    }

    private IObject processFunction(FunctionDocumentation documentation, boolean autoCreate) {
        IObject[] info = this.processOwningType(documentation);
        IObject root = info[0];
        IObject prototype = info[1];
        String name = documentation.getName();
        boolean dottedName = name.indexOf(46) != -1;
        IObject targetFunction = null;
        if (name.equals(CTOR)) {
            name = CONSTRUCTOR;
            documentation.setIsConstructor(true);
            targetFunction = root;
        }
        if (targetFunction == null && documentation.getIsInstance() && prototype.hasLocalProperty(name)) {
            targetFunction = prototype.getPropertyValue(name, this._fileIndex, FILE_OFFSET);
        }
        if ((targetFunction == null || targetFunction == ObjectBase.UNDEFINED) && dottedName) {
            Reference ref = this.createNamespace(root, name);
            name = ref.getPropertyName();
            root = ref.getObjectBase();
            prototype = root.getPropertyValue(PROTOTYPE, this._fileIndex, FILE_OFFSET);
            targetFunction = ref.getValue(this._fileIndex, FILE_OFFSET);
        }
        if ((targetFunction == null || targetFunction == ObjectBase.UNDEFINED) && root.hasLocalProperty(name)) {
            targetFunction = root.getPropertyValue(name, this._fileIndex, FILE_OFFSET);
        }
        if (targetFunction == null || targetFunction == ObjectBase.UNDEFINED) {
            IObject newFunction = this.createFunction();
            if (!documentation.getIsInstance()) {
                this.putPropertyValue(root, name, newFunction, 6);
            } else {
                this.putPropertyValue(prototype, name, newFunction, 6);
            }
            targetFunction = newFunction;
        }
        if (!(targetFunction instanceof NativeConstructorBase)) {
            targetFunction.setDocumentation(documentation);
        }
        return targetFunction;
    }

    private void processInheritance(FunctionDocumentation[] functions, IObject[] functionInstances) {
        FunctionDocumentationPair[] pairs;
        FunctionDocumentationPair[] functionDocumentationPairArray = pairs = this.sortByInheritanceDependency(functions, functionInstances);
        int n = 0;
        int n2 = functionDocumentationPairArray.length;
        while (n < n2) {
            TypedDescription typeInfo;
            FunctionDocumentationPair pair = functionDocumentationPairArray[n];
            IObject functionInstance = pair.getFunction();
            FunctionDocumentation documentation = pair.getDocumentation();
            String[] types = new String[]{};
            if (documentation != null && (typeInfo = documentation.getExtends()) != null) {
                types = typeInfo.getTypes();
            }
            int i = types.length - 1;
            while (i >= 0) {
                Reference ref;
                IObject superTypeConstructor;
                String superTypeName = types[i];
                if (!superTypeName.equals(OBJECT) && (superTypeConstructor = (ref = this.createNamespace(this._environment.getGlobal(), superTypeName)).getValue(this._fileIndex, FILE_OFFSET)) != null && superTypeConstructor != ObjectBase.UNDEFINED) {
                    Property parentPrototypeProperty = superTypeConstructor.getProperty(PROTOTYPE);
                    IObject parentPrototype = parentPrototypeProperty.getAssignment(0);
                    Property childPrototypeProperty = functionInstance.getProperty(PROTOTYPE);
                    IObject childPrototype = childPrototypeProperty.getAssignment(0);
                    this.copyProperties(parentPrototype, childPrototype);
                }
                --i;
            }
            ++n;
        }
    }

    private void processMixins(FunctionDocumentation[] functions, IObject[] functionInstances) {
        int i = 0;
        while (i < functions.length) {
            IObject functionInstance = functionInstances[i];
            FunctionDocumentation documentation = functions[i];
            MixinDocumentation[] mixins = new MixinDocumentation[]{};
            if (documentation != null) {
                mixins = documentation.getMixins();
            }
            int j = mixins.length - 1;
            while (j >= 0) {
                IObject sourceObject;
                MixinDocumentation mixin = mixins[j];
                String type = mixin.getType();
                if (!type.equals(OBJECT) && (sourceObject = this._environment.getGlobal().getPropertyValue(type, this._fileIndex, FILE_OFFSET)) != null && sourceObject != ObjectBase.UNDEFINED) {
                    IObject targetObject = functionInstance;
                    if (!mixin.getSourceInstanceProperties()) {
                        sourceObject = sourceObject.getProperty(PROTOTYPE).getAssignment(0);
                    }
                    if (!mixin.getTargetInstanceProperties()) {
                        targetObject = targetObject.getProperty(PROTOTYPE).getAssignment(0);
                    }
                    this.copyProperties(sourceObject, targetObject);
                }
                --j;
            }
            ++i;
        }
    }

    private IObject[] processOwningType(FunctionDocumentation documentation) {
        IObject root = this._environment.getGlobal();
        IObject prototype = ObjectBase.UNDEFINED;
        String owningType = EMPTY_STRING;
        if (documentation.getMemberOf().getTypes().length > 0) {
            owningType = documentation.getMemberOf().getTypes()[0];
        }
        if (owningType.equals(EMPTY_STRING)) {
            prototype = root;
            documentation.getReturn().clearTypes();
            documentation.getReturn().addType(documentation.getName());
        } else if (!owningType.equals(GLOBAL) && !owningType.equals(WINDOW)) {
            IObject ob = root.getPropertyValue(owningType, this._fileIndex, FILE_OFFSET);
            if (ob == ObjectBase.UNDEFINED && owningType.indexOf(46) != -1) {
                Reference ref = this.createNamespace(root, owningType);
                owningType = ref.getPropertyName();
                root = ref.getObjectBase();
                ob = ref.getValue(this._fileIndex, FILE_OFFSET);
            }
            if (ob == ObjectBase.UNDEFINED) {
                this.putPropertyValue(root, owningType, this.createFunction(), 6);
                FunctionDocumentation fDoc = new FunctionDocumentation();
                fDoc.setName(owningType);
                fDoc.setIsConstructor(true);
                ob = root.getPropertyValue(owningType, this._fileIndex, FILE_OFFSET);
                ob.setDocumentation(fDoc);
            }
            root = ob;
            prototype = ob.getPropertyValue(PROTOTYPE, this._fileIndex, FILE_OFFSET);
        } else {
            prototype = root.getPropertyValue(PROTOTYPE, this._fileIndex, FILE_OFFSET);
            if (prototype == null || prototype == ObjectBase.UNDEFINED) {
                prototype = root;
            }
        }
        return new IObject[]{root, prototype};
    }

    private void processProperty(PropertyDocumentation documentation, boolean autoCreate) {
        IObject[] info = this.processPropertyType(documentation);
        IObject root = info[0];
        IObject prototype = info[1];
        boolean isStatic = documentation != null && !documentation.getIsInstance();
        String name = documentation.getName();
        IObject propertyObject = null;
        if (!isStatic && prototype.hasLocalProperty(name)) {
            propertyObject = prototype.getPropertyValue(name, this._fileIndex, FILE_OFFSET);
        }
        if ((propertyObject == null || propertyObject == ObjectBase.UNDEFINED) && isStatic && root.hasLocalProperty(name)) {
            propertyObject = root.getPropertyValue(name, this._fileIndex, FILE_OFFSET);
        }
        if (propertyObject == null || propertyObject == ObjectBase.UNDEFINED) {
            String[] types = documentation.getReturn().getTypes();
            IObject type = null;
            IObject newobj = null;
            if (types != null && types.length > 0) {
                String typeName = types[0];
                Reference ref = this.createNamespace(this._environment.getGlobal(), typeName);
                type = ref.getValue(this._fileIndex, FILE_OFFSET);
            }
            newobj = type instanceof IFunction ? ((IFunction)((Object)type)).construct(this._environment, FunctionBase.EmptyArgs, this._fileIndex, (IRange)Range.Empty) : this._environment.createObject(this._fileIndex, (IRange)Range.Empty);
            if (isStatic) {
                this.putPropertyValue(root, name, newobj, 6);
            } else {
                this.putPropertyValue(prototype, name, newobj, 6);
            }
            propertyObject = newobj;
        }
        propertyObject.setDocumentation(documentation);
    }

    private IObject[] processPropertyType(PropertyDocumentation propertyDoc) {
        IObject root = this._environment.getGlobal();
        IObject prototype = ObjectBase.UNDEFINED;
        String name = propertyDoc.getName();
        String type = propertyDoc.getMemberOf().getTypes()[0];
        if (name.equals(MATH)) {
            TypedDescription desc = propertyDoc.getReturn();
            desc.clearTypes();
            desc.addType(MATH);
        }
        if (!type.equals(GLOBAL) && !type.equals(WINDOW)) {
            IObject ob = root.getPropertyValue(type, this._fileIndex, FILE_OFFSET);
            if (ob == ObjectBase.UNDEFINED && type.indexOf(46) != -1) {
                Reference ref = this.createNamespace(root, type);
                type = ref.getPropertyName();
                root = ref.getObjectBase();
                ob = ref.getValue(this._fileIndex, FILE_OFFSET);
            }
            if (ob == ObjectBase.UNDEFINED) {
                this.putPropertyValue(root, type, this.createFunction(), 6);
                FunctionDocumentation fDoc = new FunctionDocumentation();
                fDoc.setName(type);
                fDoc.setIsConstructor(true);
                ob = root.getPropertyValue(type, this._fileIndex, FILE_OFFSET);
                ob.setDocumentation(fDoc);
            }
            root = ob;
            prototype = ob.getPropertyValue(PROTOTYPE, this._fileIndex, FILE_OFFSET);
        } else {
            prototype = root.getPropertyValue(PROTOTYPE, this._fileIndex, FILE_OFFSET);
        }
        return new IObject[]{root, prototype};
    }

    private void putLocalProperty(IObject parentObject, String propertyName, Property property) {
        parentObject.putLocalProperty(propertyName, property);
        Reference reference = new Reference(parentObject, propertyName);
        Assignment assignment = new Assignment(reference, null);
        this._assignments.add(assignment);
    }

    private void putPropertyValue(IObject parentObject, String propertyName, IObject value, int attributes) {
        parentObject.putPropertyValue(propertyName, value, this._fileIndex, attributes);
        Reference reference = new Reference(parentObject, propertyName);
        Assignment assignment = new Assignment(reference, value);
        this._assignments.add(assignment);
    }

    public void setFileIndex(int fileIndex) {
        this._fileIndex = fileIndex;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    private FunctionDocumentationPair[] sortByInheritanceDependency(FunctionDocumentation[] functions, IObject[] functionInstances) {
        SimpleDependencyGraph<FunctionDocumentationPair> graph = new SimpleDependencyGraph<FunctionDocumentationPair>();
        int i = 0;
        while (i < functions.length) {
            FunctionDocumentationPair pair = new FunctionDocumentationPair(functionInstances[i], functions[i]);
            String type = pair.getTypeName();
            if (!CTOR.equals(type)) {
                graph.addMapping(type, pair);
                graph.addVertex(type);
            }
            ++i;
        }
        FunctionDocumentation[] functionDocumentationArray = functions;
        int pair = 0;
        int type = functionDocumentationArray.length;
        while (pair < type) {
            FunctionDocumentation documentation = functionDocumentationArray[pair];
            String type2 = documentation.getName();
            if (!CTOR.equals(type2)) {
                String[] stringArray = documentation.getExtends().getTypes();
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String superType = stringArray[n];
                    if (!OBJECT.equals(superType) && !CTOR.equals(superType)) {
                        graph.addEdge(type2, superType);
                    }
                    ++n;
                }
            }
            ++pair;
        }
        String[] types = graph.topologicalSort();
        FunctionDocumentationPair[] result = new FunctionDocumentationPair[types.length];
        int i2 = 0;
        while (i2 < types.length) {
            result[i2] = (FunctionDocumentationPair)graph.getItem(types[i2]);
            ++i2;
        }
        return result;
    }

    private class FunctionDocumentationPair {
        private IObject _function;
        private FunctionDocumentation _documentation;
        private String _typeName;

        public FunctionDocumentationPair(IObject function, FunctionDocumentation documentation) {
            this._function = function;
            this._documentation = documentation;
            this._typeName = this._documentation.getName();
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj == this) {
                result = true;
            } else if (obj instanceof FunctionDocumentation) {
                ((FunctionDocumentation)obj).getName().equals(this.getTypeName());
            }
            return result;
        }

        public FunctionDocumentation getDocumentation() {
            return this._documentation;
        }

        public IObject getFunction() {
            return this._function;
        }

        public String[] getSuperTypes() {
            return this._documentation.getExtends().getTypes();
        }

        public String getTypeName() {
            return this._typeName;
        }

        public int hashCode() {
            return this._typeName.hashCode();
        }
    }
}

